/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import jakarta.persistence.Access;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Cacheable;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.IdClass;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedEntityGraphs;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import jakarta.persistence.SecondaryTable;
import jakarta.persistence.SecondaryTables;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.Table;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.DiscriminatorOptions;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.RowId;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotatedDiscriminatorColumn;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.IdGeneratorResolverSecondPass;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.JoinedSubclassFkSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondaryTableFromAnnotationSecondPass;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.cfg.internal.NullableDiscriminatorColumnSecondPass;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.event.internal.CallbackDefinitionResolverLegacyImpl;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class EntityBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityBinder.class.getName());
    private static final String NATURAL_ID_CACHE_SUFFIX = "##NaturalId";
    private MetadataBuildingContext context;
    private String name;
    private XClass annotatedClass;
    private PersistentClass persistentClass;
    private String discriminatorValue = "";
    private Boolean forceDiscriminator;
    private Boolean insertableDiscriminator;
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private OptimisticLockType optimisticLockType;
    private PolymorphismType polymorphismType;
    private boolean selectBeforeUpdate;
    private int batchSize;
    private boolean lazy;
    private XClass proxyClass;
    private String where;
    private final Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private final Map<String, Join> secondaryTablesFromAnnotation = new HashMap<String, Join>();
    private final Map<String, Object> secondaryTableFromAnnotationJoins = new HashMap<String, Object>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private boolean ignoreIdAnnotations;
    private AccessType propertyAccessType = AccessType.DEFAULT;
    private boolean wrapIdsInEmbeddedComponents;
    private String subselect;
    private boolean isCached;
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private boolean cacheLazyProperty;
    private String naturalIdCacheRegion;

    public static void bindEntityClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, HashMap<String, IdentifierGeneratorDefinition> classGenerators, MetadataBuildingContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding entity from annotated class: %s", clazzToProcess.getName());
        }
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        PersistentClass superEntity = EntityBinder.getSuperEntity(clazzToProcess, inheritanceStatePerClass, context, inheritanceState);
        EntityBinder.detectedAttributeOverrideProblem(clazzToProcess, superEntity);
        PersistentClass persistentClass = EntityBinder.makePersistentClass(inheritanceState, superEntity, context);
        EntityBinder entityBinder = new EntityBinder(clazzToProcess, persistentClass, context);
        AnnotatedJoinColumn[] inheritanceJoinedColumns = EntityBinder.makeInheritanceJoinColumns(clazzToProcess, context, inheritanceState, superEntity);
        AnnotatedDiscriminatorColumn discriminatorColumn = EntityBinder.handleDiscriminatorColumn(clazzToProcess, context, inheritanceState, entityBinder);
        entityBinder.setProxy((Proxy)clazzToProcess.getAnnotation(Proxy.class));
        entityBinder.setBatchSize((BatchSize)clazzToProcess.getAnnotation(BatchSize.class));
        entityBinder.setWhere(BinderHelper.getOverridableAnnotation((XAnnotatedElement)clazzToProcess, Where.class, context));
        entityBinder.applyCaching(clazzToProcess, context.getBuildingOptions().getSharedCacheMode(), context);
        EntityBinder.bindFiltersAndFilterDefs(clazzToProcess, entityBinder, context);
        entityBinder.bindEntity();
        Table table = EntityBinder.handleClassTable(clazzToProcess, context, inheritanceState, superEntity, entityBinder);
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, context, inheritanceStatePerClass);
        EntityBinder.handleSecondaryTables(clazzToProcess, entityBinder);
        EntityBinder.handleInheritance(clazzToProcess, context, inheritanceState, persistentClass, entityBinder, inheritanceJoinedColumns, discriminatorColumn, propertyHolder);
        InheritanceState.ElementsToProcess elementsToProcess = inheritanceState.getElementsToProcess();
        inheritanceState.postProcess(persistentClass, entityBinder);
        Set<String> idPropertiesIfIdClass = EntityBinder.handleIdClass(persistentClass, inheritanceState, context, entityBinder, propertyHolder, elementsToProcess, inheritanceStatePerClass);
        EntityBinder.processIdPropertiesIfNotAlready(persistentClass, inheritanceState, context, entityBinder, propertyHolder, classGenerators, idPropertiesIfIdClass, elementsToProcess, inheritanceStatePerClass);
        if (persistentClass instanceof RootClass) {
            context.getMetadataCollector().addSecondPass(new CreateKeySecondPass((RootClass)persistentClass));
        }
        if (persistentClass instanceof Subclass) {
            assert (superEntity != null);
            superEntity.addSubclass((Subclass)persistentClass);
        }
        context.getMetadataCollector().addEntityBinding(persistentClass);
        context.getMetadataCollector().addSecondPass(new SecondaryTableFromAnnotationSecondPass(entityBinder, propertyHolder, (XAnnotatedElement)clazzToProcess));
        context.getMetadataCollector().addSecondPass(new SecondaryTableSecondPass(entityBinder, propertyHolder, (XAnnotatedElement)clazzToProcess));
        EntityBinder.processComplementaryTableDefinitions(clazzToProcess, entityBinder, table);
        EntityBinder.bindCallbacks(clazzToProcess, persistentClass, context);
    }

    private static void processComplementaryTableDefinitions(XClass clazzToProcess, EntityBinder entityBinder, Table tabAnn) {
        entityBinder.processComplementaryTableDefinitions((org.hibernate.annotations.Table)clazzToProcess.getAnnotation(org.hibernate.annotations.Table.class));
        entityBinder.processComplementaryTableDefinitions((Tables)clazzToProcess.getAnnotation(Tables.class));
        entityBinder.processComplementaryTableDefinitions(tabAnn);
    }

    private static void detectedAttributeOverrideProblem(XClass clazzToProcess, PersistentClass superEntity) {
        if (superEntity != null && (clazzToProcess.isAnnotationPresent(AttributeOverride.class) || clazzToProcess.isAnnotationPresent(AttributeOverrides.class))) {
            LOG.unsupportedAttributeOverrideWithEntityInheritance(clazzToProcess.getName());
        }
    }

    private static Set<String> handleIdClass(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, EntityBinder entityBinder, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        HashSet<String> idPropertiesIfIdClass = new HashSet<String>();
        boolean isIdClass = EntityBinder.mapAsIdClass(inheritanceStatePerClass, inheritanceState, persistentClass, entityBinder, propertyHolder, elementsToProcess, idPropertiesIfIdClass, context);
        if (!isIdClass) {
            entityBinder.setWrapIdsInEmbeddedComponents(elementsToProcess.getIdPropertyCount() > 1);
        }
        return idPropertiesIfIdClass;
    }

    private static boolean mapAsIdClass(Map<XClass, InheritanceState> inheritanceStatePerClass, InheritanceState inheritanceState, PersistentClass persistentClass, EntityBinder entityBinder, PropertyHolder propertyHolder, InheritanceState.ElementsToProcess elementsToProcess, Set<String> idPropertiesIfIdClass, MetadataBuildingContext context) {
        XClass classWithIdClass = inheritanceState.getClassWithIdClass(false);
        if (classWithIdClass != null) {
            AccessType propertyAccessor;
            PropertyPreloadedData baseInferredData;
            PropertyPreloadedData inferredData;
            IdClass idClass = (IdClass)classWithIdClass.getAnnotation(IdClass.class);
            XClass compositeClass = context.getBootstrapContext().getReflectionManager().toXClass(idClass.value());
            boolean isFakeIdClass = EntityBinder.isIdClassPkOfTheAssociatedEntity(elementsToProcess, compositeClass, inferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", compositeClass), baseInferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", classWithIdClass), propertyAccessor = entityBinder.getPropertyAccessor((XAnnotatedElement)compositeClass), inheritanceStatePerClass, context);
            if (isFakeIdClass) {
                return false;
            }
            boolean ignoreIdAnnotations = entityBinder.isIgnoreIdAnnotations();
            entityBinder.setIgnoreIdAnnotations(true);
            propertyHolder.setInIdClass(true);
            EntityBinder.bindIdClass(inferredData, baseInferredData, propertyHolder, propertyAccessor, entityBinder, context, inheritanceStatePerClass);
            propertyHolder.setInIdClass(null);
            Component mapper = AnnotationBinder.fillComponent(propertyHolder, new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass), baseInferredData, propertyAccessor, false, entityBinder, true, true, false, null, null, context, inheritanceStatePerClass);
            entityBinder.setIgnoreIdAnnotations(ignoreIdAnnotations);
            persistentClass.setIdentifierMapper(mapper);
            MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(classWithIdClass, inheritanceStatePerClass, context);
            if (superclass != null) {
                superclass.setDeclaredIdentifierMapper(mapper);
            } else {
                persistentClass.setDeclaredIdentifierMapper(mapper);
            }
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue(mapper);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
            entityBinder.setIgnoreIdAnnotations(true);
            for (Property prop : mapper.getProperties()) {
                idPropertiesIfIdClass.add(prop.getName());
            }
            return true;
        }
        return false;
    }

    private static boolean isIdClassPkOfTheAssociatedEntity(InheritanceState.ElementsToProcess elementsToProcess, XClass compositeClass, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) {
        if (elementsToProcess.getIdPropertyCount() == 1) {
            PropertyData idPropertyOnBaseClass = AnnotationBinder.getUniqueIdPropertyFromBaseClass(inferredData, baseInferredData, propertyAccessor, context);
            InheritanceState state = inheritanceStatePerClass.get(idPropertyOnBaseClass.getClassOrElement());
            if (state == null) {
                return false;
            }
            XClass associatedClassWithIdClass = state.getClassWithIdClass(true);
            if (associatedClassWithIdClass == null) {
                return BinderHelper.hasToOneAnnotation((XAnnotatedElement)idPropertyOnBaseClass.getProperty());
            }
            IdClass idClass = (IdClass)associatedClassWithIdClass.getAnnotation(IdClass.class);
            return context.getBootstrapContext().getReflectionManager().toXClass(idClass.value()).equals(compositeClass);
        }
        return false;
    }

    private static void bindIdClass(PropertyData inferredData, PropertyData baseInferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, MetadataBuildingContext buildingContext, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' is a subclass in an entity inheritance hierarchy and may not redefine the identifier of the root entity");
        }
        RootClass rootClass = (RootClass)persistentClass;
        Component id = AnnotationBinder.fillComponent(propertyHolder, inferredData, baseInferredData, propertyAccessor, false, entityBinder, true, false, false, null, null, buildingContext, inheritanceStatePerClass);
        id.setKey(true);
        if (rootClass.getIdentifier() != null) {
            throw new AssertionFailure("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' and may not have an identifier property");
        }
        if (id.getPropertySpan() == 0) {
            throw new AnnotationException("Class '" + id.getComponentClassName() + " is the '@IdClass' for the entity '" + persistentClass.getEntityName() + "' but has no persistent properties");
        }
        rootClass.setIdentifier(id);
        if (buildingContext.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            IdGeneratorResolverSecondPass secondPass = new IdGeneratorResolverSecondPass(id, inferredData.getProperty(), "assigned", "", buildingContext);
            buildingContext.getMetadataCollector().addSecondPass(secondPass);
        } else {
            BinderHelper.makeIdGenerator((SimpleValue)id, inferredData.getProperty(), "assigned", "", buildingContext, Collections.emptyMap());
        }
        rootClass.setEmbeddedIdentifier(inferredData.getPropertyClass() == null);
    }

    private static AnnotatedDiscriminatorColumn handleDiscriminatorColumn(XClass clazzToProcess, MetadataBuildingContext context, InheritanceState inheritanceState, EntityBinder entityBinder) {
        switch (inheritanceState.getType()) {
            case SINGLE_TABLE: {
                return EntityBinder.processSingleTableDiscriminatorProperties(clazzToProcess, context, inheritanceState, entityBinder);
            }
            case JOINED: {
                return EntityBinder.processJoinedDiscriminatorProperties(clazzToProcess, context, inheritanceState, entityBinder);
            }
        }
        return null;
    }

    private static void handleSecondaryTables(XClass clazzToProcess, EntityBinder entityBinder) {
        SecondaryTable secTable = (SecondaryTable)clazzToProcess.getAnnotation(SecondaryTable.class);
        SecondaryTables secTables = (SecondaryTables)clazzToProcess.getAnnotation(SecondaryTables.class);
        if (secTables != null) {
            for (SecondaryTable tab : secTables.value()) {
                entityBinder.addJoin(tab, null, false);
            }
        } else if (secTable != null) {
            entityBinder.addJoin(secTable, null, false);
        }
    }

    private static Table handleClassTable(XClass clazzToProcess, MetadataBuildingContext context, InheritanceState inheritanceState, PersistentClass superEntity, EntityBinder entityBinder) {
        String catalog;
        String schema;
        String table;
        Table tableAnnotation;
        ArrayList<UniqueConstraintHolder> uniqueConstraints = new ArrayList();
        boolean hasTableAnnotation = clazzToProcess.isAnnotationPresent(Table.class);
        if (hasTableAnnotation) {
            tableAnnotation = (Table)clazzToProcess.getAnnotation(Table.class);
            table = tableAnnotation.name();
            schema = tableAnnotation.schema();
            catalog = tableAnnotation.catalog();
            uniqueConstraints = TableBinder.buildUniqueConstraintHolders(tableAnnotation.uniqueConstraints());
        } else {
            tableAnnotation = null;
            schema = "";
            table = "";
            catalog = "";
        }
        if (inheritanceState.hasTable()) {
            Check checkAnn = BinderHelper.getOverridableAnnotation((XAnnotatedElement)clazzToProcess, Check.class, context);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            InFlightMetadataCollector.EntityTableXref denormalizedTableXref = inheritanceState.hasDenormalizedTable() ? context.getMetadataCollector().getEntityTableXref(superEntity.getEntityName()) : null;
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints, denormalizedTableXref);
        } else {
            if (hasTableAnnotation) {
                LOG.invalidTableAnnotation(clazzToProcess.getName());
            }
            if (inheritanceState.getType() == InheritanceType.SINGLE_TABLE) {
                entityBinder.bindTableForDiscriminatedSubclass(context.getMetadataCollector().getEntityTableXref(superEntity.getEntityName()));
            }
        }
        return tableAnnotation;
    }

    private static void handleInheritance(XClass clazzToProcess, MetadataBuildingContext context, InheritanceState inheritanceState, PersistentClass persistentClass, EntityBinder entityBinder, AnnotatedJoinColumn[] inheritanceJoinedColumns, AnnotatedDiscriminatorColumn discriminatorColumn, PropertyHolder propertyHolder) {
        OnDelete onDeleteAnn = (OnDelete)clazzToProcess.getAnnotation(OnDelete.class);
        boolean isInheritanceRoot = !inheritanceState.hasParents();
        boolean hasSubclasses = inheritanceState.hasSiblings();
        boolean onDeleteAppropriate = false;
        switch (inheritanceState.getType()) {
            case JOINED: {
                if (inheritanceState.hasParents()) {
                    onDeleteAppropriate = true;
                    JoinedSubclass jsc = (JoinedSubclass)persistentClass;
                    DependantValue key = new DependantValue(context, jsc.getTable(), jsc.getIdentifier());
                    jsc.setKey(key);
                    EntityBinder.handleForeignKeys(clazzToProcess, context, key);
                    key.setCascadeDeleteEnabled(onDeleteAnn != null && OnDeleteAction.CASCADE == onDeleteAnn.action());
                    context.getMetadataCollector().addSecondPass(new JoinedSubclassFkSecondPass(jsc, inheritanceJoinedColumns, key, context));
                    context.getMetadataCollector().addSecondPass(new CreateKeySecondPass(jsc));
                }
                if (!isInheritanceRoot || discriminatorColumn == null || !hasSubclasses && discriminatorColumn.isImplicit()) break;
                EntityBinder.bindDiscriminatorColumnToRootPersistentClass((RootClass)persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder, context);
                entityBinder.bindDiscriminatorValue();
                break;
            }
            case SINGLE_TABLE: {
                if (!isInheritanceRoot || !hasSubclasses && (discriminatorColumn == null || discriminatorColumn.isImplicit())) break;
                EntityBinder.bindDiscriminatorColumnToRootPersistentClass((RootClass)persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder, context);
                entityBinder.bindDiscriminatorValue();
            }
        }
        if (onDeleteAnn != null && !onDeleteAppropriate) {
            LOG.invalidOnDeleteAnnotation(propertyHolder.getEntityName());
        }
    }

    private static void handleForeignKeys(XClass clazzToProcess, MetadataBuildingContext context, DependantValue key) {
        ForeignKey foreignKey = (ForeignKey)clazzToProcess.getAnnotation(ForeignKey.class);
        if (foreignKey != null && !BinderHelper.isEmptyAnnotationValue(foreignKey.name())) {
            key.setForeignKeyName(foreignKey.name());
        } else {
            PrimaryKeyJoinColumn pkJoinColumn = (PrimaryKeyJoinColumn)clazzToProcess.getAnnotation(PrimaryKeyJoinColumn.class);
            PrimaryKeyJoinColumns pkJoinColumns = (PrimaryKeyJoinColumns)clazzToProcess.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean noConstraintByDefault = context.getBuildingOptions().isNoConstraintByDefault();
            if (pkJoinColumns != null && (pkJoinColumns.foreignKey().value() == ConstraintMode.NO_CONSTRAINT || pkJoinColumns.foreignKey().value() == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault)) {
                key.disableForeignKey();
            } else if (pkJoinColumns != null && !StringHelper.isEmpty(pkJoinColumns.foreignKey().name())) {
                key.setForeignKeyName(pkJoinColumns.foreignKey().name());
                if (!BinderHelper.isEmptyAnnotationValue(pkJoinColumns.foreignKey().foreignKeyDefinition())) {
                    key.setForeignKeyDefinition(pkJoinColumns.foreignKey().foreignKeyDefinition());
                }
            } else if (pkJoinColumn != null && (pkJoinColumn.foreignKey().value() == ConstraintMode.NO_CONSTRAINT || pkJoinColumn.foreignKey().value() == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault)) {
                key.disableForeignKey();
            } else if (pkJoinColumn != null && !StringHelper.isEmpty(pkJoinColumn.foreignKey().name())) {
                key.setForeignKeyName(pkJoinColumn.foreignKey().name());
                if (!BinderHelper.isEmptyAnnotationValue(pkJoinColumn.foreignKey().foreignKeyDefinition())) {
                    key.setForeignKeyDefinition(pkJoinColumn.foreignKey().foreignKeyDefinition());
                }
            }
        }
    }

    private static void bindDiscriminatorColumnToRootPersistentClass(RootClass rootClass, AnnotatedDiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, MetadataBuildingContext context) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            BasicValue discriminatorColumnBinding = new BasicValue(context, rootClass.getTable());
            rootClass.setDiscriminator(discriminatorColumnBinding);
            discriminatorColumn.linkWithValue(discriminatorColumnBinding);
            discriminatorColumnBinding.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Setting discriminator for entity {0}", rootClass.getEntityName());
            }
            context.getMetadataCollector().addSecondPass(new NullableDiscriminatorColumnSecondPass(rootClass.getEntityName()));
        }
    }

    private static AnnotatedDiscriminatorColumn processSingleTableDiscriminatorProperties(XClass clazzToProcess, MetadataBuildingContext context, InheritanceState inheritanceState, EntityBinder entityBinder) {
        boolean isRoot = !inheritanceState.hasParents();
        AnnotatedDiscriminatorColumn discriminatorColumn = null;
        DiscriminatorColumn discAnn = (DiscriminatorColumn)clazzToProcess.getAnnotation(DiscriminatorColumn.class);
        DiscriminatorType discriminatorType = discAnn != null ? discAnn.discriminatorType() : DiscriminatorType.STRING;
        DiscriminatorFormula discFormulaAnn = BinderHelper.getOverridableAnnotation((XAnnotatedElement)clazzToProcess, DiscriminatorFormula.class, context);
        if (isRoot) {
            discriminatorColumn = AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discAnn, discFormulaAnn, context);
        }
        if (discAnn != null && !isRoot) {
            LOG.invalidDiscriminatorAnnotation(clazzToProcess.getName());
        }
        String discriminatorValue = clazzToProcess.isAnnotationPresent(DiscriminatorValue.class) ? ((DiscriminatorValue)clazzToProcess.getAnnotation(DiscriminatorValue.class)).value() : null;
        entityBinder.setDiscriminatorValue(discriminatorValue);
        DiscriminatorOptions discriminatorOptions = (DiscriminatorOptions)clazzToProcess.getAnnotation(DiscriminatorOptions.class);
        if (discriminatorOptions != null) {
            entityBinder.setForceDiscriminator(discriminatorOptions.force());
            entityBinder.setInsertableDiscriminator(discriminatorOptions.insert());
        }
        return discriminatorColumn;
    }

    private static AnnotatedDiscriminatorColumn processJoinedDiscriminatorProperties(XClass clazzToProcess, MetadataBuildingContext context, InheritanceState inheritanceState, EntityBinder entityBinder) {
        if (clazzToProcess.isAnnotationPresent(DiscriminatorFormula.class)) {
            throw new MappingException("@DiscriminatorFormula on joined inheritance not supported at this time");
        }
        DiscriminatorValue discriminatorValueAnnotation = (DiscriminatorValue)clazzToProcess.getAnnotation(DiscriminatorValue.class);
        String discriminatorValue = discriminatorValueAnnotation != null ? ((DiscriminatorValue)clazzToProcess.getAnnotation(DiscriminatorValue.class)).value() : null;
        entityBinder.setDiscriminatorValue(discriminatorValue);
        DiscriminatorColumn discriminatorColumnAnnotation = (DiscriminatorColumn)clazzToProcess.getAnnotation(DiscriminatorColumn.class);
        if (!inheritanceState.hasParents()) {
            boolean generateDiscriminatorColumn;
            if (discriminatorColumnAnnotation != null) {
                boolean bl = generateDiscriminatorColumn = !context.getBuildingOptions().ignoreExplicitDiscriminatorsForJoinedInheritance();
                if (generateDiscriminatorColumn) {
                    LOG.applyingExplicitDiscriminatorColumnForJoined(clazzToProcess.getName(), "hibernate.discriminator.ignore_explicit_for_joined");
                } else {
                    LOG.debugf("Ignoring explicit DiscriminatorColumn annotation on: %s", clazzToProcess.getName());
                }
            } else {
                generateDiscriminatorColumn = context.getBuildingOptions().createImplicitDiscriminatorsForJoinedInheritance();
                if (generateDiscriminatorColumn) {
                    LOG.debug("Applying implicit DiscriminatorColumn using DiscriminatorColumn defaults");
                } else {
                    LOG.debug("Ignoring implicit (absent) DiscriminatorColumn");
                }
            }
            if (generateDiscriminatorColumn) {
                return AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumnAnnotation != null ? discriminatorColumnAnnotation.discriminatorType() : DiscriminatorType.STRING, discriminatorColumnAnnotation, null, context);
            }
        } else if (discriminatorColumnAnnotation != null) {
            LOG.invalidDiscriminatorAnnotation(clazzToProcess.getName());
        }
        return null;
    }

    private static void processIdPropertiesIfNotAlready(PersistentClass persistentClass, InheritanceState inheritanceState, MetadataBuildingContext context, EntityBinder entityBinder, PropertyHolder propertyHolder, HashMap<String, IdentifierGeneratorDefinition> classGenerators, Set<String> idPropertiesIfIdClass, InheritanceState.ElementsToProcess elementsToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        HashSet<String> missingIdProperties = new HashSet<String>(idPropertiesIfIdClass);
        for (PropertyData propertyAnnotatedElement : elementsToProcess.getElements()) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idPropertiesIfIdClass.contains(propertyName)) {
                boolean subclassAndSingleTableStrategy = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
                AnnotationBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement, classGenerators, entityBinder, false, false, false, context, inheritanceStatePerClass);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (missingIdProperties.size() != 0) {
            StringBuilder missings = new StringBuilder();
            for (String property : missingIdProperties) {
                if (missings.length() > 0) {
                    missings.append(", ");
                }
                missings.append("'").append(property).append("'");
            }
            throw new AnnotationException("Entity '" + persistentClass.getEntityName() + "' has an '@IdClass' with properties " + missings + " which do not match properties of the entity class");
        }
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity, MetadataBuildingContext metadataBuildingContext) {
        if (!inheritanceState.hasParents()) {
            return new RootClass(metadataBuildingContext);
        }
        switch (inheritanceState.getType()) {
            case SINGLE_TABLE: {
                return new SingleTableSubclass(superEntity, metadataBuildingContext);
            }
            case JOINED: {
                return new JoinedSubclass(superEntity, metadataBuildingContext);
            }
            case TABLE_PER_CLASS: {
                return new UnionSubclass(superEntity, metadataBuildingContext);
            }
        }
        throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.getType());
    }

    private static AnnotatedJoinColumn[] makeInheritanceJoinColumns(XClass clazzToProcess, MetadataBuildingContext context, InheritanceState inheritanceState, PersistentClass superEntity) {
        boolean hasJoinedColumns;
        AnnotatedJoinColumn[] inheritanceJoinedColumns = null;
        boolean bl = hasJoinedColumns = inheritanceState.hasParents() && InheritanceType.JOINED == inheritanceState.getType();
        if (hasJoinedColumns) {
            boolean explicitInheritanceJoinedColumns;
            PrimaryKeyJoinColumns jcsAnn = (PrimaryKeyJoinColumns)clazzToProcess.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
            if (explicitInheritanceJoinedColumns) {
                int nbrOfInhJoinedColumns = jcsAnn.value().length;
                inheritanceJoinedColumns = new AnnotatedJoinColumn[nbrOfInhJoinedColumns];
                for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                    PrimaryKeyJoinColumn jcAnn = jcsAnn.value()[colIndex];
                    inheritanceJoinedColumns[colIndex] = AnnotatedJoinColumn.buildJoinColumn(jcAnn, null, superEntity.getIdentifier(), null, null, context);
                }
            } else {
                PrimaryKeyJoinColumn jcAnn = (PrimaryKeyJoinColumn)clazzToProcess.getAnnotation(PrimaryKeyJoinColumn.class);
                inheritanceJoinedColumns = new AnnotatedJoinColumn[]{AnnotatedJoinColumn.buildJoinColumn(jcAnn, null, superEntity.getIdentifier(), null, null, context)};
            }
            LOG.trace("Subclass joined column(s) created");
        } else if (clazzToProcess.isAnnotationPresent(PrimaryKeyJoinColumns.class) || clazzToProcess.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            LOG.invalidPrimaryKeyJoinColumnAnnotation(clazzToProcess.getName());
        }
        return inheritanceJoinedColumns;
    }

    private static PersistentClass getSuperEntity(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context, InheritanceState inheritanceState) {
        PersistentClass superEntity;
        InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazzToProcess, inheritanceStatePerClass);
        PersistentClass persistentClass = superEntity = superEntityState != null ? context.getMetadataCollector().getEntityBinding(superEntityState.getClazz().getName()) : null;
        if (superEntity == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be bound after its parent class: " + superEntityState.getClazz().getName());
        }
        return superEntity;
    }

    private static void bindCallbacks(XClass entityClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        ReflectionManager reflectionManager = context.getBootstrapContext().getReflectionManager();
        for (CallbackType callbackType : CallbackType.values()) {
            persistentClass.addCallbackDefinitions(CallbackDefinitionResolverLegacyImpl.resolveEntityCallbacks(reflectionManager, entityClass, callbackType));
        }
        context.getMetadataCollector().addSecondPass(persistentClasses -> {
            for (Property property : persistentClass.getDeclaredProperties()) {
                if (!property.isComposite()) continue;
                for (CallbackType callbackType : CallbackType.values()) {
                    property.addCallbackDefinitions(CallbackDefinitionResolverLegacyImpl.resolveEmbeddableCallbacks(reflectionManager, persistentClass.getMappedClass(), property, callbackType));
                }
            }
        });
    }

    public boolean wrapIdsInEmbeddedComponents() {
        return this.wrapIdsInEmbeddedComponents;
    }

    public EntityBinder() {
    }

    public EntityBinder(XClass annotatedClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        this.context = context;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
        this.bindEntityAnnotation();
        this.bindHibernateAnnotation();
    }

    public boolean isPropertyDefinedInSuperHierarchy(String name) {
        return this.persistentClass != null && this.persistentClass.isPropertyDefinedInSuperHierarchy(name);
    }

    private void bindHibernateAnnotation() {
        DynamicInsert dynamicInsertAnn = (DynamicInsert)this.annotatedClass.getAnnotation(DynamicInsert.class);
        this.dynamicInsert = dynamicInsertAnn != null && dynamicInsertAnn.value();
        DynamicUpdate dynamicUpdateAnn = (DynamicUpdate)this.annotatedClass.getAnnotation(DynamicUpdate.class);
        this.dynamicUpdate = dynamicUpdateAnn != null && dynamicUpdateAnn.value();
        SelectBeforeUpdate selectBeforeUpdateAnn = (SelectBeforeUpdate)this.annotatedClass.getAnnotation(SelectBeforeUpdate.class);
        this.selectBeforeUpdate = selectBeforeUpdateAnn != null && selectBeforeUpdateAnn.value();
        OptimisticLocking optimisticLockingAnn = (OptimisticLocking)this.annotatedClass.getAnnotation(OptimisticLocking.class);
        this.optimisticLockType = optimisticLockingAnn == null ? OptimisticLockType.VERSION : optimisticLockingAnn.type();
        Polymorphism polymorphismAnn = (Polymorphism)this.annotatedClass.getAnnotation(Polymorphism.class);
        this.polymorphismType = polymorphismAnn == null ? PolymorphismType.IMPLICIT : polymorphismAnn.type();
    }

    private void bindEntityAnnotation() {
        Entity entity = (Entity)this.annotatedClass.getAnnotation(Entity.class);
        if (entity == null) {
            throw new AssertionFailure("@Entity should never be missing");
        }
        this.name = BinderHelper.isEmptyAnnotationValue(entity.name()) ? StringHelper.unqualify(this.annotatedClass.getName()) : entity.name();
    }

    public boolean isRootEntity() {
        return this.persistentClass instanceof RootClass;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void setForceDiscriminator(boolean forceDiscriminator) {
        this.forceDiscriminator = forceDiscriminator;
    }

    public void setInsertableDiscriminator(boolean insertableDiscriminator) {
        this.insertableDiscriminator = insertableDiscriminator;
    }

    public void bindEntity() {
        this.persistentClass.setAbstract(this.annotatedClass.isAbstract());
        this.persistentClass.setClassName(this.annotatedClass.getName());
        this.persistentClass.setJpaEntityName(this.name);
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.bindDiscriminatorValue();
        this.persistentClass.setLazy(this.lazy);
        if (this.proxyClass != null) {
            this.persistentClass.setProxyInterfaceName(this.proxyClass.getName());
        }
        this.persistentClass.setDynamicInsert(this.dynamicInsert);
        this.persistentClass.setDynamicUpdate(this.dynamicUpdate);
        if (this.persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)this.persistentClass;
            boolean mutable = !this.annotatedClass.isAnnotationPresent(Immutable.class);
            rootClass.setMutable(mutable);
            rootClass.setExplicitPolymorphism(this.isExplicitPolymorphism(this.polymorphismType));
            if (StringHelper.isNotEmpty(this.where)) {
                rootClass.setWhere(this.where);
            }
            if (this.cacheConcurrentStrategy != null) {
                rootClass.setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
                rootClass.setCacheRegionName(this.cacheRegion);
                rootClass.setLazyPropertiesCacheable(this.cacheLazyProperty);
            }
            rootClass.setNaturalIdCacheRegionName(this.naturalIdCacheRegion);
            boolean forceDiscriminatorInSelects = this.forceDiscriminator == null ? this.context.getBuildingOptions().shouldImplicitlyForceDiscriminatorInSelect() : this.forceDiscriminator.booleanValue();
            rootClass.setForceDiscriminator(forceDiscriminatorInSelects);
            if (this.insertableDiscriminator != null) {
                rootClass.setDiscriminatorInsertable(this.insertableDiscriminator);
            }
        } else if (this.annotatedClass.isAnnotationPresent(Immutable.class)) {
            LOG.immutableAnnotationOnNonRoot(this.annotatedClass.getName());
        }
        this.persistentClass.setCached(this.isCached);
        this.persistentClass.setOptimisticLockStyle(this.getVersioning(this.optimisticLockType));
        this.persistentClass.setSelectBeforeUpdate(this.selectBeforeUpdate);
        this.bindCustomPersister();
        this.persistentClass.setBatchSize(this.batchSize);
        this.bindCustomSql();
        this.bindSynchronize();
        this.bindhandleFilters();
        LOG.debugf("Import with entity name %s", this.name);
        try {
            this.context.getMetadataCollector().addImport(this.name, this.persistentClass.getEntityName());
            String entityName = this.persistentClass.getEntityName();
            if (!entityName.equals(this.name)) {
                this.context.getMetadataCollector().addImport(entityName, entityName);
            }
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, (Throwable)((Object)me));
        }
        this.processNamedEntityGraphs();
    }

    private void bindCustomSql() {
        Subselect subselect;
        Loader loader;
        SQLDeleteAll sqlDeleteAll;
        SQLDelete sqlDelete;
        SQLUpdate sqlUpdate;
        SQLInsert sqlInsert = (SQLInsert)this.annotatedClass.getAnnotation(SQLInsert.class);
        if (sqlInsert != null) {
            this.persistentClass.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlInsert.check().toString().toLowerCase(Locale.ROOT)));
        }
        if ((sqlUpdate = (SQLUpdate)this.annotatedClass.getAnnotation(SQLUpdate.class)) != null) {
            this.persistentClass.setCustomSQLUpdate(sqlUpdate.sql().trim(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlUpdate.check().toString().toLowerCase(Locale.ROOT)));
        }
        if ((sqlDelete = (SQLDelete)this.annotatedClass.getAnnotation(SQLDelete.class)) != null) {
            this.persistentClass.setCustomSQLDelete(sqlDelete.sql().trim(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlDelete.check().toString().toLowerCase(Locale.ROOT)));
        }
        if ((sqlDeleteAll = (SQLDeleteAll)this.annotatedClass.getAnnotation(SQLDeleteAll.class)) != null) {
            this.persistentClass.setCustomSQLDelete(sqlDeleteAll.sql().trim(), sqlDeleteAll.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlDeleteAll.check().toString().toLowerCase(Locale.ROOT)));
        }
        if ((loader = (Loader)this.annotatedClass.getAnnotation(Loader.class)) != null) {
            this.persistentClass.setLoaderName(loader.namedQuery());
        }
        if ((subselect = (Subselect)this.annotatedClass.getAnnotation(Subselect.class)) != null) {
            this.subselect = subselect.value();
        }
    }

    private void bindhandleFilters() {
        for (Filter filter : this.filters) {
            String filterName = filter.name();
            String condition = filter.condition();
            if (BinderHelper.isEmptyAnnotationValue(condition)) {
                FilterDefinition definition = this.context.getMetadataCollector().getFilterDefinition(filterName);
                if (definition == null) {
                    throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' for an undefined filter named '" + filterName + "'");
                }
                condition = definition.getDefaultFilterCondition();
                if (StringHelper.isEmpty(condition)) {
                    throw new AnnotationException("Entity '" + this.name + "' has a '@Filter' with no 'condition' and no default condition was given by the '@FilterDef' named '" + filterName + "'");
                }
            }
            this.persistentClass.addFilter(filterName, condition, filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
        }
    }

    private void bindSynchronize() {
        if (this.annotatedClass.isAnnotationPresent(Synchronize.class)) {
            JdbcEnvironment jdbcEnvironment = this.context.getMetadataCollector().getDatabase().getJdbcEnvironment();
            for (String table : ((Synchronize)this.annotatedClass.getAnnotation(Synchronize.class)).value()) {
                this.persistentClass.addSynchronizedTable(this.context.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(jdbcEnvironment.getIdentifierHelper().toIdentifier(table), jdbcEnvironment).render(jdbcEnvironment.getDialect()));
            }
        }
    }

    private void bindCustomPersister() {
        Persister persisterAnn = (Persister)this.annotatedClass.getAnnotation(Persister.class);
        if (persisterAnn != null) {
            Class<?> clazz = persisterAnn.impl();
            if (!EntityPersister.class.isAssignableFrom(clazz)) {
                throw new AnnotationException("Persister class '" + clazz.getName() + "'  does not implement EntityPersister");
            }
            this.persistentClass.setEntityPersisterClass(clazz);
        }
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    private void processNamedEntityGraphs() {
        this.processNamedEntityGraph((NamedEntityGraph)this.annotatedClass.getAnnotation(NamedEntityGraph.class));
        NamedEntityGraphs graphs = (NamedEntityGraphs)this.annotatedClass.getAnnotation(NamedEntityGraphs.class);
        if (graphs != null) {
            for (NamedEntityGraph graph : graphs.value()) {
                this.processNamedEntityGraph(graph);
            }
        }
    }

    private void processNamedEntityGraph(NamedEntityGraph annotation) {
        if (annotation == null) {
            return;
        }
        this.context.getMetadataCollector().addNamedEntityGraph(new NamedEntityGraphDefinition(annotation, this.name, this.persistentClass.getEntityName()));
    }

    public void bindDiscriminatorValue() {
        if (StringHelper.isEmpty(this.discriminatorValue)) {
            Value discriminator = this.persistentClass.getDiscriminator();
            if (discriminator == null) {
                this.persistentClass.setDiscriminatorValue(this.name);
            } else {
                if ("character".equals(discriminator.getType().getName())) {
                    throw new AnnotationException("Entity '" + this.name + "' has a discriminator of character type and must specify its '@DiscriminatorValue'");
                }
                if ("integer".equals(discriminator.getType().getName())) {
                    this.persistentClass.setDiscriminatorValue(String.valueOf(this.name.hashCode()));
                } else {
                    this.persistentClass.setDiscriminatorValue(this.name);
                }
            }
        } else {
            this.persistentClass.setDiscriminatorValue(this.discriminatorValue);
        }
    }

    OptimisticLockStyle getVersioning(OptimisticLockType type) {
        switch (type) {
            case VERSION: {
                return OptimisticLockStyle.VERSION;
            }
            case NONE: {
                return OptimisticLockStyle.NONE;
            }
            case DIRTY: {
                return OptimisticLockStyle.DIRTY;
            }
            case ALL: {
                return OptimisticLockStyle.ALL;
            }
        }
        throw new AssertionFailure("optimistic locking not supported: " + type);
    }

    private boolean isExplicitPolymorphism(PolymorphismType type) {
        switch (type) {
            case IMPLICIT: {
                return false;
            }
            case EXPLICIT: {
                return true;
            }
        }
        throw new AssertionFailure("Unknown polymorphism type: " + type);
    }

    public void setBatchSize(BatchSize sizeAnn) {
        this.batchSize = sizeAnn != null ? sizeAnn.size() : -1;
    }

    public void setProxy(Proxy proxy) {
        if (proxy != null) {
            ReflectionManager reflectionManager;
            this.lazy = proxy.lazy();
            this.proxyClass = !this.lazy ? null : (AnnotationBinder.isDefault((reflectionManager = this.context.getBootstrapContext().getReflectionManager()).toXClass(proxy.proxyClass()), this.context) ? this.annotatedClass : reflectionManager.toXClass(proxy.proxyClass()));
        } else {
            this.lazy = true;
            this.proxyClass = this.annotatedClass;
        }
    }

    public void setWhere(Where whereAnn) {
        if (whereAnn != null) {
            this.where = whereAnn.clause();
        }
    }

    public void setWrapIdsInEmbeddedComponents(boolean wrapIdsInEmbeddedComponents) {
        this.wrapIdsInEmbeddedComponents = wrapIdsInEmbeddedComponents;
    }

    public void applyCaching(XClass clazzToProcess, SharedCacheMode sharedCacheMode, MetadataBuildingContext context) {
        this.bindCache(clazzToProcess, sharedCacheMode, context);
        this.bindNaturalIdCache(clazzToProcess);
    }

    private void bindNaturalIdCache(XClass clazzToProcess) {
        this.naturalIdCacheRegion = null;
        NaturalIdCache naturalIdCacheAnn = (NaturalIdCache)clazzToProcess.getAnnotation(NaturalIdCache.class);
        if (naturalIdCacheAnn != null) {
            Cache explicitCacheAnn;
            this.naturalIdCacheRegion = BinderHelper.isEmptyAnnotationValue(naturalIdCacheAnn.region()) ? ((explicitCacheAnn = (Cache)clazzToProcess.getAnnotation(Cache.class)) != null && StringHelper.isNotEmpty(explicitCacheAnn.region()) ? explicitCacheAnn.region() + NATURAL_ID_CACHE_SUFFIX : clazzToProcess.getName() + NATURAL_ID_CACHE_SUFFIX) : naturalIdCacheAnn.region();
        }
    }

    private void bindCache(XClass clazzToProcess, SharedCacheMode sharedCacheMode, MetadataBuildingContext context) {
        this.isCached = false;
        this.cacheConcurrentStrategy = null;
        this.cacheRegion = null;
        this.cacheLazyProperty = true;
        if (this.persistentClass instanceof RootClass) {
            this.bindRootClassCache(clazzToProcess, sharedCacheMode, context);
        } else {
            this.bindSubclassCache(clazzToProcess, sharedCacheMode);
        }
    }

    private void bindSubclassCache(XClass clazzToProcess, SharedCacheMode sharedCacheMode) {
        Cache cache = (Cache)clazzToProcess.getAnnotation(Cache.class);
        Cacheable cacheable = (Cacheable)clazzToProcess.getAnnotation(Cacheable.class);
        if (cache != null) {
            LOG.cacheOrCacheableAnnotationOnNonRoot(this.persistentClass.getClassName() == null ? this.annotatedClass.getName() : this.persistentClass.getClassName());
        } else {
            this.isCached = cacheable == null && this.persistentClass.getSuperclass() != null ? this.persistentClass.getSuperclass().isCached() : EntityBinder.isCacheable(sharedCacheMode, cacheable);
        }
    }

    private void bindRootClassCache(XClass clazzToProcess, SharedCacheMode sharedCacheMode, MetadataBuildingContext context) {
        Cache effectiveCache;
        Cache cache = (Cache)clazzToProcess.getAnnotation(Cache.class);
        Cacheable cacheable = (Cacheable)clazzToProcess.getAnnotation(Cacheable.class);
        if (cache != null) {
            this.isCached = true;
            effectiveCache = cache;
        } else {
            effectiveCache = EntityBinder.buildCacheMock(clazzToProcess.getName(), context);
            this.isCached = EntityBinder.isCacheable(sharedCacheMode, cacheable);
        }
        this.cacheConcurrentStrategy = EntityBinder.resolveCacheConcurrencyStrategy(effectiveCache.usage());
        this.cacheRegion = effectiveCache.region();
        this.cacheLazyProperty = EntityBinder.isCacheLazy(effectiveCache, this.annotatedClass);
    }

    private static boolean isCacheLazy(Cache effectiveCache, XClass annotatedClass) {
        switch (effectiveCache.include().toLowerCase(Locale.ROOT)) {
            case "all": {
                return true;
            }
            case "non-lazy": {
                return false;
            }
        }
        throw new AnnotationException("Class '" + annotatedClass.getName() + "' has a '@Cache' with undefined option 'include=\"" + effectiveCache.include() + "\"'");
    }

    private static boolean isCacheable(SharedCacheMode sharedCacheMode, Cacheable explicitCacheableAnn) {
        switch (sharedCacheMode) {
            case ALL: {
                return true;
            }
            case ENABLE_SELECTIVE: {
                return explicitCacheableAnn != null && explicitCacheableAnn.value();
            }
            case DISABLE_SELECTIVE: {
                return explicitCacheableAnn == null || explicitCacheableAnn.value();
            }
        }
        return false;
    }

    private static String resolveCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    private static Cache buildCacheMock(String region, MetadataBuildingContext context) {
        return new LocalCacheAnnotationStub(region, EntityBinder.determineCacheConcurrencyStrategy(context));
    }

    private static CacheConcurrencyStrategy determineCacheConcurrencyStrategy(MetadataBuildingContext context) {
        return CacheConcurrencyStrategy.fromAccessType(context.getBuildingOptions().getImplicitCacheAccessType());
    }

    public void bindTableForDiscriminatedSubclass(InFlightMetadataCollector.EntityTableXref superTableXref) {
        if (!(this.persistentClass instanceof SingleTableSubclass)) {
            throw new AssertionFailure("Was expecting a discriminated subclass [" + SingleTableSubclass.class.getName() + "] but found [" + this.persistentClass.getClass().getName() + "] for entity [" + this.persistentClass.getEntityName() + "]");
        }
        this.context.getMetadataCollector().addEntityTableXref(this.persistentClass.getEntityName(), this.context.getMetadataCollector().getDatabase().toIdentifier(this.context.getMetadataCollector().getLogicalTableName(superTableXref.getPrimaryTable())), superTableXref.getPrimaryTable(), superTableXref);
    }

    public void bindTable(String schema, String catalog, String tableName, List<UniqueConstraintHolder> uniqueConstraints, String constraints, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        Comment comment;
        EntityTableNamingStrategyHelper namingStrategyHelper = new EntityTableNamingStrategyHelper(this.persistentClass.getClassName(), this.persistentClass.getEntityName(), this.name);
        Identifier logicalName = StringHelper.isNotEmpty(tableName) ? namingStrategyHelper.handleExplicitName(tableName, this.context) : namingStrategyHelper.determineImplicitName(this.context);
        org.hibernate.mapping.Table table = TableBinder.buildAndFillTable(schema, catalog, logicalName, this.persistentClass.isAbstract(), uniqueConstraints, null, constraints, this.context, this.subselect, denormalizedSuperTableXref);
        RowId rowId = (RowId)this.annotatedClass.getAnnotation(RowId.class);
        if (rowId != null) {
            table.setRowId(rowId.value());
        }
        if ((comment = (Comment)this.annotatedClass.getAnnotation(Comment.class)) != null) {
            table.setComment(comment.value());
        }
        this.context.getMetadataCollector().addEntityTableXref(this.persistentClass.getEntityName(), logicalName, table, denormalizedSuperTableXref);
        if (!(this.persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("binding a table for a subclass");
        }
        LOG.debugf("Bind entity %s on table %s", this.persistentClass.getEntityName(), table.getName());
        ((TableOwner)((Object)this.persistentClass)).setTable(table);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    public void finalSecondaryTableFromAnnotationBinding(PropertyHolder propertyHolder) {
        Iterator<Object> joinColumns = this.secondaryTableFromAnnotationJoins.values().iterator();
        for (Map.Entry<String, Join> entrySet : this.secondaryTables.entrySet()) {
            if (!this.secondaryTablesFromAnnotation.containsKey(entrySet.getKey())) continue;
            this.createPrimaryColumnsToSecondaryTable(joinColumns.next(), propertyHolder, entrySet.getValue());
        }
    }

    private void createPrimaryColumnsToSecondaryTable(Object column, PropertyHolder propertyHolder, Join join) {
        AnnotatedJoinColumn[] annotatedJoinColumns;
        PrimaryKeyJoinColumn[] pkColumnsAnn = column instanceof PrimaryKeyJoinColumn[] ? (PrimaryKeyJoinColumn[])column : null;
        JoinColumn[] joinColumnsAnn = column instanceof JoinColumn[] ? (JoinColumn[])column : null;
        for (AnnotatedJoinColumn joinColumn : annotatedJoinColumns = pkColumnsAnn == null && joinColumnsAnn == null ? this.createDefaultJoinColumn(propertyHolder) : this.createJoinColumns(propertyHolder, pkColumnsAnn, joinColumnsAnn)) {
            joinColumn.forceNotNull();
        }
        this.bindJoinToPersistentClass(join, annotatedJoinColumns, this.context);
    }

    private AnnotatedJoinColumn[] createDefaultJoinColumn(PropertyHolder propertyHolder) {
        AnnotatedJoinColumn[] annotatedJoinColumns = new AnnotatedJoinColumn[]{AnnotatedJoinColumn.buildJoinColumn(null, null, this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.context)};
        return annotatedJoinColumns;
    }

    private AnnotatedJoinColumn[] createJoinColumns(PropertyHolder propertyHolder, PrimaryKeyJoinColumn[] pkColumnsAnn, JoinColumn[] joinColumnsAnn) {
        int joinColumnCount;
        int n = joinColumnCount = pkColumnsAnn != null ? pkColumnsAnn.length : joinColumnsAnn.length;
        if (joinColumnCount == 0) {
            return this.createDefaultJoinColumn(propertyHolder);
        }
        AnnotatedJoinColumn[] annotatedJoinColumns = new AnnotatedJoinColumn[joinColumnCount];
        for (int colIndex = 0; colIndex < joinColumnCount; ++colIndex) {
            PrimaryKeyJoinColumn pkJoinAnn = pkColumnsAnn != null ? pkColumnsAnn[colIndex] : null;
            JoinColumn joinAnn = joinColumnsAnn != null ? joinColumnsAnn[colIndex] : null;
            annotatedJoinColumns[colIndex] = AnnotatedJoinColumn.buildJoinColumn(pkJoinAnn, joinAnn, this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.context);
        }
        return annotatedJoinColumns;
    }

    private void bindJoinToPersistentClass(Join join, AnnotatedJoinColumn[] annotatedJoinColumns, MetadataBuildingContext buildingContext) {
        DependantValue key = new DependantValue(buildingContext, join.getTable(), this.persistentClass.getIdentifier());
        join.setKey(key);
        this.setFKNameIfDefined(join);
        key.setCascadeDeleteEnabled(false);
        TableBinder.bindForeignKey(this.persistentClass, null, annotatedJoinColumns, key, false, buildingContext);
        key.sortProperties();
        join.createPrimaryKey();
        join.createForeignKey();
        this.persistentClass.addJoin(join);
    }

    private void setFKNameIfDefined(Join join) {
        org.hibernate.annotations.Table matchingTable = this.findMatchingComplementaryTableAnnotation(join);
        SimpleValue key = (SimpleValue)join.getKey();
        if (matchingTable != null && !BinderHelper.isEmptyAnnotationValue(matchingTable.foreignKey().name())) {
            key.setForeignKeyName(matchingTable.foreignKey().name());
        } else {
            SecondaryTable jpaSecondaryTable = this.findMatchingSecondaryTable(join);
            if (jpaSecondaryTable != null) {
                boolean noConstraintByDefault = this.context.getBuildingOptions().isNoConstraintByDefault();
                if (jpaSecondaryTable.foreignKey().value() == ConstraintMode.NO_CONSTRAINT || jpaSecondaryTable.foreignKey().value() == ConstraintMode.PROVIDER_DEFAULT && noConstraintByDefault) {
                    key.disableForeignKey();
                } else {
                    key.setForeignKeyName(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().name()));
                    key.setForeignKeyDefinition(StringHelper.nullIfEmpty(jpaSecondaryTable.foreignKey().foreignKeyDefinition()));
                }
            }
        }
    }

    private SecondaryTable findMatchingSecondaryTable(Join join) {
        String nameToMatch = join.getTable().getQuotedName();
        SecondaryTable secondaryTable = (SecondaryTable)this.annotatedClass.getAnnotation(SecondaryTable.class);
        if (secondaryTable != null && nameToMatch.equals(secondaryTable.name())) {
            return secondaryTable;
        }
        SecondaryTables secondaryTables = (SecondaryTables)this.annotatedClass.getAnnotation(SecondaryTables.class);
        if (secondaryTables != null) {
            for (SecondaryTable secondaryTablesEntry : secondaryTables.value()) {
                if (secondaryTablesEntry == null || !nameToMatch.equals(secondaryTablesEntry.name())) continue;
                return secondaryTablesEntry;
            }
        }
        return null;
    }

    private org.hibernate.annotations.Table findMatchingComplementaryTableAnnotation(Join join) {
        String tableName = join.getTable().getQuotedName();
        org.hibernate.annotations.Table table = (org.hibernate.annotations.Table)this.annotatedClass.getAnnotation(org.hibernate.annotations.Table.class);
        org.hibernate.annotations.Table matchingTable = null;
        if (table != null && tableName.equals(table.appliesTo())) {
            matchingTable = table;
        } else {
            Tables tables = (Tables)this.annotatedClass.getAnnotation(Tables.class);
            if (tables != null) {
                for (org.hibernate.annotations.Table current : tables.value()) {
                    if (!tableName.equals(current.appliesTo())) continue;
                    matchingTable = current;
                    break;
                }
            }
        }
        return matchingTable;
    }

    public Join addJoin(JoinTable joinTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        return this.addJoin(null, joinTable, holder, noDelayInPkColumnCreation);
    }

    public Join addJoin(SecondaryTable secondaryTable, PropertyHolder holder, boolean noDelayInPkColumnCreation) {
        return this.addJoin(secondaryTable, null, holder, noDelayInPkColumnCreation);
    }

    private Join addJoin(SecondaryTable secondaryTable, JoinTable joinTable, PropertyHolder propertyHolder, boolean noDelayInPkColumnCreation) {
        List<UniqueConstraintHolder> uniqueConstraintHolders;
        PrimaryKeyJoinColumn[] joinColumns;
        QualifiedTableName logicalName;
        String catalog;
        String schema;
        Join join = new Join();
        join.setPersistentClass(this.persistentClass);
        if (secondaryTable != null) {
            schema = secondaryTable.schema();
            catalog = secondaryTable.catalog();
            logicalName = new QualifiedTableName(Identifier.toIdentifier(catalog), Identifier.toIdentifier(schema), this.context.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(secondaryTable.name()));
            joinColumns = secondaryTable.pkJoinColumns();
            uniqueConstraintHolders = TableBinder.buildUniqueConstraintHolders(secondaryTable.uniqueConstraints());
        } else if (joinTable != null) {
            schema = joinTable.schema();
            catalog = joinTable.catalog();
            logicalName = new QualifiedTableName(Identifier.toIdentifier(catalog), Identifier.toIdentifier(schema), this.context.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(joinTable.name()));
            joinColumns = joinTable.joinColumns();
            uniqueConstraintHolders = TableBinder.buildUniqueConstraintHolders(joinTable.uniqueConstraints());
        } else {
            throw new AssertionFailure("Both JoinTable and SecondaryTable are null");
        }
        org.hibernate.mapping.Table table = TableBinder.buildAndFillTable(schema, catalog, logicalName.getTableName(), false, uniqueConstraintHolders, null, null, this.context, null, null);
        InFlightMetadataCollector.EntityTableXref tableXref = this.context.getMetadataCollector().getEntityTableXref(this.persistentClass.getEntityName());
        assert (tableXref != null) : "Could not locate EntityTableXref for entity [" + this.persistentClass.getEntityName() + "]";
        tableXref.addSecondaryTable(logicalName, join);
        if (secondaryTable != null) {
            TableBinder.addIndexes(table, secondaryTable.indexes(), this.context);
        }
        join.setTable(table);
        LOG.debugf("Adding secondary table to entity %s -> %s", this.persistentClass.getEntityName(), join.getTable().getName());
        org.hibernate.annotations.Table matchingTable = this.findMatchingComplementaryTableAnnotation(join);
        if (matchingTable != null) {
            String deleteSql;
            String updateSql;
            join.setSequentialSelect(FetchMode.JOIN != matchingTable.fetch());
            join.setInverse(matchingTable.inverse());
            join.setOptional(matchingTable.optional());
            String insertSql = matchingTable.sqlInsert().sql();
            if (!BinderHelper.isEmptyAnnotationValue(insertSql)) {
                join.setCustomSQLInsert(insertSql.trim(), matchingTable.sqlInsert().callable(), ExecuteUpdateResultCheckStyle.fromExternalName(matchingTable.sqlInsert().check().toString().toLowerCase(Locale.ROOT)));
            }
            if (!BinderHelper.isEmptyAnnotationValue(updateSql = matchingTable.sqlUpdate().sql())) {
                join.setCustomSQLUpdate(updateSql.trim(), matchingTable.sqlUpdate().callable(), ExecuteUpdateResultCheckStyle.fromExternalName(matchingTable.sqlUpdate().check().toString().toLowerCase(Locale.ROOT)));
            }
            if (!BinderHelper.isEmptyAnnotationValue(deleteSql = matchingTable.sqlDelete().sql())) {
                join.setCustomSQLDelete(deleteSql.trim(), matchingTable.sqlDelete().callable(), ExecuteUpdateResultCheckStyle.fromExternalName(matchingTable.sqlDelete().check().toString().toLowerCase(Locale.ROOT)));
            }
        } else {
            join.setSequentialSelect(false);
            join.setInverse(false);
            join.setOptional(true);
        }
        if (noDelayInPkColumnCreation) {
            this.createPrimaryColumnsToSecondaryTable(joinColumns, propertyHolder, join);
        } else {
            String quotedName = table.getQuotedName();
            if (secondaryTable != null) {
                this.secondaryTablesFromAnnotation.put(quotedName, join);
                this.secondaryTableFromAnnotationJoins.put(quotedName, joinColumns);
            } else {
                this.secondaryTableJoins.put(quotedName, joinColumns);
            }
            this.secondaryTables.put(quotedName, join);
        }
        return join;
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        org.hibernate.cache.spi.access.AccessType accessType = strategy.toAccessType();
        return accessType == null ? null : accessType.getExternalName();
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public boolean isIgnoreIdAnnotations() {
        return this.ignoreIdAnnotations;
    }

    public void setIgnoreIdAnnotations(boolean ignoreIdAnnotations) {
        this.ignoreIdAnnotations = ignoreIdAnnotations;
    }

    public void processComplementaryTableDefinitions(Table table) {
        if (table != null) {
            TableBinder.addIndexes(this.persistentClass.getTable(), table.indexes(), this.context);
        }
    }

    public void processComplementaryTableDefinitions(org.hibernate.annotations.Table table) {
        if (table == null) {
            return;
        }
        String appliedTable = table.appliesTo();
        org.hibernate.mapping.Table hibTable = null;
        for (org.hibernate.mapping.Table pcTable : this.persistentClass.getTableClosure()) {
            if (!pcTable.getQuotedName().equals(appliedTable)) continue;
            hibTable = pcTable;
            break;
        }
        if (hibTable == null) {
            for (Join join : this.secondaryTables.values()) {
                if (!join.getTable().getQuotedName().equals(appliedTable)) continue;
                hibTable = join.getTable();
                break;
            }
        }
        if (hibTable == null) {
            throw new AnnotationException("Entity '" + this.name + "' has a '@org.hibernate.annotations.Table' annotation which 'appliesTo' an unknown table named '" + appliedTable + "'");
        }
        if (!BinderHelper.isEmptyAnnotationValue(table.comment())) {
            hibTable.setComment(table.comment());
        }
        if (!BinderHelper.isEmptyAnnotationValue(table.checkConstraint())) {
            hibTable.addCheckConstraint(table.checkConstraint());
        }
        TableBinder.addIndexes(hibTable, table.indexes(), this.context);
    }

    public void processComplementaryTableDefinitions(Tables tables) {
        if (tables == null) {
            return;
        }
        for (org.hibernate.annotations.Table table : tables.value()) {
            this.processComplementaryTableDefinitions(table);
        }
    }

    public AccessType getPropertyAccessType() {
        return this.propertyAccessType;
    }

    public void setPropertyAccessType(AccessType propertyAccessor) {
        this.propertyAccessType = this.getExplicitAccessType((XAnnotatedElement)this.annotatedClass);
        if (this.propertyAccessType == null) {
            this.propertyAccessType = propertyAccessor;
        }
    }

    public AccessType getPropertyAccessor(XAnnotatedElement element) {
        AccessType accessType = this.getExplicitAccessType(element);
        if (accessType == null) {
            accessType = this.propertyAccessType;
        }
        return accessType;
    }

    public AccessType getExplicitAccessType(XAnnotatedElement element) {
        AccessType accessType = null;
        Access access = (Access)element.getAnnotation(Access.class);
        if (access != null) {
            accessType = AccessType.getAccessStrategy(access.value());
        }
        return accessType;
    }

    public static void bindFiltersAndFilterDefs(XClass annotatedClass, EntityBinder entityBinder, MetadataBuildingContext context) {
        AnnotatedClassType classType;
        EntityBinder.bindFilters((XAnnotatedElement)annotatedClass, entityBinder, context);
        for (XClass classToProcess = annotatedClass.getSuperclass(); classToProcess != null && AnnotatedClassType.MAPPED_SUPERCLASS == (classType = context.getMetadataCollector().getClassType(classToProcess)); classToProcess = classToProcess.getSuperclass()) {
            EntityBinder.bindFilters((XAnnotatedElement)classToProcess, entityBinder, context);
        }
    }

    private static void bindFilters(XAnnotatedElement annotatedElement, EntityBinder entityBinder, MetadataBuildingContext context) {
        Filter filterAnn;
        Filters filtersAnn = BinderHelper.getOverridableAnnotation(annotatedElement, Filters.class, context);
        if (filtersAnn != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter);
            }
        }
        if ((filterAnn = (Filter)annotatedElement.getAnnotation(Filter.class)) != null) {
            entityBinder.addFilter(filterAnn);
        }
    }

    private static class EntityTableNamingStrategyHelper
    implements NamingStrategyHelper {
        private final String className;
        private final String entityName;
        private final String jpaEntityName;

        private EntityTableNamingStrategyHelper(String className, String entityName, String jpaEntityName) {
            this.className = className;
            this.entityName = entityName;
            this.jpaEntityName = jpaEntityName;
        }

        @Override
        public Identifier determineImplicitName(final MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getImplicitNamingStrategy().determinePrimaryTableName(new ImplicitEntityNameSource(){
                private final EntityNaming entityNaming = new EntityNaming(){

                    @Override
                    public String getClassName() {
                        return className;
                    }

                    @Override
                    public String getEntityName() {
                        return entityName;
                    }

                    @Override
                    public String getJpaEntityName() {
                        return jpaEntityName;
                    }
                };

                @Override
                public EntityNaming getEntityNaming() {
                    return this.entityNaming;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return buildingContext;
                }
            });
        }

        @Override
        public Identifier handleExplicitName(String explicitName, MetadataBuildingContext buildingContext) {
            return buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(explicitName);
        }

        @Override
        public Identifier toPhysicalName(Identifier logicalName, MetadataBuildingContext buildingContext) {
            return buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment());
        }
    }

    private static class LocalCacheAnnotationStub
    implements Cache {
        private final String region;
        private final CacheConcurrencyStrategy usage;

        private LocalCacheAnnotationStub(String region, CacheConcurrencyStrategy usage) {
            this.region = region;
            this.usage = usage;
        }

        @Override
        public CacheConcurrencyStrategy usage() {
            return this.usage;
        }

        @Override
        public String region() {
            return this.region;
        }

        @Override
        public String include() {
            return "all";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Cache.class;
        }
    }
}

