/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.time.Duration;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.TiDBSqlAstTranslator;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sequence.TiDBSequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorTiDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;

public class TiDBDialect
extends MySQLDialect {
    private static final DatabaseVersion VERSION57 = DatabaseVersion.make(5, 7);

    public TiDBDialect() {
        this(DatabaseVersion.make(5, 4));
    }

    public TiDBDialect(DatabaseVersion version) {
        super(version);
    }

    public TiDBDialect(DialectResolutionInfo info) {
        super(info);
    }

    @Override
    public DatabaseVersion getMySQLVersion() {
        return VERSION57;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("CUME_DIST");
        this.registerKeyword("DENSE_RANK");
        this.registerKeyword("EXCEPT");
        this.registerKeyword("FIRST_VALUE");
        this.registerKeyword("GROUPS");
        this.registerKeyword("LAG");
        this.registerKeyword("LAST_VALUE");
        this.registerKeyword("LEAD");
        this.registerKeyword("NTH_VALUE");
        this.registerKeyword("NTILE");
        this.registerKeyword("PERCENT_RANK");
        this.registerKeyword("RANK");
        this.registerKeyword("ROW_NUMBER");
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public String getQuerySequencesString() {
        return "SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = database()";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return TiDBSequenceSupport.INSTANCE;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorTiDBDatabaseImpl.INSTANCE;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new TiDBSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsWait() {
        return true;
    }

    @Override
    public String getReadLockString(int timeout) {
        if (timeout == 0) {
            return this.getForUpdateNowaitString();
        }
        return super.getReadLockString(timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        if (timeout == 0) {
            return this.getForUpdateNowaitString(aliases);
        }
        return super.getReadLockString(aliases, timeout);
    }

    @Override
    public String getWriteLockString(int timeout) {
        if (timeout == 0) {
            return this.getForUpdateNowaitString();
        }
        if (timeout > 0) {
            return this.getForUpdateString() + " wait " + TiDBDialect.getLockWaitTimeoutInSeconds(timeout);
        }
        return this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases) + " nowait";
    }

    private static long getLockWaitTimeoutInSeconds(int timeoutInMilliseconds) {
        Duration duration = Duration.ofMillis(timeoutInMilliseconds);
        return duration.getSeconds();
    }
}

