/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractEmbeddableMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.VirtualIdRepresentationStrategy;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class VirtualIdEmbeddable
extends AbstractEmbeddableMapping
implements NonAggregatedIdentifierMapping.IdentifierValueMapper {
    private final NavigableRole navigableRole;
    private final NonAggregatedIdentifierMapping idMapping;
    private final VirtualIdRepresentationStrategy representationStrategy;
    private final List<SingularAttributeMapping> attributeMappings;
    private SelectableMappings selectableMappings;

    public VirtualIdEmbeddable(Component virtualIdSource, NonAggregatedIdentifierMapping idMapping, EntityPersister identifiedEntityMapping, String rootTableExpression, String[] rootTableKeyColumnNames, MappingModelCreationProcess creationProcess) {
        super(creationProcess);
        this.navigableRole = idMapping.getNavigableRole();
        this.idMapping = idMapping;
        this.representationStrategy = new VirtualIdRepresentationStrategy(this, identifiedEntityMapping, virtualIdSource, creationProcess.getCreationContext());
        CompositeType compositeType = (CompositeType)virtualIdSource.getType();
        this.attributeMappings = CollectionHelper.arrayList(compositeType.getPropertyNames().length);
        ((CompositeTypeImplementor)compositeType).injectMappingModelPart(idMapping, creationProcess);
        creationProcess.registerInitializationCallback("VirtualIdEmbeddable(" + this.navigableRole.getFullPath() + ")#finishInitialization", () -> this.finishInitialization(virtualIdSource, compositeType, rootTableExpression, rootTableKeyColumnNames, creationProcess));
    }

    public VirtualIdEmbeddable(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, VirtualIdEmbeddable inverseMappingType, MappingModelCreationProcess creationProcess) {
        super(creationProcess);
        this.navigableRole = inverseMappingType.getNavigableRole();
        this.idMapping = (NonAggregatedIdentifierMapping)((Object)valueMapping);
        this.representationStrategy = inverseMappingType.representationStrategy;
        this.attributeMappings = CollectionHelper.arrayList(inverseMappingType.attributeMappings.size());
        this.selectableMappings = selectableMappings;
        creationProcess.registerInitializationCallback("VirtualIdEmbeddable(" + inverseMappingType.getNavigableRole().getFullPath() + ".{inverse})#finishInitialization", () -> VirtualIdEmbeddable.inverseInitializeCallback(declaringTableGroupProducer, selectableMappings, inverseMappingType, creationProcess, valueMapping.getDeclaringType(), this.attributeMappings));
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedPart() {
        return this.idMapping;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        return this.representationStrategy.getInstantiator().instantiate(() -> this.getValues(entity), session.getSessionFactory());
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        if (entity != id) {
            this.setValues(entity, this.getValues(id));
        }
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getPartName() {
        return this.idMapping.getPartName();
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.getEmbeddedPart();
    }

    @Override
    public VirtualIdRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public AttributeMapping findAttributeMapping(String name) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attr = this.attributeMappings.get(i);
            if (!name.equals(attr.getAttributeName())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.getSelectableMappings().getSelectable(columnIndex);
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return this.getSelectableMappings().forEachSelectable(0, consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.getSelectableMappings().forEachSelectable(offset, consumer);
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getSelectableMappings().getJdbcTypeCount();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return this.getSelectableMappings().getJdbcMappings();
    }

    private SelectableMappings getSelectableMappings() {
        if (this.selectableMappings == null) {
            throw new IllegalStateException("Not yet ready");
        }
        return this.selectableMappings;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.getSelectableMappings().forEachSelectable(offset, (index, selectable) -> action.accept(index, selectable.getJdbcMapping()));
    }

    @Override
    public boolean isCreateEmptyCompositesEnabled() {
        return false;
    }

    @Override
    public int getNumberOfAttributeMappings() {
        return this.attributeMappings.size();
    }

    @Override
    public AttributeMapping getAttributeMapping(int position) {
        return this.attributeMappings.get(position);
    }

    @Override
    public List<AttributeMapping> getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    public void visitAttributeMappings(Consumer<? super AttributeMapping> action) {
        this.forEachAttribute((index, attribute) -> action.accept((AttributeMapping)attribute));
    }

    @Override
    public void forEachAttributeMapping(IndexedConsumer<AttributeMapping> consumer) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            consumer.accept(i, this.attributeMappings.get(i));
        }
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getNumberOfAttributeMappings();
    }

    @Override
    public Fetchable getFetchable(int position) {
        return this.attributeMappings.get(position);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.idMapping.findContainingEntityMapping();
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.attributeMappings.forEach(consumer);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            SingularAttributeMapping attribute = this.attributeMappings.get(i);
            if (!attribute.getAttributeName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            if (attributeMapping instanceof PluralAttributeMapping) continue;
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            span += attributeMapping.forEachJdbcValue(o, clause, span + offset, valuesConsumer, session);
        }
        return span;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.attributeMappings.forEach(attribute -> {
            Object attributeValue = attribute.getValue(domainValue);
            attribute.breakDownJdbcValues(attributeValue, valueConsumer, session);
        });
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        Object[] result = new Object[this.attributeMappings.size()];
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            result[i] = attributeMapping.disassemble(o, session);
        }
        return result;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        Object[] values = (Object[])value;
        int span = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping mapping = this.attributeMappings.get(i);
            span += mapping.forEachDisassembledJdbcValue(values[i], clause, span + offset, valuesConsumer, session);
        }
        return span;
    }

    @Override
    public EmbeddableMappingType createInverseMappingType(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new VirtualIdEmbeddable(valueMapping, declaringTableGroupProducer, selectableMappings, this, creationProcess);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, MappingModelCreationProcess creationProcess) {
        this.attributeMappings.clear();
        return VirtualIdEmbeddable.finishInitialization(this.navigableRole, bootDescriptor, compositeType, rootTableExpression, rootTableKeyColumnNames, this, this.representationStrategy, (attributeName, attributeType) -> {
            if (attributeType instanceof CollectionType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("A \"virtual id\" cannot define collection attributes : " + attributeName);
            }
            if (attributeType instanceof AnyType) {
                throw new AbstractEmbeddableMapping.IllegalAttributeType("A \"virtual id\" cannot define <any/> attributes : " + attributeName);
            }
        }, (column, jdbcEnvironment) -> MappingModelCreationHelper.getTableIdentifierExpression(column.getValue().getTable(), creationProcess), this::addAttribute, () -> creationProcess.registerInitializationCallback("VirtualIdEmbeddable(" + this.navigableRole + ")#initColumnMappings", this::initColumnMappings), creationProcess);
    }

    private boolean initColumnMappings() {
        this.selectableMappings = SelectableMappingsImpl.from(this);
        return true;
    }

    private void addAttribute(AttributeMapping attributeMapping) {
        this.addAttribute((SingularAttributeMapping)attributeMapping);
    }

    private void addAttribute(SingularAttributeMapping attributeMapping) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping previous = this.attributeMappings.get(i);
            if (!attributeMapping.getAttributeName().equals(previous.getAttributeName())) continue;
            this.attributeMappings.set(i, attributeMapping);
            return;
        }
        this.attributeMappings.add(attributeMapping);
    }
}

