/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.jboss.logging.Logger;

public class NamedObjectRepositoryImpl
implements NamedObjectRepository {
    private static final Logger log = Logger.getLogger(NamedObjectRepository.class);
    private final Map<String, NamedSqmQueryMemento> sqmMementoMap;
    private final Map<String, NamedNativeQueryMemento> sqlMementoMap;
    private final Map<String, NamedCallableQueryMemento> callableMementoMap;
    private final Map<String, NamedResultSetMappingMemento> resultSetMappingMementoMap;

    public NamedObjectRepositoryImpl(Map<String, NamedSqmQueryMemento> sqmMementoMap, Map<String, NamedNativeQueryMemento> sqlMementoMap, Map<String, NamedCallableQueryMemento> callableMementoMap, Map<String, NamedResultSetMappingMemento> resultSetMappingMementoMap) {
        this.sqmMementoMap = sqmMementoMap;
        this.sqlMementoMap = sqlMementoMap;
        this.callableMementoMap = callableMementoMap;
        this.resultSetMappingMementoMap = resultSetMappingMementoMap;
    }

    @Override
    public NamedSqmQueryMemento getSqmQueryMemento(String queryName) {
        return this.sqmMementoMap.get(queryName);
    }

    @Override
    public void visitSqmQueryMementos(Consumer<NamedSqmQueryMemento> action) {
        this.sqmMementoMap.values().forEach(action);
    }

    @Override
    public void registerSqmQueryMemento(String name, NamedSqmQueryMemento descriptor) {
        this.sqmMementoMap.put(name, descriptor);
        this.sqlMementoMap.remove(name);
    }

    @Override
    public NamedNativeQueryMemento getNativeQueryMemento(String queryName) {
        return this.sqlMementoMap.get(queryName);
    }

    @Override
    public void visitNativeQueryMementos(Consumer<NamedNativeQueryMemento> action) {
        this.sqlMementoMap.values().forEach(action);
    }

    @Override
    public synchronized void registerNativeQueryMemento(String name, NamedNativeQueryMemento descriptor) {
        this.sqlMementoMap.put(name, descriptor);
        this.sqmMementoMap.remove(name);
    }

    @Override
    public NamedCallableQueryMemento getCallableQueryMemento(String name) {
        return this.callableMementoMap.get(name);
    }

    @Override
    public void visitCallableQueryMementos(Consumer<NamedCallableQueryMemento> action) {
        this.callableMementoMap.values().forEach(action);
    }

    @Override
    public synchronized void registerCallableQueryMemento(String name, NamedCallableQueryMemento memento) {
        this.callableMementoMap.put(name, memento);
    }

    @Override
    public NamedResultSetMappingMemento getResultSetMappingMemento(String mappingName) {
        return this.resultSetMappingMementoMap.get(mappingName);
    }

    @Override
    public void visitResultSetMappingMementos(Consumer<NamedResultSetMappingMemento> action) {
        this.resultSetMappingMementoMap.values().forEach(action);
    }

    @Override
    public void registerResultSetMappingMemento(String name, NamedResultSetMappingMemento memento) {
        this.resultSetMappingMementoMap.put(name, memento);
    }

    @Override
    public NamedQueryMemento resolve(SessionFactoryImplementor sessionFactory, MetadataImplementor bootMetamodel, String registrationName) {
        NamedQueryMemento namedQuery = this.sqlMementoMap.get(registrationName);
        if (namedQuery != null) {
            return namedQuery;
        }
        namedQuery = this.sqmMementoMap.get(registrationName);
        if (namedQuery != null) {
            return namedQuery;
        }
        namedQuery = this.callableMementoMap.get(registrationName);
        if (namedQuery != null) {
            return namedQuery;
        }
        NamedHqlQueryDefinition namedHqlQueryDefinition = bootMetamodel.getNamedHqlQueryMapping(registrationName);
        if (namedHqlQueryDefinition != null) {
            NamedSqmQueryMemento resolved = namedHqlQueryDefinition.resolve(sessionFactory);
            this.sqmMementoMap.put(namedHqlQueryDefinition.getRegistrationName(), resolved);
            return resolved;
        }
        NamedNativeQueryDefinition namedNativeQueryDefinition = bootMetamodel.getNamedNativeQueryMapping(registrationName);
        if (namedNativeQueryDefinition != null) {
            NamedNativeQueryMemento resolved = namedNativeQueryDefinition.resolve(sessionFactory);
            this.sqlMementoMap.put(namedNativeQueryDefinition.getRegistrationName(), resolved);
            return resolved;
        }
        NamedProcedureCallDefinition namedCallableQueryDefinition = bootMetamodel.getNamedProcedureCallMapping(registrationName);
        if (namedCallableQueryDefinition != null) {
            NamedCallableQueryMemento resolved = namedCallableQueryDefinition.resolve(sessionFactory);
            this.callableMementoMap.put(namedCallableQueryDefinition.getRegistrationName(), resolved);
            return resolved;
        }
        return null;
    }

    @Override
    public void prepare(SessionFactoryImplementor sessionFactory, MetadataImplementor bootMetamodel, BootstrapContext bootstrapContext) {
        bootMetamodel.visitNamedHqlQueryDefinitions(namedHqlQueryDefinition -> {
            NamedSqmQueryMemento resolved = namedHqlQueryDefinition.resolve(sessionFactory);
            this.sqmMementoMap.put(namedHqlQueryDefinition.getRegistrationName(), resolved);
        });
        bootMetamodel.visitNamedNativeQueryDefinitions(namedNativeQueryDefinition -> {
            NamedNativeQueryMemento resolved = namedNativeQueryDefinition.resolve(sessionFactory);
            this.sqlMementoMap.put(namedNativeQueryDefinition.getRegistrationName(), resolved);
        });
        bootMetamodel.visitNamedResultSetMappingDefinition(namedResultSetMappingDefinition -> {
            NamedResultSetMappingMemento resolved = namedResultSetMappingDefinition.resolve(() -> sessionFactory);
            this.resultSetMappingMementoMap.put(namedResultSetMappingDefinition.getRegistrationName(), resolved);
        });
        bootMetamodel.visitNamedProcedureCallDefinition(namedProcedureCallDefinition -> {
            NamedCallableQueryMemento resolved = namedProcedureCallDefinition.resolve(sessionFactory);
            this.callableMementoMap.put(namedProcedureCallDefinition.getRegistrationName(), resolved);
        });
    }

    @Override
    public Map<String, HibernateException> checkNamedQueries(QueryEngine queryEngine) {
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        log.debugf("Checking %s named HQL queries", this.sqmMementoMap.size());
        for (NamedSqmQueryMemento hqlMemento : this.sqmMementoMap.values()) {
            try {
                log.debugf("Checking named HQL query: %s", (Object)hqlMemento.getRegistrationName());
                String queryString = hqlMemento.getHqlString();
                interpretationCache.resolveHqlInterpretation(queryString, null, s -> queryEngine.getHqlTranslator().translate(queryString, null));
            }
            catch (HibernateException e) {
                errors.put(hqlMemento.getRegistrationName(), e);
            }
        }
        log.debugf("Checking %s named SQL queries", this.sqlMementoMap.size());
        for (NamedNativeQueryMemento memento : this.sqlMementoMap.values()) {
            memento.validate(queryEngine);
        }
        return errors;
    }

    @Override
    public void close() {
        this.sqmMementoMap.clear();
        this.sqlMementoMap.clear();
        this.callableMementoMap.clear();
        this.resultSetMappingMementoMap.clear();
    }
}

