/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmBasicValuedSimplePath<T>
extends AbstractSqmSimplePath<T>
implements SqmExpressible<T> {
    public SqmBasicValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        this(navigablePath, referencedPathSource, lhs, null, nodeBuilder);
    }

    public SqmBasicValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, explicitAlias, nodeBuilder);
    }

    @Override
    public SqmBasicValuedSimplePath<T> copy(SqmCopyContext context) {
        SqmBasicValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmBasicValuedSimplePath<T> path = context.registerCopy(this, new SqmBasicValuedSimplePath<T>(this.getNavigablePath(), this.getReferencedPathSource(), (SqmPath<?>)this.getLhs().copy(context), this.getExplicitAlias(), this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException(String.format("Could not interpret attribute '%s' of basic-valued path '%s'", name, this.getNavigablePath()));
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return super.getReferencedPathSource();
    }

    @Override
    public SqmPathSource<T> getNodeType() {
        return this.getReferencedPathSource();
    }

    @Override
    public BasicJavaType<T> getJavaTypeDescriptor() {
        return (BasicJavaType)super.getJavaTypeDescriptor();
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        throw new UnsupportedOperationException("Basic-value cannot be treated (downcast)");
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new UnsupportedOperationException("Basic-value cannot be treated (downcast)");
    }

    @Override
    public Class<T> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    public Class<T> getBindableJavaType() {
        return this.getJavaType();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitBasicValuedPath(this);
    }
}

