/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.common.jndi;

import org.jboss.as.connector.subsystems.common.jndi.Constants;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class Util {
    public static String getJndiName(OperationContext context, ModelNode modelNode) throws OperationFailedException {
        String rawJndiName = Constants.JNDI_NAME.resolveModelAttribute(context, modelNode).asString();
        return Util.cleanJndiName(rawJndiName, Constants.USE_JAVA_CONTEXT.resolveModelAttribute(context, modelNode).asBoolean());
    }

    public static String cleanJndiName(String rawJndiName, Boolean useJavaContext) {
        Object jndiName = !rawJndiName.startsWith("java:") && useJavaContext.booleanValue() ? (rawJndiName.startsWith("jboss/") ? "java:" + rawJndiName : "java:/" + rawJndiName) : rawJndiName;
        return jndiName;
    }

    private Util() {
    }
}

