/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolLogger;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompPostReceiptFunction;
import org.apache.activemq.artemis.core.protocol.stomp.StompProtocolManager;
import org.apache.activemq.artemis.core.protocol.stomp.StompSubscription;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.PendingTask;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class StompSession
implements SessionCallback {
    private final StompProtocolManager manager;
    private final StompConnection connection;
    private ServerSession session;
    private final OperationContext sessionContext;
    private final BlockingDeque<PendingTask> afterDeliveryTasks = new LinkedBlockingDeque<PendingTask>();
    private final Map<Long, StompSubscription> subscriptions = new ConcurrentHashMap<Long, StompSubscription>();
    private final Map<Long, Pair<Long, Integer>> messagesToAck = new ConcurrentHashMap<Long, Pair<Long, Integer>>();
    private volatile boolean noLocal = false;
    private boolean txPending = false;

    public synchronized void begin() {
        this.txPending = true;
    }

    public synchronized boolean isTxPending() {
        return this.txPending;
    }

    public synchronized void end() {
        this.txPending = false;
    }

    StompSession(StompConnection connection, StompProtocolManager manager, OperationContext sessionContext) {
        this.connection = connection;
        this.manager = manager;
        this.sessionContext = sessionContext;
    }

    public boolean supportsDirectDelivery() {
        return false;
    }

    public boolean isWritable(ReadyListener callback, Object protocolContext) {
        return this.connection.isWritable(callback);
    }

    void setServerSession(ServerSession session) {
        this.session = session;
    }

    public ServerSession getCoreSession() {
        return this.session;
    }

    public boolean hasCredits(ServerConsumer consumerID) {
        return true;
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public void afterDelivery() throws Exception {
        PendingTask task;
        while ((task = this.afterDeliveryTasks.poll()) != null) {
            task.run();
        }
    }

    public void browserFinished(ServerConsumer consumer) {
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        return false;
    }

    public int sendMessage(MessageReference ref, Message serverMessage, ServerConsumer consumer, int deliveryCount) {
        ICoreMessage coreMessage = serverMessage.toCore();
        ICoreMessage newServerMessage = serverMessage.toCore();
        try {
            StompSubscription subscription = this.subscriptions.get(consumer.getID());
            if (subscription == null) {
                return 0;
            }
            ActiveMQBuffer buffer = coreMessage.getDataBuffer();
            StompFrame frame = this.connection.createStompMessage(newServerMessage, buffer, subscription, deliveryCount);
            int length = frame.getEncodedSize();
            if (subscription.getAck().equals("auto")) {
                if (this.manager.send(this.connection, frame)) {
                    final long messageID = newServerMessage.getMessageID();
                    final long consumerID = consumer.getID();
                    this.afterDeliveryTasks.offer(new PendingTask(){

                        public void run() throws Exception {
                            StompSession.this.session.acknowledge(consumerID, messageID);
                            StompSession.this.session.commit();
                        }
                    });
                }
            } else {
                this.messagesToAck.put(newServerMessage.getMessageID(), (Pair<Long, Integer>)new Pair((Object)consumer.getID(), (Object)length));
                this.manager.send(this.connection, frame);
            }
            return length;
        }
        catch (Exception e) {
            if (ActiveMQStompProtocolLogger.LOGGER.isDebugEnabled()) {
                ActiveMQStompProtocolLogger.LOGGER.debug(e);
            }
            return 0;
        }
    }

    public int sendLargeMessageContinuation(ServerConsumer consumer, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    public int sendLargeMessage(MessageReference ref, Message msg, ServerConsumer consumer, long bodySize, int deliveryCount) {
        return 0;
    }

    public void closed() {
    }

    public void disconnect(ServerConsumer consumerId, SimpleString queueName) {
        StompSubscription stompSubscription = this.subscriptions.remove(consumerId.getID());
        if (stompSubscription != null) {
            StompFrame frame = this.connection.getFrameHandler().createStompFrame("ERROR");
            frame.addHeader("content-type", "text/plain");
            frame.setBody("consumer with ID " + consumerId + " disconnected by server");
            this.connection.sendFrame(frame, null);
        }
    }

    public void acknowledge(String messageID, String subscriptionID) throws Exception {
        long id = Long.parseLong(messageID);
        Pair<Long, Integer> pair = this.messagesToAck.get(id);
        if (pair == null) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.failToAckMissingID(id).setHandler(this.connection.getFrameHandler());
        }
        long consumerID = (Long)pair.getA();
        StompSubscription sub = this.subscriptions.get(consumerID);
        if (subscriptionID != null && !sub.getID().equals(subscriptionID)) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.subscriptionIDMismatch(subscriptionID, sub.getID()).setHandler(this.connection.getFrameHandler());
        }
        if (sub.getAck().equals("client-individual")) {
            this.session.individualAcknowledge(consumerID, id);
            if (sub.getConsumerWindowSize() != -1) {
                this.session.receiveConsumerCredits(consumerID, ((Integer)this.messagesToAck.remove(id).getB()).intValue());
            }
        } else {
            List ackedRefs = this.session.acknowledge(consumerID, id);
            if (sub.getConsumerWindowSize() != -1) {
                for (Long ackedID : ackedRefs) {
                    this.session.receiveConsumerCredits(consumerID, ((Integer)this.messagesToAck.remove(ackedID).getB()).intValue());
                }
            }
        }
        this.session.commit();
    }

    public StompPostReceiptFunction addSubscription(long consumerID, String subscriptionID, String clientID, String durableSubscriptionName, String destination, String selector, String ack, Integer consumerWindowSize) throws Exception {
        boolean multicast;
        SimpleString address = SimpleString.toSimpleString((String)destination);
        SimpleString queueName = SimpleString.toSimpleString((String)destination);
        SimpleString selectorSimple = SimpleString.toSimpleString((String)selector);
        int finalConsumerWindowSize = consumerWindowSize != null ? consumerWindowSize : (ack.equals("auto") ? -1 : ConfigurationHelper.getIntProperty((String)"stompConsumerWindowSize", (int)ConfigurationHelper.getIntProperty((String)"stompConsumerCredits", (int)10240, (Map)this.connection.getAcceptorUsed().getConfiguration()), (Map)this.connection.getAcceptorUsed().getConfiguration()));
        EnumSet routingTypes = this.manager.getServer().getAddressInfo(this.getCoreSession().removePrefix(address)).getRoutingTypes();
        boolean bl = multicast = routingTypes.size() == 1 && routingTypes.contains(RoutingType.MULTICAST);
        if (multicast && !CompositeAddress.isFullyQualified((String)destination)) {
            if (durableSubscriptionName != null) {
                if (clientID == null) {
                    throw ActiveMQStompProtocolMessageBundle.BUNDLE.missingClientID();
                }
                queueName = SimpleString.toSimpleString((String)(clientID + "." + durableSubscriptionName));
                if (this.manager.getServer().locateQueue(queueName) == null) {
                    try {
                        this.session.createQueue(new QueueConfiguration(queueName).setAddress(address).setFilterString(selectorSimple));
                    }
                    catch (ActiveMQQueueExistsException activeMQQueueExistsException) {}
                }
            } else {
                queueName = UUIDGenerator.getInstance().generateSimpleStringUUID();
                this.session.createQueue(new QueueConfiguration(queueName).setAddress(address).setFilterString(selectorSimple).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
            }
        }
        ServerConsumer consumer = this.session.createConsumer(consumerID, queueName, multicast ? null : selectorSimple, false, false, Integer.valueOf(0));
        StompSubscription subscription = new StompSubscription(subscriptionID, ack, queueName, multicast, finalConsumerWindowSize);
        this.subscriptions.put(consumerID, subscription);
        this.session.start();
        return () -> consumer.receiveCredits(finalConsumerWindowSize == 0 ? 1 : finalConsumerWindowSize);
    }

    public boolean unsubscribe(String id, String durableSubscriptionName, String clientID) throws Exception {
        boolean result = false;
        Iterator<Map.Entry<Long, StompSubscription>> iterator = this.subscriptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, StompSubscription> entry = iterator.next();
            long consumerID = entry.getKey();
            StompSubscription sub = entry.getValue();
            if (id == null || !id.equals(sub.getID())) continue;
            iterator.remove();
            SimpleString queueName = sub.getQueueName();
            this.session.closeConsumer(consumerID);
            Queue queue = this.manager.getServer().locateQueue(queueName);
            if (sub.isMulticast() && queue != null && durableSubscriptionName == null && !queue.isDurable()) {
                this.session.deleteQueue(queueName);
            }
            result = true;
        }
        if (durableSubscriptionName != null && clientID != null) {
            SimpleString queueName = SimpleString.toSimpleString((String)(clientID + "." + durableSubscriptionName));
            if (this.manager.getServer().locateQueue(queueName) != null) {
                this.session.deleteQueue(queueName);
            }
            result = true;
        }
        return result;
    }

    boolean containsSubscription(String subscriptionID) {
        for (Map.Entry<Long, StompSubscription> entry : this.subscriptions.entrySet()) {
            StompSubscription sub = entry.getValue();
            if (!sub.getID().equals(subscriptionID)) continue;
            return true;
        }
        return false;
    }

    public RemotingConnection getConnection() {
        return this.connection;
    }

    public OperationContext getContext() {
        return this.sessionContext;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void sendInternal(Message message, boolean direct) throws Exception {
        this.session.send(message, direct);
    }

    public void sendInternalLarge(CoreMessage message, boolean direct) throws Exception {
        int headerSize = message.getHeadersAndPropertiesEncodeSize();
        if (headerSize >= this.connection.getMinLargeMessageSize()) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.headerTooBig();
        }
        StorageManager storageManager = ((ServerSessionImpl)this.session).getStorageManager();
        long id = storageManager.generateID();
        LargeServerMessage largeMessage = storageManager.createLargeMessage(id, (Message)message);
        ActiveMQBuffer body = message.getReadOnlyBodyBuffer();
        byte[] bytes = new byte[body.readableBytes()];
        body.readBytes(bytes);
        largeMessage.addBytes(bytes);
        largeMessage.releaseResources(true, true);
        largeMessage.toMessage().putLongProperty(Message.HDR_LARGE_BODY_SIZE, (long)bytes.length);
        this.session.send(largeMessage.toMessage(), direct);
    }
}

