/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.Collection;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.messaging.AcceptedType;

public class FastPathAcceptedType
implements AMQPType<Accepted>,
FastPathDescribedTypeConstructor<Accepted> {
    private static final byte DESCRIPTOR_CODE = 36;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(36L), Symbol.valueOf("amqp:accepted:list")};
    private static final byte[] ACCEPTED_ENCODED_BYTES = new byte[]{0, 83, 36, 69};
    private final AcceptedType acceptedType;

    public FastPathAcceptedType(EncoderImpl encoder) {
        this.acceptedType = new AcceptedType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.acceptedType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.acceptedType.getDecoder();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Accepted> getTypeClass() {
        return Accepted.class;
    }

    @Override
    public TypeEncoding<Accepted> getEncoding(Accepted accepted) {
        return this.acceptedType.getEncoding(accepted);
    }

    @Override
    public TypeEncoding<Accepted> getCanonicalEncoding() {
        return this.acceptedType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Accepted>> getAllEncodings() {
        return this.acceptedType.getAllEncodings();
    }

    @Override
    public Accepted readValue() {
        DecoderImpl decoder = this.getDecoder();
        byte typeCode = decoder.getBuffer().get();
        switch (typeCode) {
            case 69: {
                break;
            }
            case -64: {
                decoder.getBuffer().get();
                decoder.getBuffer().get();
                break;
            }
            case -48: {
                decoder.getBuffer().getInt();
                decoder.getBuffer().getInt();
                break;
            }
            default: {
                throw new DecodeException("Incorrect type found in Accepted type encoding: " + typeCode);
            }
        }
        return Accepted.getInstance();
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public void write(Accepted accepted) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        buffer.put(ACCEPTED_ENCODED_BYTES, 0, ACCEPTED_ENCODED_BYTES.length);
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathAcceptedType type = new FastPathAcceptedType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

