/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.ConcurrentManager;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.SimpleManager;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.InfinispanConfiguration;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.affinity.AffinityIdentifierFactory;
import org.wildfly.clustering.ee.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleLocalKeysTask;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.distribution.Locality;
import org.wildfly.clustering.infinispan.distribution.SimpleLocality;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.ConcurrentSessionManager;
import org.wildfly.clustering.web.cache.session.MarshalledValueSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.AbstractInfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.BulkReadInfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.LockOnReadInfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeActivationNotifierFactory;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionExpirationMetaData;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;

public class InfinispanSessionManagerFactory<S, SC, AL, LC>
implements SessionManagerFactory<SC, LC, TransactionBatch>,
Runnable {
    private final Scheduler<String, SessionExpirationMetaData> scheduler;
    private final SpecificationProvider<S, SC, AL> provider;
    private final KeyAffinityServiceFactory affinityFactory;
    private final SessionFactory<SC, CompositeSessionMetaDataEntry<LC>, ?, LC> factory;
    private final BiConsumer<Locality, Locality> scheduleTask;
    private final ListenerRegistration schedulerListenerRegistration;
    private final InfinispanConfiguration configuration;
    private final ExpiredSessionRemover<SC, ?, ?, LC> remover;
    private final SessionAttributeActivationNotifierFactory<S, SC, AL, LC, TransactionBatch> notifierFactory;

    public InfinispanSessionManagerFactory(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, LC> config) {
        this.configuration = config;
        this.affinityFactory = config.getKeyAffinityServiceFactory();
        this.provider = config.getSpecificationProvider();
        this.notifierFactory = new SessionAttributeActivationNotifierFactory(this.provider);
        CacheProperties properties = config.getCacheProperties();
        AbstractInfinispanSessionMetaDataFactory metaDataFactory = properties.isLockOnRead() ? new LockOnReadInfinispanSessionMetaDataFactory(config) : new BulkReadInfinispanSessionMetaDataFactory(config);
        this.factory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config), config.getLocalContextFactory());
        this.remover = new ExpiredSessionRemover(this.factory);
        Cache cache = config.getCache();
        PrimaryOwnerScheduler localScheduler = new SessionExpirationScheduler((Batcher<TransactionBatch>)config.getBatcher(), this.factory.getMetaDataFactory(), this.remover, Duration.ofMillis(cache.getCacheConfiguration().transaction().cacheStopTimeout()));
        CommandDispatcherFactory dispatcherFactory = config.getCommandDispatcherFactory();
        Group group = dispatcherFactory.getGroup();
        this.scheduler = group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(dispatcherFactory, cache.getName(), (CacheEntryScheduler)localScheduler, (Function)new PrimaryOwnerLocator(cache, config.getMemberFactory()), SessionCreationMetaDataKey::new, properties.isTransactional() ? ScheduleWithMetaDataCommand::new : ScheduleWithTransientMetaDataCommand::new);
        this.scheduleTask = new ScheduleLocalKeysTask(cache, (Predicate)((Object)SessionCreationMetaDataKeyFilter.INSTANCE), (CacheEntryScheduler)localScheduler);
        this.schedulerListenerRegistration = new SchedulerTopologyChangeListener(cache, (CacheEntryScheduler)localScheduler, this.scheduleTask).register();
    }

    @Override
    public void run() {
        this.scheduleTask.accept((Locality)new SimpleLocality(false), (Locality)new CacheLocality(this.configuration.getCache()));
    }

    public SessionManager<LC, TransactionBatch> createSessionManager(final SessionManagerConfiguration<SC> configuration) {
        AffinityIdentifierFactory factory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), this.configuration.getCache(), this.affinityFactory);
        Registrar registrar = manager -> {
            Registration contextRegistration = this.notifierFactory.register(Map.entry(configuration.getServletContext(), manager));
            Registration expirationRegistration = this.remover.register(configuration.getExpirationListener());
            return () -> {
                expirationRegistration.close();
                contextRegistration.close();
            };
        };
        Scheduler<String, SessionExpirationMetaData> scheduler = this.scheduler;
        AbstractInfinispanSessionManagerConfiguration config = new AbstractInfinispanSessionManagerConfiguration<SC, LC>(this.configuration, (IdentifierFactory)factory, scheduler, registrar){
            final /* synthetic */ IdentifierFactory val$factory;
            final /* synthetic */ Scheduler val$scheduler;
            final /* synthetic */ Registrar val$registrar;
            {
                this.val$factory = identifierFactory;
                this.val$scheduler = scheduler;
                this.val$registrar = registrar;
                super(configuration2);
            }

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public SC getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$factory;
            }

            @Override
            public Scheduler<String, SessionExpirationMetaData> getExpirationScheduler() {
                return this.val$scheduler;
            }

            @Override
            public Runnable getStartTask() {
                return InfinispanSessionManagerFactory.this;
            }

            @Override
            public Registrar<SessionManager<LC, TransactionBatch>> getRegistrar() {
                return this.val$registrar;
            }
        };
        return new ConcurrentSessionManager(new InfinispanSessionManager(this.factory, config), this.configuration.getCacheProperties().isTransactional() ? SimpleManager::new : ConcurrentManager::new);
    }

    private SessionAttributesFactory<SC, ?> createSessionAttributesFactory(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, LC> configuration) {
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory<S, SC, AL, LC>(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration, this.notifierFactory));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory<S, SC, AL, LC>(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration, this.notifierFactory));
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.schedulerListenerRegistration.close();
        this.scheduler.close();
        this.factory.close();
    }

    private static class InfinispanMarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, LC>
    extends MarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, LC>
    implements InfinispanSessionAttributesFactoryConfiguration<S, SC, AL, V, MarshalledValue<V, ByteBufferMarshaller>> {
        private final InfinispanSessionManagerFactoryConfiguration<S, SC, AL, LC> configuration;
        private final Function<String, SessionAttributeActivationNotifier> notifierFactory;

        InfinispanMarshalledValueSessionAttributesFactoryConfiguration(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, LC> configuration, Function<String, SessionAttributeActivationNotifier> notifierFactory) {
            super(configuration);
            this.configuration = configuration;
            this.notifierFactory = notifierFactory;
        }

        public <CK, CV> Cache<CK, CV> getCache() {
            return this.configuration.getCache();
        }

        @Override
        public Function<String, SessionAttributeActivationNotifier> getActivationNotifierFactory() {
            return this.notifierFactory;
        }
    }

    private static abstract class AbstractInfinispanSessionManagerConfiguration<SC, LC>
    implements InfinispanSessionManagerConfiguration<SC, LC> {
        private final InfinispanConfiguration configuration;

        AbstractInfinispanSessionManagerConfiguration(InfinispanConfiguration configuration) {
            this.configuration = configuration;
        }

        public <K, V> Cache<K, V> getCache() {
            return this.configuration.getCache();
        }
    }
}

