/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Ids;
import org.reactivestreams.Publisher;

public class PublisherTransformers {
    private PublisherTransformers() {
    }

    public static <I> Function<Publisher<I>, Publisher<I>> identity() {
        return IdentityTransformer.INSTANCE;
    }

    public static final class PublisherTransformersExternalizer
    implements AdvancedExternalizer<Object> {
        private static final ExternalizerId[] VALUES = ExternalizerId.values();
        private final Map<Class<?>, ExternalizerId> objects = new HashMap();

        public PublisherTransformersExternalizer() {
            for (ExternalizerId id : ExternalizerId.values()) {
                this.objects.put(id.marshalledClass, id);
            }
        }

        public Set<Class<?>> getTypeClasses() {
            return this.objects.keySet();
        }

        public Integer getId() {
            return Ids.PUBLISHER_TRANSFORMERS;
        }

        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ExternalizerId id = this.objects.get(object.getClass());
            if (id == null) {
                throw new IllegalArgumentException("Unsupported class " + object.getClass() + " was provided!");
            }
            output.writeByte(id.ordinal());
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            ExternalizerId[] ids = VALUES;
            if (number < 0 || number >= ids.length) {
                throw new IllegalArgumentException("Found invalid number " + number);
            }
            ExternalizerId id = ids[number];
            switch (id) {
                case IDENTITY_TRANSFORMER: {
                    return IdentityTransformer.INSTANCE;
                }
            }
            throw new IllegalArgumentException("ExternalizerId not supported: " + id);
        }

        static enum ExternalizerId {
            IDENTITY_TRANSFORMER(IdentityTransformer.class);

            private final Class<?> marshalledClass;

            private ExternalizerId(Class<?> marshalledClass) {
                this.marshalledClass = marshalledClass;
            }
        }
    }

    private static final class IdentityTransformer<I>
    implements Function<Publisher<I>, Publisher<I>> {
        private static final IdentityTransformer INSTANCE = new IdentityTransformer();

        private IdentityTransformer() {
        }

        @Override
        public Publisher<I> apply(Publisher<I> publisher) {
            return publisher;
        }
    }
}

