/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.contexts;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.IOException;
import java.security.PrivilegedAction;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.contexts.SerializableContextualInstanceImpl;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.weld.contexts.PassivationCapableContextual;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SerializableContextualInstanceImplMarshaller<C extends Contextual<I> & PassivationCapable, I>
implements ProtoStreamMarshaller<SerializableContextualInstanceImpl<C, I>> {
    private static final int CONTEXTUAL_INDEX = 1;
    private static final int INSTANCE_INDEX = 2;
    private static final int PROXY_CLASS_INDEX = 3;
    private static final int METHOD_HANDLER_INDEX = 4;
    private static final int CREATIONAL_CONTEXT_INDEX = 5;

    public Class<? extends SerializableContextualInstanceImpl<C, I>> getJavaClass() {
        return SerializableContextualInstanceImpl.class;
    }

    public SerializableContextualInstanceImpl<C, I> readFrom(ProtoStreamReader reader) throws IOException {
        PassivationCapableContextual contextual = null;
        Object instance = null;
        CreationalContext creationalContext = null;
        Class proxyClass = null;
        MethodHandler handler = null;
        block7: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    contextual = (PassivationCapableContextual)reader.readAny(PassivationCapableContextual.class);
                    continue block7;
                }
                case 2: {
                    instance = reader.readAny();
                    continue block7;
                }
                case 3: {
                    proxyClass = (Class)reader.readObject(Class.class);
                    continue block7;
                }
                case 4: {
                    handler = (MethodHandler)reader.readAny(MethodHandler.class);
                    continue block7;
                }
                case 5: {
                    creationalContext = (CreationalContext)reader.readAny(CreationalContext.class);
                    continue block7;
                }
            }
            reader.skipField(tag);
        }
        if (proxyClass != null) {
            final Class targetClass = proxyClass;
            final ProxyInstantiator instantiator = (ProxyInstantiator)Container.instance((String)contextual.getContextId()).services().get(ProxyInstantiator.class);
            PrivilegedAction action = new PrivilegedAction<I>(){

                @Override
                public I run() {
                    try {
                        return instantiator.newInstance(targetClass);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
            instance = WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
            if (handler != null) {
                ((ProxyObject)instance).weld_setHandler(handler);
            }
        }
        return new SerializableContextualInstanceImpl((SerializableContextual)contextual, instance, creationalContext);
    }

    public void writeTo(ProtoStreamWriter writer, SerializableContextualInstanceImpl<C, I> contextualInstance) throws IOException {
        writer.writeAny(1, (Object)contextualInstance.getContextual());
        Object instance = contextualInstance.getInstance();
        if (instance instanceof ProxyObject) {
            writer.writeObject(3, instance.getClass());
            writer.writeAny(4, (Object)((ProxyObject)instance).weld_getHandler());
        } else {
            writer.writeAny(2, instance);
        }
        writer.writeAny(5, (Object)contextualInstance.getCreationalContext());
    }
}

