/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.EJBSecurityDomainService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.ApplicationSecurityDomainConfig;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.server.security.VirtualDomainMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.security.auth.server.SecurityDomain;

public class EJBDefaultSecurityDomainProcessor
implements DeploymentUnitProcessor,
Function<String, ApplicationSecurityDomainConfig>,
BooleanSupplier {
    private final AtomicReference<String> defaultSecurityDomainName;
    private final Iterable<ApplicationSecurityDomainConfig> knownApplicationSecurityDomains;
    private final Iterable<String> outflowSecurityDomains;

    public EJBDefaultSecurityDomainProcessor(AtomicReference<String> defaultSecurityDomainName, Iterable<ApplicationSecurityDomainConfig> knownApplicationSecurityDomains, Iterable<String> outflowSecurityDomains) {
        this.defaultSecurityDomainName = defaultSecurityDomainName;
        this.knownApplicationSecurityDomains = knownApplicationSecurityDomains;
        this.outflowSecurityDomains = outflowSecurityDomains;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block19: {
            ServiceName ejbSecurityDomainServiceName;
            ServiceName elytronDomainServiceName;
            Collection componentDescriptions;
            DeploymentUnit deploymentUnit;
            block17: {
                EJBSecurityDomainService ejbSecurityDomainService;
                block18: {
                    boolean useDefaultElytronMapping;
                    deploymentUnit = phaseContext.getDeploymentUnit();
                    EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
                    if (eeModuleDescription == null) {
                        return;
                    }
                    componentDescriptions = eeModuleDescription.getComponentDescriptions();
                    if (componentDescriptions == null || componentDescriptions.isEmpty()) {
                        return;
                    }
                    String defaultSecurityDomain = eeModuleDescription.getDefaultSecurityDomain() == null ? this.defaultSecurityDomainName.get() : eeModuleDescription.getDefaultSecurityDomain();
                    CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
                    SecurityMetaData securityMetaData = (SecurityMetaData)deploymentUnit.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
                    elytronDomainServiceName = securityMetaData != null ? securityMetaData.getSecurityDomain() : null;
                    ejbSecurityDomainServiceName = deploymentUnit.getServiceName().append(EJBSecurityDomainService.SERVICE_NAME);
                    ApplicationSecurityDomainConfig defaultDomainMapping = this.apply(defaultSecurityDomain);
                    ServiceName defaultElytronDomainServiceName = defaultDomainMapping != null ? support.getCapabilityServiceName("org.wildfly.ejb3.application-security-domain", new String[]{defaultSecurityDomain}).append(new String[]{"security-domain"}) : null;
                    ApplicationSecurityDomainConfig selectedElytronDomainConfig = null;
                    if (elytronDomainServiceName != null) break block17;
                    String selectedElytronDomainName = null;
                    boolean legacyDomainDefined = false;
                    boolean defaultRequired = false;
                    for (ComponentDescription componentDescription : componentDescriptions) {
                        Object definedDomainMapping;
                        if (!(componentDescription instanceof EJBComponentDescription)) continue;
                        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
                        ejbComponentDescription.setDefaultSecurityDomain(defaultSecurityDomain);
                        String definedSecurityDomain = ejbComponentDescription.getDefinedSecurityDomain();
                        defaultRequired = defaultRequired || definedSecurityDomain == null;
                        Object object = definedDomainMapping = definedSecurityDomain != null ? this.apply(definedSecurityDomain) : null;
                        if (definedDomainMapping != null) {
                            if (selectedElytronDomainName == null) {
                                selectedElytronDomainName = definedSecurityDomain;
                                selectedElytronDomainConfig = definedDomainMapping;
                                continue;
                            }
                            if (selectedElytronDomainName.equals(definedSecurityDomain)) continue;
                            throw EjbLogger.ROOT_LOGGER.multipleSecurityDomainsDetected();
                        }
                        if (definedSecurityDomain == null) continue;
                        if (this.isVirtualDomain(definedSecurityDomain, phaseContext)) {
                            elytronDomainServiceName = VirtualDomainMarkerUtility.virtualDomainName((String)definedSecurityDomain);
                        }
                        if (elytronDomainServiceName != null) {
                            selectedElytronDomainName = definedSecurityDomain;
                            continue;
                        }
                        legacyDomainDefined = true;
                    }
                    if (defaultRequired && selectedElytronDomainName == null) {
                        ServiceName topLevelElytronDomainServiceName;
                        DeploymentUnit topLevelDeployment = EJBDefaultSecurityDomainProcessor.toRoot(deploymentUnit);
                        SecurityMetaData topLevelSecurityMetaData = (SecurityMetaData)topLevelDeployment.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
                        ServiceName serviceName = topLevelElytronDomainServiceName = topLevelSecurityMetaData != null ? topLevelSecurityMetaData.getSecurityDomain() : null;
                        if (topLevelElytronDomainServiceName != null) {
                            elytronDomainServiceName = topLevelElytronDomainServiceName;
                            useDefaultElytronMapping = true;
                        } else if (defaultDomainMapping != null) {
                            selectedElytronDomainName = defaultSecurityDomain;
                            selectedElytronDomainConfig = defaultDomainMapping;
                            elytronDomainServiceName = defaultElytronDomainServiceName;
                            useDefaultElytronMapping = !legacyDomainDefined;
                        } else {
                            useDefaultElytronMapping = false;
                        }
                    } else {
                        useDefaultElytronMapping = false;
                    }
                    if (selectedElytronDomainConfig == null) break block18;
                    ejbSecurityDomainService = new EJBSecurityDomainService(deploymentUnit);
                    ServiceName applicationSecurityDomainServiceName = support.getCapabilityServiceName("org.wildfly.ejb3.application-security-domain", new String[]{selectedElytronDomainName});
                    elytronDomainServiceName = applicationSecurityDomainServiceName.append(new String[]{"security-domain"});
                    ServiceBuilder builder = phaseContext.getServiceTarget().addService(ejbSecurityDomainServiceName, (Service)ejbSecurityDomainService).addDependency(applicationSecurityDomainServiceName, ApplicationSecurityDomainService.ApplicationSecurityDomain.class, ejbSecurityDomainService.getApplicationSecurityDomainInjector());
                    builder.install();
                    for (ComponentDescription componentDescription : componentDescriptions) {
                        if (!(componentDescription instanceof EJBComponentDescription)) continue;
                        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
                        String definedSecurityDomain = ejbComponentDescription.getDefinedSecurityDomain();
                        if (useDefaultElytronMapping || selectedElytronDomainName.equals(definedSecurityDomain)) {
                            ejbComponentDescription.setOutflowSecurityDomainsConfigured(this);
                            ejbComponentDescription.setSecurityDomainServiceName(elytronDomainServiceName);
                            ejbComponentDescription.setRequiresJacc(selectedElytronDomainConfig.isEnableJacc());
                            ejbComponentDescription.setLegacyCompliantPrincipalPropagation(selectedElytronDomainConfig.isLegacyCompliantPrincipalPropagation());
                            ejbComponentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.requires(ejbSecurityDomainServiceName)));
                            continue;
                        }
                        if (definedSecurityDomain != null || defaultDomainMapping == null) continue;
                        ejbComponentDescription.setOutflowSecurityDomainsConfigured(this);
                        ejbComponentDescription.setSecurityDomainServiceName(defaultElytronDomainServiceName);
                        ejbComponentDescription.setRequiresJacc(defaultDomainMapping.isEnableJacc());
                        ejbComponentDescription.setLegacyCompliantPrincipalPropagation(defaultDomainMapping.isLegacyCompliantPrincipalPropagation());
                        ejbComponentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.requires(ejbSecurityDomainServiceName)));
                    }
                    break block19;
                }
                if (elytronDomainServiceName == null) break block19;
                ejbSecurityDomainService = new EJBSecurityDomainService(deploymentUnit);
                ServiceBuilder builder = phaseContext.getServiceTarget().addService(ejbSecurityDomainServiceName, (Service)ejbSecurityDomainService).addDependency(elytronDomainServiceName, SecurityDomain.class, ejbSecurityDomainService.getSecurityDomainInjector());
                builder.install();
                for (ComponentDescription componentDescription : componentDescriptions) {
                    if (!(componentDescription instanceof EJBComponentDescription)) continue;
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
                    ejbComponentDescription.setSecurityDomainServiceName(elytronDomainServiceName);
                    ejbComponentDescription.setOutflowSecurityDomainsConfigured(this);
                    componentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.requires(ejbSecurityDomainServiceName)));
                }
                break block19;
            }
            EJBSecurityDomainService ejbSecurityDomainService = new EJBSecurityDomainService(deploymentUnit);
            ServiceBuilder builder = phaseContext.getServiceTarget().addService(ejbSecurityDomainServiceName, (Service)ejbSecurityDomainService).addDependency(elytronDomainServiceName, SecurityDomain.class, ejbSecurityDomainService.getSecurityDomainInjector());
            builder.install();
            for (ComponentDescription componentDescription : componentDescriptions) {
                if (!(componentDescription instanceof EJBComponentDescription)) continue;
                EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
                ejbComponentDescription.setSecurityDomainServiceName(elytronDomainServiceName);
                ejbComponentDescription.setOutflowSecurityDomainsConfigured(this);
                componentDescription.getConfigurators().add((context, description, configuration) -> configuration.getCreateDependencies().add((serviceBuilder, service) -> serviceBuilder.requires(ejbSecurityDomainServiceName)));
            }
        }
    }

    @Override
    public ApplicationSecurityDomainConfig apply(String name) {
        for (ApplicationSecurityDomainConfig applicationSecurityDomainConfig : this.knownApplicationSecurityDomains) {
            if (!applicationSecurityDomainConfig.isSameDomain(name)) continue;
            return applicationSecurityDomainConfig;
        }
        return null;
    }

    @Override
    public boolean getAsBoolean() {
        return this.outflowSecurityDomains.iterator().hasNext();
    }

    private <T> ServiceController<T> getService(ServiceRegistry serviceRegistry, ServiceName serviceName, Class<T> serviceType) {
        ServiceController controller = serviceRegistry.getService(serviceName);
        return controller;
    }

    private boolean isVirtualDomain(String definedSecurityDomain, DeploymentPhaseContext phaseContext) {
        ServiceController.State serviceState;
        ServiceName virtualDomainMetaDataName = VirtualDomainMarkerUtility.virtualDomainMetaDataName((DeploymentPhaseContext)phaseContext, (String)definedSecurityDomain);
        ServiceController<VirtualDomainMetaData> serviceContainer = this.getService(phaseContext.getServiceRegistry(), virtualDomainMetaDataName, VirtualDomainMetaData.class);
        return serviceContainer != null && (serviceState = serviceContainer.getState()) == ServiceController.State.UP;
    }

    private static DeploymentUnit toRoot(DeploymentUnit deploymentUnit) {
        DeploymentUnit result = deploymentUnit;
        DeploymentUnit parent = result.getParent();
        while (parent != null) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }
}

