/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v60.impl;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.v60.impl.AbstractAccess;
import org.infinispan.hibernate.cache.v60.impl.DomainDataRegionImpl;

class ReadOnlyEntityDataAccess
extends AbstractAccess
implements EntityDataAccess {
    ReadOnlyEntityDataAccess(AccessType accessType, AccessDelegate delegate, DomainDataRegionImpl region) {
        super(accessType, delegate, region);
    }

    public Object get(SharedSessionContractImplementor session, Object key) {
        return this.delegate.get((Object)session, key, session.getTransactionStartTimestamp());
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return this.delegate.putFromLoad((Object)session, key, value, session.getTransactionStartTimestamp(), version);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version, boolean minimalPutOverride) {
        return this.delegate.putFromLoad((Object)session, key, value, session.getTransactionStartTimestamp(), version, minimalPutOverride);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.insert((Object)session, key, value, version);
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.afterInsert((Object)session, key, value, version);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object o, Object o1, Object o2, Object o3, SoftLock softLock) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object o, Object o1) throws CacheException {
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock softLock) throws CacheException {
        this.delegate.unlockItem((Object)session, key);
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        this.delegate.remove((Object)session, key);
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createEntityKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getEntityId(cacheKey);
    }
}

