/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import java.io.IOException;
import org.jboss.marshalling.ClassNameTransformer;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.wildfly.common.annotation.NotNull;

public final class HttpMarshallerFactory {
    static final HttpMarshallerFactory DEFAULT_FACTORY = new HttpMarshallerFactory(null);
    private static final MarshallerFactory RIVER_MARSHALLER_FACTORY = new RiverMarshallerFactory();
    private final MarshallingConfiguration defaultConfiguration;
    private final ClassNameTransformer classNameTransformer;

    HttpMarshallerFactory(ClassNameTransformer classNameTransformer) {
        this.classNameTransformer = classNameTransformer;
        this.defaultConfiguration = this.createMarshallingConfiguration();
        this.defaultConfiguration.setClassNameTransformer(classNameTransformer);
    }

    public Marshaller createMarshaller() throws IOException {
        return RIVER_MARSHALLER_FACTORY.createMarshaller(this.defaultConfiguration);
    }

    public Marshaller createMarshaller(@NotNull ObjectResolver resolver) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setObjectResolver(resolver);
        return RIVER_MARSHALLER_FACTORY.createMarshaller(marshallingConfiguration);
    }

    public Marshaller createMarshaller(@NotNull ObjectTable table) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setObjectTable(table);
        return RIVER_MARSHALLER_FACTORY.createMarshaller(marshallingConfiguration);
    }

    public Marshaller createMarshaller(@NotNull ObjectResolver resolver, @NotNull ObjectTable table) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setObjectResolver(resolver);
        marshallingConfiguration.setObjectTable(table);
        return RIVER_MARSHALLER_FACTORY.createMarshaller(marshallingConfiguration);
    }

    public Marshaller createMarshaller(@NotNull ClassResolver resolver, @NotNull ObjectTable table) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setClassResolver(resolver);
        marshallingConfiguration.setObjectTable(table);
        return RIVER_MARSHALLER_FACTORY.createMarshaller(marshallingConfiguration);
    }

    public Unmarshaller createUnmarshaller() throws IOException {
        return RIVER_MARSHALLER_FACTORY.createUnmarshaller(this.defaultConfiguration);
    }

    public Unmarshaller createUnmarshaller(@NotNull ObjectResolver resolver) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setObjectResolver(resolver);
        return RIVER_MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
    }

    public Unmarshaller createUnmarshaller(@NotNull ClassResolver resolver) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setClassResolver(resolver);
        return RIVER_MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
    }

    public Unmarshaller createUnmarshaller(@NotNull ClassLoader cl) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setClassResolver(new SimpleClassResolver(cl));
        return RIVER_MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
    }

    public Unmarshaller createUnmarshaller(@NotNull ObjectTable table) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setObjectTable(table);
        return RIVER_MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
    }

    public Unmarshaller createUnmarshaller(@NotNull ObjectResolver resolver, @NotNull ObjectTable table) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setObjectResolver(resolver);
        marshallingConfiguration.setObjectTable(table);
        return RIVER_MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
    }

    public Unmarshaller createUnmarshaller(@NotNull ClassResolver resolver, @NotNull ObjectTable table) throws IOException {
        MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfiguration();
        marshallingConfiguration.setClassResolver(resolver);
        marshallingConfiguration.setObjectTable(table);
        return RIVER_MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
    }

    private MarshallingConfiguration createMarshallingConfiguration() {
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setVersion(2);
        config.setClassNameTransformer(this.classNameTransformer);
        return config;
    }
}

