/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.UnknownParameterException;
import org.hibernate.engine.jdbc.mutation.spi.BindingGroup;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;
import org.hibernate.type.descriptor.WrapperOptions;

public class JdbcValueBindingsImpl
implements JdbcValueBindings {
    private final MutationType mutationType;
    private final MutationTarget<?> mutationTarget;
    private final JdbcValueDescriptorAccess jdbcValueDescriptorAccess;
    private final SharedSessionContractImplementor session;
    private final Map<String, BindingGroup> bindingGroupMap = new HashMap<String, BindingGroup>();

    public JdbcValueBindingsImpl(MutationType mutationType, MutationTarget<?> mutationTarget, JdbcValueDescriptorAccess jdbcValueDescriptorAccess, SharedSessionContractImplementor session) {
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.jdbcValueDescriptorAccess = jdbcValueDescriptorAccess;
        this.session = session;
    }

    @Override
    public BindingGroup getBindingGroup(String tableName) {
        return this.bindingGroupMap.get(tableName);
    }

    @Override
    public void bindValue(Object value, String tableName, String columnName, ParameterUsage usage) {
        JdbcValueDescriptor jdbcValueDescriptor = this.jdbcValueDescriptorAccess.resolveValueDescriptor(tableName, columnName, usage);
        if (jdbcValueDescriptor == null) {
            throw new UnknownParameterException(this.mutationType, this.mutationTarget, tableName, columnName, usage);
        }
        this.resolveBindingGroup(tableName).bindValue(columnName, value, jdbcValueDescriptor);
    }

    private BindingGroup resolveBindingGroup(String tableName) {
        BindingGroup existing = this.bindingGroupMap.get(tableName);
        if (existing != null) {
            assert (tableName.equals(existing.getTableName()));
            return existing;
        }
        BindingGroup created = new BindingGroup(tableName);
        this.bindingGroupMap.put(tableName, created);
        return created;
    }

    @Override
    public void beforeStatement(PreparedStatementDetails statementDetails) {
        BindingGroup bindingGroup = this.bindingGroupMap.get(statementDetails.getMutatingTableDetails().getTableName());
        if (bindingGroup == null) {
            statementDetails.resolveStatement();
        } else {
            bindingGroup.forEachBinding(binding -> {
                try {
                    binding.getValueBinder().bind(statementDetails.resolveStatement(), binding.getValue(), binding.getPosition(), (WrapperOptions)this.session);
                }
                catch (SQLException e) {
                    throw this.session.getJdbcServices().getSqlExceptionHelper().convert(e, String.format(Locale.ROOT, "Unable to bind parameter #%s - %s", binding.getPosition(), binding.getValue()));
                }
            });
        }
    }

    @Override
    public void afterStatement(TableMapping mutatingTable) {
        BindingGroup bindingGroup = this.bindingGroupMap.remove(mutatingTable.getTableName());
        if (bindingGroup == null) {
            return;
        }
        bindingGroup.clear();
    }

    @FunctionalInterface
    public static interface JdbcValueDescriptorAccess {
        public JdbcValueDescriptor resolveValueDescriptor(String var1, String var2, ParameterUsage var3);
    }
}

