/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import jakarta.persistence.PersistenceException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.MapBackedClassValue;
import org.hibernate.jpa.event.spi.Callback;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackType;

final class CallbackRegistryImpl
implements CallbackRegistry {
    private final MapBackedClassValue<Callback[]> preCreates;
    private final MapBackedClassValue<Callback[]> postCreates;
    private final MapBackedClassValue<Callback[]> preRemoves;
    private final MapBackedClassValue<Callback[]> postRemoves;
    private final MapBackedClassValue<Callback[]> preUpdates;
    private final MapBackedClassValue<Callback[]> postUpdates;
    private final MapBackedClassValue<Callback[]> postLoads;

    public CallbackRegistryImpl(Map<Class<?>, Callback[]> preCreates, Map<Class<?>, Callback[]> postCreates, Map<Class<?>, Callback[]> preRemoves, Map<Class<?>, Callback[]> postRemoves, Map<Class<?>, Callback[]> preUpdates, Map<Class<?>, Callback[]> postUpdates, Map<Class<?>, Callback[]> postLoads) {
        this.preCreates = new MapBackedClassValue<Callback[]>(preCreates);
        this.postCreates = new MapBackedClassValue<Callback[]>(postCreates);
        this.preRemoves = new MapBackedClassValue<Callback[]>(preRemoves);
        this.postRemoves = new MapBackedClassValue<Callback[]>(postRemoves);
        this.preUpdates = new MapBackedClassValue<Callback[]>(preUpdates);
        this.postUpdates = new MapBackedClassValue<Callback[]>(postUpdates);
        this.postLoads = new MapBackedClassValue<Callback[]>(postLoads);
    }

    @Override
    public boolean hasRegisteredCallbacks(Class<?> entityClass, CallbackType callbackType) {
        MapBackedClassValue<Callback[]> map = this.determineAppropriateCallbackMap(callbackType);
        return this.notEmpty(map.get(entityClass));
    }

    @Override
    public void preCreate(Object bean) {
        this.callback(this.preCreates.get(bean.getClass()), bean);
    }

    private boolean notEmpty(Callback[] callbacks) {
        return callbacks != null && callbacks.length > 0;
    }

    @Override
    public void postCreate(Object bean) {
        this.callback(this.postCreates.get(bean.getClass()), bean);
    }

    @Override
    public boolean preUpdate(Object bean) {
        return this.callback(this.preUpdates.get(bean.getClass()), bean);
    }

    @Override
    public void postUpdate(Object bean) {
        this.callback(this.postUpdates.get(bean.getClass()), bean);
    }

    @Override
    public void preRemove(Object bean) {
        this.callback(this.preRemoves.get(bean.getClass()), bean);
    }

    @Override
    public void postRemove(Object bean) {
        this.callback(this.postRemoves.get(bean.getClass()), bean);
    }

    @Override
    public boolean postLoad(Object bean) {
        return this.callback(this.postLoads.get(bean.getClass()), bean);
    }

    @Override
    public void release() {
        this.preCreates.dispose();
        this.postCreates.dispose();
        this.preRemoves.dispose();
        this.postRemoves.dispose();
        this.preUpdates.dispose();
        this.postUpdates.dispose();
        this.postLoads.dispose();
    }

    private boolean callback(Callback[] callbacks, Object bean) {
        if (callbacks != null && callbacks.length != 0) {
            for (Callback callback : callbacks) {
                callback.performCallback(bean);
            }
            return true;
        }
        return false;
    }

    private MapBackedClassValue<Callback[]> determineAppropriateCallbackMap(CallbackType callbackType) {
        if (callbackType == CallbackType.PRE_PERSIST) {
            return this.preCreates;
        }
        if (callbackType == CallbackType.POST_PERSIST) {
            return this.postCreates;
        }
        if (callbackType == CallbackType.PRE_REMOVE) {
            return this.preRemoves;
        }
        if (callbackType == CallbackType.POST_REMOVE) {
            return this.postRemoves;
        }
        if (callbackType == CallbackType.PRE_UPDATE) {
            return this.preUpdates;
        }
        if (callbackType == CallbackType.POST_UPDATE) {
            return this.postUpdates;
        }
        if (callbackType == CallbackType.POST_LOAD) {
            return this.postLoads;
        }
        throw new PersistenceException("Unrecognized JPA callback type [" + callbackType + "]");
    }

    public static class Builder {
        private final Map<Class<?>, Callback[]> preCreates = new HashMap();
        private final Map<Class<?>, Callback[]> postCreates = new HashMap();
        private final Map<Class<?>, Callback[]> preRemoves = new HashMap();
        private final Map<Class<?>, Callback[]> postRemoves = new HashMap();
        private final Map<Class<?>, Callback[]> preUpdates = new HashMap();
        private final Map<Class<?>, Callback[]> postUpdates = new HashMap();
        private final Map<Class<?>, Callback[]> postLoads = new HashMap();

        public void registerCallbacks(Class<?> entityClass, Callback[] callbacks) {
            if (callbacks == null || callbacks.length == 0) {
                return;
            }
            for (Callback callback : callbacks) {
                Map<Class<?>, Callback[]> map = this.determineAppropriateCallbackMap(callback.getCallbackType());
                Callback[] entityCallbacks = map.get(entityClass);
                if (entityCallbacks == null) {
                    entityCallbacks = new Callback[]{};
                }
                entityCallbacks = ArrayHelper.join(entityCallbacks, callback);
                map.put(entityClass, entityCallbacks);
            }
        }

        private Map<Class<?>, Callback[]> determineAppropriateCallbackMap(CallbackType callbackType) {
            if (callbackType == CallbackType.PRE_PERSIST) {
                return this.preCreates;
            }
            if (callbackType == CallbackType.POST_PERSIST) {
                return this.postCreates;
            }
            if (callbackType == CallbackType.PRE_REMOVE) {
                return this.preRemoves;
            }
            if (callbackType == CallbackType.POST_REMOVE) {
                return this.postRemoves;
            }
            if (callbackType == CallbackType.PRE_UPDATE) {
                return this.preUpdates;
            }
            if (callbackType == CallbackType.POST_UPDATE) {
                return this.postUpdates;
            }
            if (callbackType == CallbackType.POST_LOAD) {
                return this.postLoads;
            }
            throw new PersistenceException("Unrecognized JPA callback type [" + callbackType + "]");
        }

        protected CallbackRegistryImpl build() {
            return new CallbackRegistryImpl(this.preCreates, this.postCreates, this.preRemoves, this.postRemoves, this.preUpdates, this.postUpdates, this.postLoads);
        }
    }
}

