/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public abstract class FileBasedNodeManager
extends NodeManager {
    private static final Logger LOGGER = Logger.getLogger(FileBasedNodeManager.class);
    protected static final byte FIRST_TIME_START = 48;
    public static final String SERVER_LOCK_NAME = "server.lock";
    public static final String SERVER_ACTIVATION_SEQUENCE_NAME = "server.activation.sequence";
    private static final String ACCESS_MODE = "rw";
    private final File directory;
    private final Path activationSequencePath;
    protected FileChannel channel;
    protected FileChannel activationSequenceChannel;

    public FileBasedNodeManager(boolean replicatedBackup, File directory) {
        super(replicatedBackup);
        this.directory = directory;
        if (directory != null) {
            directory.mkdirs();
        }
        this.activationSequencePath = new File(directory, SERVER_ACTIVATION_SEQUENCE_NAME).toPath();
    }

    private FileChannel useActivationSequenceChannel(boolean createIfNotExists) throws IOException {
        OpenOption[] openOptions;
        FileChannel channel = this.activationSequenceChannel;
        if (channel != null) {
            return channel;
        }
        if (!createIfNotExists) {
            if (!Files.exists(this.activationSequencePath, new LinkOption[0])) {
                return null;
            }
            openOptions = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        } else {
            openOptions = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        }
        this.activationSequenceChannel = channel = FileChannel.open(this.activationSequencePath, openOptions);
        return channel;
    }

    @Override
    public long readNodeActivationSequence() throws NodeManager.NodeManagerException {
        if (!this.isStarted()) {
            throw new NodeManager.NodeManagerException(new IllegalStateException("node manager must be started first"));
        }
        try {
            FileChannel channel = this.useActivationSequenceChannel(false);
            if (channel == null) {
                this.setNodeActivationSequence(-1L);
                return -1L;
            }
            ByteBuffer tmpBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            if (channel.read(tmpBuffer, 0L) != 8) {
                this.setNodeActivationSequence(-1L);
                return -1L;
            }
            tmpBuffer.flip();
            long activationSequence = tmpBuffer.getLong(0);
            this.setNodeActivationSequence(activationSequence);
            return activationSequence;
        }
        catch (IOException ie) {
            throw new NodeManager.NodeManagerException(ie);
        }
    }

    @Override
    public void writeNodeActivationSequence(long sequence) throws NodeManager.NodeManagerException {
        if (!this.isStarted()) {
            throw new NodeManager.NodeManagerException(new IllegalStateException("node manager must be started first"));
        }
        try {
            FileChannel channel = this.useActivationSequenceChannel(true);
            ByteBuffer tmpBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            tmpBuffer.putLong(0, sequence);
            channel.write(tmpBuffer, 0L);
            channel.force(false);
            this.setNodeActivationSequence(sequence);
        }
        catch (IOException ie) {
            throw new NodeManager.NodeManagerException(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setUpServerLockFile() throws IOException {
        File serverLockFile = this.newFile(SERVER_LOCK_NAME);
        boolean fileCreated = false;
        int count = 0;
        while (!serverLockFile.exists()) {
            try {
                fileCreated = serverLockFile.createNewFile();
            }
            catch (RuntimeException e) {
                ActiveMQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
            catch (IOException e) {
                if (count < 5) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++count;
                    continue;
                }
                ActiveMQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
            }
            finally {
                this.channel = null;
            }
        }
        RandomAccessFile raFile = new RandomAccessFile(serverLockFile, ACCESS_MODE);
        this.channel = raFile.getChannel();
        if (fileCreated) {
            ByteBuffer id = ByteBuffer.allocateDirect(3);
            byte[] bytes = new byte[]{48, 48, 48};
            id.put(bytes, 0, 3);
            id.position(0);
            this.channel.write(id, 0L);
            this.channel.force(true);
        }
        this.createNodeId();
    }

    protected final File newFile(String fileName) {
        return new File(this.directory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void createNodeId() throws IOException {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            ByteBuffer id = ByteBuffer.allocateDirect(16);
            int read = this.channel.read(id, 3L);
            if (this.replicatedBackup) {
                id.position(0);
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else if (read != 16) {
                this.setUUID(UUIDGenerator.getInstance().generateUUID());
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else {
                byte[] bytes = new byte[16];
                id.position(0);
                id.get(bytes);
                this.setUUID(new UUID(1, bytes));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        FileChannel channelCopy = this.channel;
        try {
            if (channelCopy != null) {
                channelCopy.close();
            }
        }
        finally {
            try {
                this.setNodeActivationSequence(-1L);
                FileChannel dataVersionChannel = this.activationSequenceChannel;
                this.activationSequenceChannel = null;
                if (dataVersionChannel != null) {
                    dataVersionChannel.close();
                }
            }
            finally {
                super.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBackup() throws NodeManager.NodeManagerException {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            if (this.replicatedBackup && this.getNodeId() != null) {
                try {
                    this.setUpServerLockFile();
                    long nodeActivationSequence = this.nodeActivationSequence;
                    if (nodeActivationSequence != -1L) {
                        this.writeNodeActivationSequence(nodeActivationSequence);
                    }
                }
                catch (IOException e) {
                    throw new NodeManager.NodeManagerException(e);
                }
            }
            super.stopBackup();
        }
    }
}

