/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import jakarta.security.auth.message.config.AuthConfigFactory;
import java.security.Provider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.extension.ExpressionResolverExtension;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.AdvancedModifiableKeyStoreDecorator;
import org.wildfly.extension.elytron.AggregateRealmDefinition;
import org.wildfly.extension.elytron.AuditResourceDefinitions;
import org.wildfly.extension.elytron.AuthenticationClientDefinitions;
import org.wildfly.extension.elytron.AuthenticationContextAssociationProcessor;
import org.wildfly.extension.elytron.AuthenticationContextDependencyProcessor;
import org.wildfly.extension.elytron.AuthenticationFactoryDefinitions;
import org.wildfly.extension.elytron.CachingRealmDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CertificateAuthorityAccountDefinition;
import org.wildfly.extension.elytron.CertificateAuthorityDefinition;
import org.wildfly.extension.elytron.CredentialStoreResourceDefinition;
import org.wildfly.extension.elytron.CustomComponentDefinition;
import org.wildfly.extension.elytron.DefaultAuthenticationContextService;
import org.wildfly.extension.elytron.DefaultSSLContextService;
import org.wildfly.extension.elytron.DependencyProcessor;
import org.wildfly.extension.elytron.DirContextDefinition;
import org.wildfly.extension.elytron.DistributedRealmDefinition;
import org.wildfly.extension.elytron.DomainDefinition;
import org.wildfly.extension.elytron.EESecurityDependencyProcessor;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronOperationStepHandler;
import org.wildfly.extension.elytron.ElytronRemoveStepHandler;
import org.wildfly.extension.elytron.ElytronWriteAttributeHandler;
import org.wildfly.extension.elytron.EvidenceDecoderDefinitions;
import org.wildfly.extension.elytron.ExpressionResolverResourceDefinition;
import org.wildfly.extension.elytron.FailoverRealmDefinition;
import org.wildfly.extension.elytron.FileSystemRealmDefinition;
import org.wildfly.extension.elytron.FilteringKeyStoreDefinition;
import org.wildfly.extension.elytron.HttpServerDefinitions;
import org.wildfly.extension.elytron.JaasRealmDefinition;
import org.wildfly.extension.elytron.JaspiDefinition;
import org.wildfly.extension.elytron.JdbcRealmDefinition;
import org.wildfly.extension.elytron.KerberosSecurityFactoryDefinition;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.KeyStoreRealmDefinition;
import org.wildfly.extension.elytron.LdapKeyStoreDefinition;
import org.wildfly.extension.elytron.LdapRealmDefinition;
import org.wildfly.extension.elytron.ModifiableKeyStoreDecorator;
import org.wildfly.extension.elytron.ModifiableRealmDecorator;
import org.wildfly.extension.elytron.PermissionMapperDefinitions;
import org.wildfly.extension.elytron.PermissionSetDefinition;
import org.wildfly.extension.elytron.PolicyDefinitions;
import org.wildfly.extension.elytron.PrincipalDecoderDefinitions;
import org.wildfly.extension.elytron.PrincipalTransformerDefinitions;
import org.wildfly.extension.elytron.PropertiesRealmDefinition;
import org.wildfly.extension.elytron.ProviderDefinitions;
import org.wildfly.extension.elytron.ProviderRegistrationService;
import org.wildfly.extension.elytron.RealmDefinitions;
import org.wildfly.extension.elytron.RealmMapperDefinitions;
import org.wildfly.extension.elytron.RoleDecoderDefinitions;
import org.wildfly.extension.elytron.RoleMapperDefinitions;
import org.wildfly.extension.elytron.SSLContextDependencyProcessor;
import org.wildfly.extension.elytron.SSLDefinitions;
import org.wildfly.extension.elytron.SaslServerDefinitions;
import org.wildfly.extension.elytron.SecretKeyCredentialStoreDefinition;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.SecurityMetaDataProcessor;
import org.wildfly.extension.elytron.SecurityPropertiesWriteHandler;
import org.wildfly.extension.elytron.SecurityPropertyService;
import org.wildfly.extension.elytron.TokenRealmDefinition;
import org.wildfly.extension.elytron.VirtualDomainDefinition;
import org.wildfly.extension.elytron.VirtualSecurityDomainNameProcessor;
import org.wildfly.extension.elytron.VirtualSecurityDomainProcessor;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.CredentialSecurityFactory;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.extension.elytron.capabilities._private.SecurityEventListener;
import org.wildfly.extension.elytron.expression.DeploymentExpressionResolverProcessor;
import org.wildfly.security.Version;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.jaspi.ElytronAuthConfigFactory;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.ReadPropertyAction;

class ElytronDefinition
extends SimpleResourceDefinition {
    static final String RESTORE_DEFAULT_SSL_CONTEXT = ElytronDefinition.class.getPackage().getName() + ".restore-default-ssl-context";
    private static final OperationContext.AttachmentKey<SecurityPropertyService> SECURITY_PROPERTY_SERVICE_KEY = OperationContext.AttachmentKey.create(SecurityPropertyService.class);
    private static final AuthenticationContextDependencyProcessor AUTHENITCATION_CONTEXT_PROCESSOR = new AuthenticationContextDependencyProcessor();
    static final SimpleAttributeDefinition DEFAULT_AUTHENTICATION_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-authentication-context", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.authentication-context", Capabilities.ELYTRON_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition DEFAULT_SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-ssl-context", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.ssl-context", Capabilities.ELYTRON_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition INITIAL_PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("initial-providers", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.providers", Capabilities.ELYTRON_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FINAL_PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("final-providers", ModelType.STRING, true).setCapabilityReference("org.wildfly.security.providers", Capabilities.ELYTRON_RUNTIME_CAPABILITY)).setRestartAllServices()).build();
    static final StringListAttributeDefinition DISALLOWED_PROVIDERS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("disallowed-providers").setRequired(false)).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setRestartJVM()).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition REGISTER_JASPI_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("register-jaspi-factory", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).setRestartAllServices()).build();
    static final PropertiesAttributeDefinition SECURITY_PROPERTIES = new PropertiesAttributeDefinition.Builder("security-properties", true).build();
    private final AtomicReference<ExpressionResolverExtension> resolverReference;
    private static final Supplier<Boolean> ALLOW_DELEGATION = new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            if (WildFlySecurityManager.isChecking()) {
                return SecurityActions.doPrivileged(() -> SecurityDomain.getCurrent() == null);
            }
            return SecurityDomain.getCurrent() == null;
        }
    };

    ElytronDefinition(AtomicReference<ExpressionResolverExtension> resolverReference) {
        super(new SimpleResourceDefinition.Parameters(ElytronExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(new String[0])).setAddHandler((OperationStepHandler)new ElytronAdd()).setRemoveHandler((OperationStepHandler)new ElytronRemove()).setCapabilities(new RuntimeCapability[]{Capabilities.ELYTRON_RUNTIME_CAPABILITY}).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("elytron", "elytron-security", true, true, true)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("elytron", "elytron-security", false))}));
        this.resolverReference = resolverReference;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        boolean serverOrHostController = ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration);
        resourceRegistration.registerSubModel(ExpressionResolverResourceDefinition.getExpressionResolverDefinition(resourceRegistration.getPathAddress(), this.resolverReference));
        resourceRegistration.registerSubModel(ProviderDefinitions.getAggregateProvidersDefinition());
        resourceRegistration.registerSubModel(ProviderDefinitions.getProviderLoaderDefinition(serverOrHostController));
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getAggregateSecurityEventListenerDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition<Consumer, SecurityEventListener>(Consumer.class, SecurityEventListener::from, "custom-security-event-listener", Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getFileAuditLogResourceDefinition());
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getPeriodicRotatingFileAuditLogResourceDefinition());
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getSizeRotatingFileAuditLogResourceDefinition());
        resourceRegistration.registerSubModel(AuditResourceDefinitions.getSyslogAuditLogResourceDefinition());
        resourceRegistration.registerSubModel(AuthenticationFactoryDefinitions.getSaslAuthenticationFactory());
        resourceRegistration.registerSubModel(AuthenticationFactoryDefinitions.getHttpAuthenticationFactory());
        resourceRegistration.registerSubModel((ResourceDefinition)new DomainDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new VirtualDomainDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new AggregateRealmDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(SecurityRealm.class, Function.identity(), "custom-realm", Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(ModifiableRealmDecorator.wrap(new CustomComponentDefinition(ModifiableSecurityRealm.class, Function.identity(), "custom-modifiable-realm", Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY)));
        resourceRegistration.registerSubModel(RealmDefinitions.getIdentityRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new JdbcRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new KeyStoreRealmDefinition());
        resourceRegistration.registerSubModel(PropertiesRealmDefinition.create(serverOrHostController));
        resourceRegistration.registerSubModel((ResourceDefinition)new TokenRealmDefinition());
        resourceRegistration.registerSubModel(ModifiableRealmDecorator.wrap((ResourceDefinition)new LdapRealmDefinition()));
        resourceRegistration.registerSubModel(ModifiableRealmDecorator.wrap((ResourceDefinition)new FileSystemRealmDefinition()));
        resourceRegistration.registerSubModel((ResourceDefinition)new CachingRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new DistributedRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new FailoverRealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new JaasRealmDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(CredentialSecurityFactory.class, Function.identity(), "custom-credential-security-factory", Capabilities.SECURITY_FACTORY_CREDENTIAL_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(KerberosSecurityFactoryDefinition.getKerberosSecurityFactoryDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(PermissionMapper.class, Function.identity(), "custom-permission-mapper", Capabilities.PERMISSION_MAPPER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(PermissionMapperDefinitions.getLogicalPermissionMapper());
        resourceRegistration.registerSubModel(PermissionMapperDefinitions.getSimplePermissionMapper());
        resourceRegistration.registerSubModel(PermissionMapperDefinitions.getConstantPermissionMapper());
        resourceRegistration.registerSubModel(PermissionSetDefinition.getPermissionSet());
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getAggregatePrincipalDecoderDefinition());
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getConcatenatingPrincipalDecoder());
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getConstantPrincipalDecoder());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(PrincipalDecoder.class, Function.identity(), "custom-principal-decoder", Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(PrincipalDecoderDefinitions.getX500AttributePrincipalDecoder());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getAggregatePrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getChainedPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getConstantPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(PrincipalTransformer.class, Function.identity(), "custom-principal-transformer", Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getRegexPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getRegexValidatingPrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(PrincipalTransformerDefinitions.getCasePrincipalTransformerDefinition());
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getConstantRealmMapper());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(RealmMapper.class, Function.identity(), "custom-realm-mapper", Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getMappedRegexRealmMapper());
        resourceRegistration.registerSubModel(RealmMapperDefinitions.getSimpleRegexRealmMapperDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(RoleDecoder.class, Function.identity(), "custom-role-decoder", Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(RoleDecoderDefinitions.getSimpleRoleDecoderDefinition());
        resourceRegistration.registerSubModel(RoleDecoderDefinitions.getSourceAddressRoleDecoderDefinition());
        resourceRegistration.registerSubModel(RoleDecoderDefinitions.getAggregateRoleDecoderDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAddSuffixRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAddPrefixRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getAggregateRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getConstantRoleMapperDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(RoleMapper.class, Function.identity(), "custom-role-mapper", Capabilities.ROLE_MAPPER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getLogicalRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getMappedRoleMapperDefinition());
        resourceRegistration.registerSubModel(RoleMapperDefinitions.getRegexRoleMapperDefinition());
        resourceRegistration.registerSubModel(EvidenceDecoderDefinitions.getX500SubjectEvidenceDecoderDefinition());
        resourceRegistration.registerSubModel(EvidenceDecoderDefinitions.getX509SubjectAltNameEvidenceDecoderDefinition());
        resourceRegistration.registerSubModel(new CustomComponentDefinition(EvidenceDecoder.class, Function.identity(), "custom-evidence-decoder", Capabilities.EVIDENCE_DECODER_RUNTIME_CAPABILITY));
        resourceRegistration.registerSubModel(EvidenceDecoderDefinitions.getAggregateEvidenceDecoderDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getAggregateHttpServerFactoryDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getConfigurableHttpServerMechanismFactoryDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getProviderHttpServerMechanismFactoryDefinition());
        resourceRegistration.registerSubModel(HttpServerDefinitions.getServiceLoaderServerMechanismFactoryDefinition());
        resourceRegistration.registerSubModel(JaspiDefinition.getJaspiServletConfigurationDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getAggregateSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getConfigurableSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getMechanismProviderFilteringSaslServerFactory());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getProviderSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(SaslServerDefinitions.getServiceLoaderSaslServerFactoryDefinition());
        resourceRegistration.registerSubModel(AdvancedModifiableKeyStoreDecorator.wrap((ResourceDefinition)new KeyStoreDefinition()));
        resourceRegistration.registerSubModel(ModifiableKeyStoreDecorator.wrap((ResourceDefinition)new LdapKeyStoreDefinition()));
        resourceRegistration.registerSubModel(ModifiableKeyStoreDecorator.wrap((ResourceDefinition)new FilteringKeyStoreDefinition()));
        resourceRegistration.registerSubModel(SSLDefinitions.getKeyManagerDefinition());
        resourceRegistration.registerSubModel(SSLDefinitions.getTrustManagerDefinition());
        resourceRegistration.registerSubModel(SSLDefinitions.getServerSSLContextDefinition(serverOrHostController));
        resourceRegistration.registerSubModel(SSLDefinitions.getClientSSLContextDefinition(serverOrHostController));
        resourceRegistration.registerSubModel(SSLDefinitions.getServerSNISSLContextDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new CertificateAuthorityDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new CertificateAuthorityAccountDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new CredentialStoreResourceDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new SecretKeyCredentialStoreDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new DirContextDefinition());
        resourceRegistration.registerSubModel(AuthenticationClientDefinitions.getAuthenticationClientDefinition());
        resourceRegistration.registerSubModel(AuthenticationClientDefinitions.getAuthenticationContextDefinition());
        resourceRegistration.registerSubModel(PolicyDefinitions.getPolicy());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{INITIAL_PROVIDERS, FINAL_PROVIDERS, DISALLOWED_PROVIDERS, REGISTER_JASPI_FACTORY});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)INITIAL_PROVIDERS, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)FINAL_PROVIDERS, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DISALLOWED_PROVIDERS, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_AUTHENTICATION_CONTEXT, null, (OperationStepHandler)new ElytronWriteAttributeHandler<Void>(new AttributeDefinition[]{DEFAULT_AUTHENTICATION_CONTEXT}){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(resolvedValue.isDefined() ? resolvedValue.asString() : null);
                return !context.isBooting();
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
                AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(valueToRestore.isDefined() ? valueToRestore.asString() : null);
            }
        });
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SECURITY_PROPERTIES, null, (OperationStepHandler)new SecurityPropertiesWriteHandler(SECURITY_PROPERTIES));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)REGISTER_JASPI_FACTORY, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_SSL_CONTEXT, null, (OperationStepHandler)new ElytronWriteAttributeHandler<Void>(new AttributeDefinition[]{DEFAULT_SSL_CONTEXT}){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                if (!resolvedValue.isDefined() && currentValue.isDefined()) {
                    context.restartRequired();
                    return false;
                }
                return true;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            }
        });
    }

    public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"org.wildfly.security.elytron")});
    }

    @Deprecated
    static <T> ServiceBuilder<T> commonDependencies(ServiceBuilder<T> serviceBuilder) {
        return ElytronDefinition.commonDependencies(serviceBuilder, true, true);
    }

    @Deprecated
    static <T> ServiceBuilder<T> commonDependencies(ServiceBuilder<T> serviceBuilder, boolean dependOnProperties, boolean dependOnProviderRegistration) {
        if (dependOnProperties) {
            serviceBuilder.requires(SecurityPropertyService.SERVICE_NAME);
        }
        if (dependOnProviderRegistration) {
            serviceBuilder.requires(ProviderRegistrationService.SERVICE_NAME);
        }
        return serviceBuilder;
    }

    static <T> ServiceBuilder<T> commonRequirements(ServiceBuilder<T> serviceBuilder) {
        return ElytronDefinition.commonRequirements(serviceBuilder, true, true);
    }

    static <T> ServiceBuilder<T> commonRequirements(ServiceBuilder<T> serviceBuilder, boolean dependOnProperties, boolean dependOnProviderRegistration) {
        if (dependOnProperties) {
            serviceBuilder.requires(SecurityPropertyService.SERVICE_NAME);
        }
        if (dependOnProviderRegistration) {
            serviceBuilder.requires(ProviderRegistrationService.SERVICE_NAME);
        }
        return serviceBuilder;
    }

    private static void installService(ServiceName serviceName, Service<?> service, ServiceTarget serviceTarget) {
        serviceTarget.addService(serviceName, service).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static void registerAuthConfigFactory(AuthConfigFactory authConfigFactory) {
        SecurityActions.doPrivileged(() -> {
            AuthConfigFactory.setFactory((AuthConfigFactory)authConfigFactory);
            return null;
        });
    }

    private static AuthConfigFactory getAuthConfigFactory() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ElytronDefinition.class.getClassLoader());
            AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
            return authConfigFactory;
        }
        catch (Exception e) {
            ElytronSubsystemMessages.ROOT_LOGGER.trace("Unable to load default AuthConfigFactory.", e);
            AuthConfigFactory authConfigFactory = null;
            return authConfigFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static SecurityPropertyService uninstallSecurityPropertyService(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController service = serviceRegistry.getService(SecurityPropertyService.SERVICE_NAME);
        if (service != null) {
            Service serviceImplementation = service.getService();
            context.removeService(service);
            if (serviceImplementation != null && serviceImplementation instanceof SecurityPropertyService) {
                return (SecurityPropertyService)serviceImplementation;
            }
        }
        return null;
    }

    private static class ElytronRemove
    extends ElytronRemoveStepHandler {
        private ElytronRemove() {
            super(Capabilities.ELYTRON_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (context.isResourceServiceRestartAllowed()) {
                ElytronDefinition.registerAuthConfigFactory(null);
                SecurityPropertyService securityPropertyService = ElytronDefinition.uninstallSecurityPropertyService(context);
                if (securityPropertyService != null) {
                    context.attach(SECURITY_PROPERTY_SERVICE_KEY, (Object)securityPropertyService);
                }
                context.removeService(ProviderRegistrationService.SERVICE_NAME);
            } else {
                context.reloadRequired();
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget target = context.getServiceTarget();
            SecurityPropertyService securityPropertyService = (SecurityPropertyService)context.getAttachment(SECURITY_PROPERTY_SERVICE_KEY);
            if (securityPropertyService != null) {
                ElytronDefinition.installService(SecurityPropertyService.SERVICE_NAME, securityPropertyService, target);
            }
            List providers = DISALLOWED_PROVIDERS.unwrap((ExpressionResolver)context, model);
            ElytronDefinition.installService(ProviderRegistrationService.SERVICE_NAME, new ProviderRegistrationService(providers), target);
        }
    }

    private static class ElytronAdd
    extends AbstractBoottimeAddStepHandler
    implements ElytronOperationStepHandler {
        private ElytronAdd() {
            super(new AttributeDefinition[]{DEFAULT_AUTHENTICATION_CONTEXT, INITIAL_PROVIDERS, FINAL_PROVIDERS, DISALLOWED_PROVIDERS, SECURITY_PROPERTIES, REGISTER_JASPI_FACTORY, DEFAULT_SSL_CONTEXT});
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            Version.getVersion();
            super.populateModel(operation, model);
        }

        protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            Consumer valueConsumer;
            ServiceBuilder serviceBuilder;
            String finalProviders;
            ModelNode model = resource.getModel();
            String defaultAuthenticationContext = DEFAULT_AUTHENTICATION_CONTEXT.resolveModelAttribute(context, model).asStringOrNull();
            AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(defaultAuthenticationContext);
            Map securityProperties = SECURITY_PROPERTIES.unwrap((ExpressionResolver)context, model);
            final String defaultSSLContext = DEFAULT_SSL_CONTEXT.resolveModelAttribute(context, model).asStringOrNull();
            ServiceTarget target = context.getServiceTarget();
            ElytronDefinition.installService(SecurityPropertyService.SERVICE_NAME, new SecurityPropertyService(securityProperties), target);
            List providers = DISALLOWED_PROVIDERS.unwrap((ExpressionResolver)context, operation);
            ProviderRegistrationService prs = new ProviderRegistrationService(providers);
            ServiceBuilder builder = target.addService(ProviderRegistrationService.SERVICE_NAME, (Service)prs).setInitialMode(ServiceController.Mode.ACTIVE);
            String initialProviders = INITIAL_PROVIDERS.resolveModelAttribute(context, model).asStringOrNull();
            if (initialProviders != null) {
                builder.addDependency(context.getCapabilityServiceName("org.wildfly.security.providers", initialProviders, Provider[].class), Provider[].class, prs.getInitialProivders());
            }
            if ((finalProviders = FINAL_PROVIDERS.resolveModelAttribute(context, model).asStringOrNull()) != null) {
                builder.addDependency(context.getCapabilityServiceName("org.wildfly.security.providers", finalProviders, Provider[].class), Provider[].class, prs.getFinalProviders());
            }
            builder.install();
            if (defaultAuthenticationContext != null) {
                serviceBuilder = target.addService(DefaultAuthenticationContextService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE);
                Supplier defaultAuthenticationContextSupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", defaultAuthenticationContext, AuthenticationContext.class));
                valueConsumer = serviceBuilder.provides(new ServiceName[]{DefaultAuthenticationContextService.SERVICE_NAME});
                DefaultAuthenticationContextService defaultAuthenticationContextService = new DefaultAuthenticationContextService(defaultAuthenticationContextSupplier, valueConsumer);
                serviceBuilder.setInstance((org.jboss.msc.Service)defaultAuthenticationContextService).install();
            }
            if (defaultSSLContext != null) {
                serviceBuilder = target.addService(DefaultSSLContextService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE);
                Supplier defaultSSLContextSupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.ssl-context", defaultSSLContext, SSLContext.class));
                valueConsumer = serviceBuilder.provides(new ServiceName[]{DefaultSSLContextService.SERVICE_NAME});
                DefaultSSLContextService defaultSSLContextService = new DefaultSSLContextService(defaultSSLContextSupplier, valueConsumer);
                serviceBuilder.setInstance((org.jboss.msc.Service)defaultSSLContextService).install();
            }
            if (this.registerJaspiFactory(context, model)) {
                ElytronDefinition.registerAuthConfigFactory((AuthConfigFactory)new ElytronAuthConfigFactory());
            }
            if (context.isNormalServer()) {
                context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                    protected void execute(DeploymentProcessorTarget processorTarget) {
                        processorTarget.addDeploymentProcessor("elytron", Phase.STRUCTURE, 1152, (DeploymentUnitProcessor)new DeploymentExpressionResolverProcessor());
                        processorTarget.addDeploymentProcessor("elytron", Phase.STRUCTURE, 8960, (DeploymentUnitProcessor)new SecurityMetaDataProcessor());
                        processorTarget.addDeploymentProcessor("elytron", Phase.PARSE, 19479, (DeploymentUnitProcessor)new VirtualSecurityDomainNameProcessor());
                        processorTarget.addDeploymentProcessor("elytron", Phase.DEPENDENCIES, 3153, (DeploymentUnitProcessor)new DependencyProcessor());
                        processorTarget.addDeploymentProcessor("elytron", Phase.DEPENDENCIES, 3154, (DeploymentUnitProcessor)new EESecurityDependencyProcessor());
                        processorTarget.addDeploymentProcessor("elytron", Phase.CONFIGURE_MODULE, 1280, (DeploymentUnitProcessor)AUTHENITCATION_CONTEXT_PROCESSOR);
                        if (defaultSSLContext != null) {
                            processorTarget.addDeploymentProcessor("elytron", Phase.CONFIGURE_MODULE, 1408, (DeploymentUnitProcessor)new SSLContextDependencyProcessor());
                        }
                        processorTarget.addDeploymentProcessor("elytron", Phase.FIRST_MODULE_USE, 1536, (DeploymentUnitProcessor)new AuthenticationContextAssociationProcessor());
                        processorTarget.addDeploymentProcessor("elytron", Phase.INSTALL, 864, (DeploymentUnitProcessor)new VirtualSecurityDomainProcessor());
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        private boolean registerJaspiFactory(OperationContext context, ModelNode model) throws OperationFailedException {
            String jaspiFactory = (String)SecurityActions.doPrivileged(new ReadPropertyAction("authconfigprovider.factory"));
            return jaspiFactory == null && REGISTER_JASPI_FACTORY.resolveModelAttribute(context, model).asBoolean();
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            ElytronDefinition.uninstallSecurityPropertyService(context);
            context.removeService(ProviderRegistrationService.SERVICE_NAME);
            AUTHENITCATION_CONTEXT_PROCESSOR.setDefaultAuthenticationContext(null);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return this.isServerOrHostController(context);
        }
    }
}

