/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.DerivedDependencyWalkingInfo;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.data.impl.LinkedNode;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractPojoIndexingDependencyCollectorDirectValueNode<P, V>
extends AbstractPojoIndexingDependencyCollectorValueNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode;
    final BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode;
    final Metadata metadata;
    private final Map<PojoRawTypeModel<?>, Map<PojoRawTypeModel<?>, PojoModelPathValueNode>> inverseAssociationPathCache = new HashMap();

    AbstractPojoIndexingDependencyCollectorDirectValueNode(PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode, Metadata metadata, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = parentNode;
        this.modelPathFromLastEntityNode = modelPathFromLastEntityNode;
        this.metadata = metadata;
    }

    public PojoIndexingDependencyCollectorTypeNode<V> type() {
        return new PojoIndexingDependencyCollectorTypeNode<V>(this, this.modelPathFromLastEntityNode.type(), this.buildingHelper);
    }

    public <U> PojoIndexingDependencyCollectorTypeNode<? extends U> castedType(PojoRawTypeModel<U> typeModel) {
        return new PojoIndexingDependencyCollectorTypeNode(this, this.modelPathFromLastEntityNode.type().castTo(typeModel), this.buildingHelper);
    }

    public abstract void collectDependency();

    abstract void doCollectDependency(LinkedNode<DerivedDependencyWalkingInfo> var1);

    @Override
    final PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode() {
        return this.parentNode.lastEntityNode();
    }

    @Override
    final ReindexOnUpdate reindexOnUpdate() {
        return this.metadata.reindexOnUpdate;
    }

    @Override
    abstract void collectDependency(BoundPojoModelPathValueNode<?, ?, ?> var1);

    @Override
    void markForReindexing(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseSideEntityTypeNodeBuilder, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        PojoTypeModel<V> expectedInverseSideEntityType;
        PojoRawTypeModel<V> expectedInverseSideEntityRawType;
        PojoTypeModel<?> inverseSideEntityType = inverseSideEntityTypeNodeBuilder.getTypeModel();
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.rawType();
        if (!inverseSideRawEntityType.isSubTypeOf(expectedInverseSideEntityRawType = (expectedInverseSideEntityType = this.modelPathFromLastEntityNode.type().getTypeModel()).rawType())) {
            throw new AssertionFailure("Error while building the automatic reindexing resolver at path " + this.modelPathFromLastEntityNode + ": the dependency collector was passed a resolver builder with incorrect type;  got " + inverseSideRawEntityType + ", but a subtype of " + expectedInverseSideEntityRawType + " was expected.");
        }
        Map<PojoRawTypeModel<?>, PojoModelPathValueNode> inverseAssociationsPaths = this.getInverseAssociationPathByConcreteEntityType(inverseSideEntityTypeNodeBuilder.getTypeModel());
        for (Map.Entry<PojoRawTypeModel<?>, PojoModelPathValueNode> entry : inverseAssociationsPaths.entrySet()) {
            this.markForReindexingUsingAssociationInverseSideWithOriginalSideConcreteType((PojoTypeModel)entry.getKey(), inverseSideEntityTypeNodeBuilder, entry.getValue(), dependencyPathFromInverseSideEntityTypeNode);
        }
    }

    private Map<PojoRawTypeModel<?>, PojoModelPathValueNode> getInverseAssociationPathByConcreteEntityType(PojoTypeModel<?> inverseSideEntityType) {
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.rawType();
        Map<PojoRawTypeModel<Object>, PojoModelPathValueNode> result = this.inverseAssociationPathCache.get(inverseSideRawEntityType);
        if (result == null) {
            if (!this.inverseAssociationPathCache.containsKey(inverseSideRawEntityType)) {
                PojoTypeModel<?> originalSideEntityType = this.lastEntityNode().typeModel();
                PojoRawTypeModel<?> originalSideRawEntityType = originalSideEntityType.rawType();
                result = new LinkedHashMap();
                for (PojoRawTypeModel<?> concreteEntityType : this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(originalSideRawEntityType)) {
                    BoundPojoModelPathValueNode<?, ?, ?> modelPathFromConcreteEntitySubType = this.applyProcessingPathToSubType(concreteEntityType, this.modelPathFromLastEntityNode);
                    PojoModelPathValueNode inverseAssociationPath = this.buildingHelper.pathInverter().invertPath(inverseSideEntityType, modelPathFromConcreteEntitySubType).orElse(null);
                    if (inverseAssociationPath == null) {
                        throw log.cannotInvertAssociationForReindexing(inverseSideRawEntityType, concreteEntityType, this.modelPathFromLastEntityNode.toUnboundPath());
                    }
                    result.put(concreteEntityType, inverseAssociationPath);
                }
                this.inverseAssociationPathCache.put(inverseSideRawEntityType, result);
            } else {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    private void markForReindexingUsingAssociationInverseSideWithOriginalSideConcreteType(PojoTypeModel<?> originalSideConcreteEntityType, AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> typeNodeBuilder, PojoModelPathValueNode inverseAssociationPath, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        Set<PojoRawTypeModel<?>> valueNodeTypeConcreteEntitySubTypes;
        PojoImplicitReindexingResolverValueNodeBuilderDelegate valueNodeBuilderDelegate;
        PojoTypeModel<?> inverseSideEntityType = typeNodeBuilder.getTypeModel();
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.rawType();
        PojoRawTypeModel<?> originalSideRawConcreteEntityType = originalSideConcreteEntityType.rawType();
        try {
            valueNodeBuilderDelegate = (PojoImplicitReindexingResolverValueNodeBuilderDelegate)PojoModelPathBinder.bind(typeNodeBuilder, inverseAssociationPath, PojoImplicitReindexingResolverBuilder.walker());
            PojoRawTypeModel inverseSideRawType = valueNodeBuilderDelegate.getTypeModel().rawType();
            valueNodeTypeConcreteEntitySubTypes = this.lastEntityNode().getConcreteEntitySubTypesForTypeToReindex(originalSideRawConcreteEntityType, inverseSideRawType);
        }
        catch (RuntimeException e) {
            throw log.cannotApplyImplicitInverseAssociationPath(inverseSideRawEntityType, inverseAssociationPath, originalSideRawConcreteEntityType, this.modelPathFromLastEntityNode.toUnboundPath(), e.getMessage(), e);
        }
        this.lastEntityNode().markForReindexing(valueNodeBuilderDelegate, valueNodeTypeConcreteEntitySubTypes, dependencyPathFromInverseSideEntityTypeNode);
    }

    private BoundPojoModelPathValueNode<?, ?, ?> applyProcessingPathToSubType(PojoRawTypeModel<?> rootSubType, BoundPojoModelPathValueNode<?, ?, ?> source) {
        return (BoundPojoModelPathValueNode)PojoModelPathBinder.bind(BoundPojoModelPath.root(rootSubType), source.toUnboundPath(), BoundPojoModelPath.walker(this.buildingHelper.extractorBinder()));
    }

    protected static final class Metadata {
        final ReindexOnUpdate reindexOnUpdate;
        final Set<PojoModelPathValueNode> derivedFrom;

        static Metadata create(PojoImplicitReindexingResolverBuildingHelper buildingHelper, PojoIndexingDependencyCollectorPropertyNode<?, ?> parentNode, ContainerExtractorPath containerExtractorPath) {
            PojoTypeModel<?> holderType = parentNode.parentNode().typeModel();
            String propertyName = parentNode.modelPathFromParentNode().getPropertyModel().name();
            ReindexOnUpdate metadataReindexOnUpdateOrNull = buildingHelper.getMetadataReindexOnUpdateOrNull(holderType, propertyName, containerExtractorPath);
            PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode = parentNode.lastEntityNode();
            ReindexOnUpdate reindexOnUpdate = parentNode.composeReindexOnUpdate(lastEntityNode, metadataReindexOnUpdateOrNull);
            Set<PojoModelPathValueNode> derivedFrom = buildingHelper.getMetadataDerivedFrom(holderType, propertyName, containerExtractorPath);
            return new Metadata(reindexOnUpdate, derivedFrom);
        }

        private Metadata(ReindexOnUpdate reindexOnUpdate, Set<PojoModelPathValueNode> derivedFrom) {
            this.derivedFrom = derivedFrom;
            this.reindexOnUpdate = reindexOnUpdate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metadata metadata = (Metadata)o;
            return this.reindexOnUpdate == metadata.reindexOnUpdate && Objects.equals(this.derivedFrom, metadata.derivedFrom);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.reindexOnUpdate, this.derivedFrom});
        }
    }
}

