/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;
import org.jgroups.Message;
import org.jgroups.protocols.ProtPerfHeader;
import org.jgroups.protocols.TP;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class ProtPerfHelper
extends Helper {
    protected static final ProtPerfProbeHandler ph = new ProtPerfProbeHandler();
    protected static final String DEFAULT = "default";

    protected ProtPerfHelper(Rule rule) {
        super(rule);
    }

    public void diagCreated(DiagnosticsHandler diag, TP transport) {
        boolean already_present;
        if (diag != null && diag.isEnabled() && !(already_present = diag.getProbeHandlers().contains(ph))) {
            diag.registerProbeHandler(ph);
            ph.addOrdering(transport);
        }
    }

    public void downTime(Message msg, Protocol prot) {
        long time;
        ProtPerfHeader hdr = ProtPerfHelper.getOrAddHeader(msg);
        if (prot != null && hdr.startDown() > 0L && (time = System.nanoTime() - hdr.startDown()) > 0L) {
            ph.add(ProtPerfHelper.getClusterName(prot), prot.getClass(), time, true);
        }
        hdr.startDown(System.nanoTime());
    }

    public void upTime(Message msg, Protocol prot) {
        long time;
        ProtPerfHeader hdr = ProtPerfHelper.getOrAddHeader(msg);
        if (prot != null && hdr.startUp() > 0L && (time = System.nanoTime() - hdr.startUp()) > 0L) {
            ph.add(ProtPerfHelper.getClusterName(prot), prot.getClass(), time, false);
        }
        hdr.startUp(System.nanoTime());
    }

    public void upTime(MessageBatch batch, Protocol prot) {
        long time;
        if (prot != null && batch.timestamp() > 0L && (time = System.nanoTime() - batch.timestamp()) > 0L) {
            ph.add(ProtPerfHelper.getClusterName(prot), prot.getClass(), time, false);
        }
        batch.timestamp(System.nanoTime());
    }

    public void setTime(Message msg, boolean down2) {
        ProtPerfHeader hdr = ProtPerfHelper.getOrAddHeader(msg);
        long time = System.nanoTime();
        if (down2) {
            hdr.startDown(time);
        } else {
            hdr.startUp(time);
        }
    }

    public void setTime(Message msg, long time, boolean down2) {
        ProtPerfHeader hdr = ProtPerfHelper.getOrAddHeader(msg);
        if (down2) {
            hdr.startDown(time);
        } else {
            hdr.startUp(time);
        }
    }

    public void setTime(MessageBatch batch) {
        batch.timestamp(System.nanoTime());
    }

    protected static String getClusterName(Protocol p) {
        return p == null ? null : p.getTransport().getClusterName();
    }

    protected static ProtPerfHeader getOrAddHeader(Message msg) {
        ProtPerfHeader hdr = (ProtPerfHeader)msg.getHeader((short)1505);
        if (hdr != null) {
            return hdr;
        }
        hdr = new ProtPerfHeader();
        msg.putHeader((short)1505, hdr);
        return hdr;
    }

    protected static class Entry {
        protected final AverageMinMax avg_down = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);
        protected final AverageMinMax avg_up = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);

        protected Entry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(long value, boolean down2) {
            if (down2) {
                AverageMinMax averageMinMax = this.avg_down;
                synchronized (averageMinMax) {
                    this.avg_down.add(value);
                }
            }
            AverageMinMax averageMinMax = this.avg_up;
            synchronized (averageMinMax) {
                this.avg_up.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clear() {
            AverageMinMax averageMinMax = this.avg_down;
            synchronized (averageMinMax) {
                this.avg_down.clear();
            }
            averageMinMax = this.avg_up;
            synchronized (averageMinMax) {
                this.avg_up.clear();
            }
        }

        public String toString() {
            return String.format("down: %s up: %s", this.avg_down, this.avg_up);
        }

        public String toString(boolean down2, boolean up2, boolean detailed) {
            return String.format("%s %s", down2 ? Entry.print(this.avg_down, detailed) : "", up2 ? Entry.print(this.avg_up, detailed) : "");
        }

        public static String print(AverageMinMax avg, boolean detailed) {
            return detailed ? avg.toString() : String.format("%,.2f %s (%s)", avg.getAverage() / 1000.0, "us", String.format("%,d", avg.count()));
        }
    }

    protected static class ProtPerfProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        protected final Map<String, List<Class<? extends Protocol>>> ordering = Util.createConcurrentMap(20);
        protected final Map<String, Map<Class<? extends Protocol>, Entry>> map = Util.createConcurrentMap(4);

        public void addOrdering(TP transport) {
            List<Protocol> protocols = transport.getProtocolStack().getProtocols();
            List classes = protocols.stream().map(Object::getClass).collect(Collectors.toList());
            this.ordering.putIfAbsent(transport.getClusterName(), classes);
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> m = null;
            for (String key : keys) {
                String value = null;
                String cluster = ProtPerfProbeHandler.clusterSuffix(key);
                if (key.startsWith("perf-keys")) {
                    value = this.map.keySet().toString();
                } else if (key.startsWith("perf-down-detailed")) {
                    value = this.dumpStats(cluster, true, false, true);
                } else if (key.startsWith("perf-down")) {
                    value = this.dumpStats(cluster, true, false, false);
                } else if (key.startsWith("perf-up-detailed")) {
                    value = this.dumpStats(cluster, false, true, true);
                } else if (key.startsWith("perf-up")) {
                    value = this.dumpStats(cluster, false, true, false);
                } else if (key.startsWith("perf-reset")) {
                    this.clearStats();
                } else if (key.startsWith("perf")) {
                    value = this.dumpStats(cluster, true, true, true);
                }
                if (value == null) continue;
                if (m == null) {
                    m = new HashMap<String, String>();
                }
                m.put(key, value);
            }
            return m;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"perf", "perf-down", "perf-up", "perf-down-detailed", "perf-up-detailed", "perf-reset"};
        }

        protected static String clusterSuffix(String key) {
            int index = key.indexOf(61);
            if (index < 0) {
                return null;
            }
            return key.substring(index + 1);
        }

        protected void add(String cluster, Class<? extends Protocol> clazz, long value, boolean down2) {
            if (cluster == null) {
                cluster = ProtPerfHelper.DEFAULT;
            }
            Map m = this.map.computeIfAbsent(cluster, k -> Util.createConcurrentMap(20));
            Entry e = m.computeIfAbsent(clazz, cl -> new Entry());
            e.add(value, down2);
        }

        protected String dumpStats(String cluster, boolean down2, boolean up2, boolean detailed) {
            if (cluster == null) {
                return this.dumpAllStacks(down2, up2, detailed);
            }
            Map<Class<? extends Protocol>, Entry> m = this.map.get(cluster);
            return m != null ? this.dumpStats(cluster, m, down2, up2, detailed) : String.format("cluster '%s' not found", cluster);
        }

        protected String dumpAllStacks(boolean down2, boolean up2, boolean detailed) {
            return this.map.entrySet().stream().map(e -> String.format("%s:\n%s\n", e.getKey(), this.dumpStats((String)e.getKey(), (Map)e.getValue(), down2, up2, detailed))).collect(Collectors.joining("\n"));
        }

        protected String dumpStats(String cluster, Map<Class<? extends Protocol>, Entry> m, boolean down2, boolean up2, boolean detailed) {
            double avg_down_sum = 0.0;
            double avg_up_sum = 0.0;
            List<Class<? extends Protocol>> order = this.ordering.get(cluster);
            if (order != null) {
                StringBuilder sb = new StringBuilder("\n");
                for (Class<? extends Protocol> cl : order) {
                    Entry e2 = m.get(cl);
                    if (e2 != null) {
                        if (down2) {
                            avg_down_sum += e2.avg_down.getAverage();
                        } else {
                            avg_up_sum += e2.avg_up.getAverage();
                        }
                    }
                    sb.append(String.format("%-20s %s\n", cl.getSimpleName() + ":", e2 == null ? "n/a" : e2.toString(down2, up2, detailed)));
                }
                sb.append("-".repeat(30));
                sb.append(String.format("\n%-20s %s\n", "TOTAL:", down2 ? Util.printTime(avg_down_sum, TimeUnit.NANOSECONDS) : Util.printTime(avg_up_sum, TimeUnit.NANOSECONDS)));
                return sb.toString();
            }
            return m.entrySet().stream().map(e -> String.format("%-20s %s", ((Class)e.getKey()).getSimpleName() + ":", ((Entry)e.getValue()).toString(down2, up2, detailed))).collect(Collectors.joining("\n"));
        }

        protected void clearStats() {
            this.map.values().forEach(v -> v.values().forEach(Entry::clear));
        }
    }
}

