/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.time.Instant;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.ejb.infinispan.timer.ImmutableScheduleExpressionBuilder;
import org.wildfly.clustering.ejb.infinispan.timer.ImmutableScheduleExpressionMarshaller;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleTimerCreationMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleTimerCreationMetaDataEntry;
import org.wildfly.clustering.ejb.infinispan.timer.TimeoutDescriptor;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class ScheduleTimerCreationMetaDataMarshaller
implements ProtoStreamMarshaller<ScheduleTimerCreationMetaData<Object>> {
    private static final int INFO_INDEX = 1;
    private static final int START_INDEX = 2;
    private static final int SCHEDULE_EXPRESSION_INDEX = 3;
    private static final int NO_PARAMETERS_METHOD_NAME_INDEX = 3 + ImmutableScheduleExpressionMarshaller.INSTANCE.getFields();
    private static final int TIMER_PARAMETERS_METHOD_NAME_INDEX = NO_PARAMETERS_METHOD_NAME_INDEX + 1;

    public Class<? extends ScheduleTimerCreationMetaData<Object>> getJavaClass() {
        return ScheduleTimerCreationMetaDataEntry.class;
    }

    public ScheduleTimerCreationMetaData<Object> readFrom(ProtoStreamReader reader) throws IOException {
        Instant creation = Instant.EPOCH;
        MarshalledValue context = null;
        ImmutableScheduleExpressionBuilder expressionBuilder = ImmutableScheduleExpressionMarshaller.INSTANCE.getBuilder();
        TimeoutDescriptor descriptor = null;
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == 2) {
                creation = (Instant)reader.readObject(Instant.class);
                continue;
            }
            if (index == 1) {
                context = (MarshalledValue)reader.readObject(ByteBufferMarshalledValue.class);
                continue;
            }
            if (index >= 3 && index < NO_PARAMETERS_METHOD_NAME_INDEX) {
                expressionBuilder = ImmutableScheduleExpressionMarshaller.INSTANCE.readField(reader, index - 3, expressionBuilder);
                continue;
            }
            if (index == NO_PARAMETERS_METHOD_NAME_INDEX) {
                descriptor = new TimeoutDescriptor(reader.readString(), 0);
                continue;
            }
            if (index == TIMER_PARAMETERS_METHOD_NAME_INDEX) {
                descriptor = new TimeoutDescriptor(reader.readString(), 1);
                continue;
            }
            reader.skipField(tag);
        }
        return new ScheduleTimerCreationMetaDataEntry<Object>(context, creation, expressionBuilder.build(), descriptor);
    }

    public void writeTo(ProtoStreamWriter writer, ScheduleTimerCreationMetaData<Object> metaData) throws IOException {
        Instant start;
        Object context = metaData.getContext();
        if (context != null) {
            writer.writeObject(1, context);
        }
        if (!(start = metaData.getStart()).equals(Instant.EPOCH)) {
            writer.writeObject(2, (Object)start);
        }
        ImmutableScheduleExpressionMarshaller.INSTANCE.writeFields(writer, 3, metaData.getScheduleExpression());
        TimeoutDescriptor descriptor = metaData.getTimeoutMatcher();
        if (descriptor != null) {
            writer.writeString(descriptor.getParameters() > 0 ? TIMER_PARAMETERS_METHOD_NAME_INDEX : NO_PARAMETERS_METHOD_NAME_INDEX, descriptor.getMethodName());
        }
    }
}

