/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.AggregateColumnWriteExpression;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseASESqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public SybaseASESqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected boolean supportsWithClause() {
        return false;
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    @Override
    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        super.renderNamedTableReference(tableReference, lockMode);
        return false;
    }

    @Override
    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        if (tableGroupJoin.getJoinType() == SqlAstJoinType.CROSS) {
            this.appendSql(", ");
        } else {
            this.appendSql(' ');
            this.appendSql(tableGroupJoin.getJoinType().getText());
            this.appendSql("join ");
        }
        Object predicate = tableGroupJoin.getPredicate() == null ? (tableGroupJoin.getJoinType() == SqlAstJoinType.CROSS ? null : new BooleanExpressionPredicate(new QueryLiteral<Boolean>(true, this.getBooleanType()))) : tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), (Predicate)predicate, tableGroupJoinCollector);
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true, false);
        super.visitSqlSelections(selectClause);
    }

    @Override
    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsLiteral(fetchClauseExpression, offsetClauseExpression, offset);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (queryGroup.hasSortSpecifications() || queryGroup.hasOffsetOrFetchClause()) {
            this.appendSql("select ");
            this.renderTopClause(queryGroup.getOffsetClauseExpression(), queryGroup.getFetchClauseExpression(), queryGroup.getFetchClauseType(), true, false);
            this.appendSql("* from (");
            this.renderQueryGroup(queryGroup, false);
            this.appendSql(") grp_(c0");
            int itemCount = queryGroup.getFirstQuerySpec().getSelectClause().getSqlSelections().size();
            for (int i = 1; i < itemCount; ++i) {
                this.appendSql(",c");
                this.appendSql(i);
            }
            this.appendSql(')');
            this.visitOrderBy(queryGroup.getSortSpecifications());
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (!queryPart.isRoot() && queryPart.hasOffsetOrFetchClause() && queryPart.getFetchClauseExpression() != null && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset fetch clause in subquery");
        }
    }

    @Override
    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        if (this.getDialect().isAnsiNullOn()) {
            if (this.supportsDistinctFromPredicate()) {
                this.renderComparisonEmulateIntersect(lhs, operator, rhs);
            } else {
                this.renderComparisonEmulateCase(lhs, operator, rhs);
            }
        } else {
            boolean lhsNotNullPredicate;
            boolean rhsNotNullPredicate = lhs instanceof Literal || this.isParameter(lhs);
            boolean bl = lhsNotNullPredicate = rhs instanceof Literal || this.isParameter(rhs);
            if (rhsNotNullPredicate || lhsNotNullPredicate) {
                lhs.accept(this);
                switch (operator) {
                    case DISTINCT_FROM: {
                        this.appendSql("<>");
                        break;
                    }
                    case NOT_DISTINCT_FROM: {
                        this.appendSql('=');
                        break;
                    }
                    case LESS_THAN: 
                    case GREATER_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case GREATER_THAN_OR_EQUAL: {
                        lhsNotNullPredicate = false;
                        rhsNotNullPredicate = false;
                    }
                    default: {
                        this.appendSql(operator.sqlText());
                    }
                }
                rhs.accept(this);
                if (lhsNotNullPredicate) {
                    this.appendSql(" and ");
                    lhs.accept(this);
                    this.appendSql(" is not null");
                }
                if (rhsNotNullPredicate) {
                    this.appendSql(" and ");
                    rhs.accept(this);
                    this.appendSql(" is not null");
                }
            } else if (this.supportsDistinctFromPredicate()) {
                this.renderComparisonEmulateIntersect(lhs, operator, rhs);
            } else {
                this.renderComparisonEmulateCase(lhs, operator, rhs);
            }
        }
    }

    @Override
    protected boolean supportsIntersect() {
        return false;
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        arithmeticExpression.getLeftHandOperand().accept(this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept(this);
        this.appendSql(')');
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        String dmlTargetTableAlias = this.getDmlTargetTableAlias();
        if (dmlTargetTableAlias != null && dmlTargetTableAlias.equals(columnReference.getQualifier())) {
            List<TableGroup> roots;
            QuerySpec currentQuerySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
            if (currentQuerySpec != null && !currentQuerySpec.isRoot() && (roots = currentQuerySpec.getFromClause().getRoots()).size() == 1 && roots.get(0).getPrimaryTableReference() instanceof UnionTableReference) {
                columnReference.appendReadExpression(this);
            } else if (columnReference.isColumnExpressionFormula()) {
                this.appendSql(columnReference.getColumnExpression().replaceAll("(\\b)(" + dmlTargetTableAlias + "\\.)(\\b)", "$1$3"));
            } else {
                columnReference.appendReadExpression(this, this.getCurrentDmlStatement().getTargetTable().getTableExpression());
            }
        } else {
            columnReference.appendReadExpression(this);
        }
    }

    @Override
    public void visitAggregateColumnWriteExpression(AggregateColumnWriteExpression aggregateColumnWriteExpression) {
        String dmlTargetTableAlias = this.getDmlTargetTableAlias();
        ColumnReference columnReference = aggregateColumnWriteExpression.getColumnReference();
        if (dmlTargetTableAlias != null && dmlTargetTableAlias.equals(columnReference.getQualifier())) {
            List<TableGroup> roots;
            QuerySpec currentQuerySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
            if (currentQuerySpec != null && !currentQuerySpec.isRoot() && (roots = currentQuerySpec.getFromClause().getRoots()).size() == 1 && roots.get(0).getPrimaryTableReference() instanceof UnionTableReference) {
                aggregateColumnWriteExpression.appendWriteExpression(this, this);
            } else {
                aggregateColumnWriteExpression.appendWriteExpression(this, this, this.getCurrentDmlStatement().getTargetTable().getTableExpression());
            }
        } else {
            aggregateColumnWriteExpression.appendWriteExpression(this, this);
        }
    }

    @Override
    protected boolean needsRowsToSkip() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from (select 1) dual(c1)";
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return false;
    }
}

