/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.mapping.Any;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.StandardVirtualTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.AnyType;
import org.hibernate.type.descriptor.java.JavaType;

public class DiscriminatedCollectionPart
implements DiscriminatedAssociationModelPart,
CollectionPart {
    private final CollectionPart.Nature nature;
    private final NavigableRole partRole;
    private final CollectionPersister collectionDescriptor;
    private final DiscriminatedAssociationMapping associationMapping;

    public DiscriminatedCollectionPart(CollectionPart.Nature nature, CollectionPersister collectionDescriptor, JavaType<Object> baseAssociationJtd, Any bootValueMapping, AnyType anyType, MappingModelCreationProcess creationProcess) {
        this.nature = nature;
        this.partRole = collectionDescriptor.getNavigableRole().append(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.associationMapping = DiscriminatedAssociationMapping.from(this.partRole, baseAssociationJtd, this, anyType, bootValueMapping, creationProcess);
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public DiscriminatorMapping getDiscriminatorMapping() {
        return this.associationMapping.getDiscriminatorPart();
    }

    @Override
    public void applyDiscriminator(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.associationMapping.getKeyPart();
    }

    @Override
    public EntityMappingType resolveDiscriminatorValue(Object discriminatorValue) {
        return this.associationMapping.resolveDiscriminatorValueToEntityMapping(discriminatorValue);
    }

    @Override
    public Object resolveDiscriminatorForEntityType(EntityMappingType entityMappingType) {
        return this.associationMapping.resolveDiscriminatorValueToEntityMapping(entityMappingType);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        this.associationMapping.getDiscriminatorPart().forEachSelectable(offset, consumer);
        this.associationMapping.getKeyPart().forEachSelectable(offset + 1, consumer);
        return 2;
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public int getFetchableKey() {
        return this.nature == CollectionPart.Nature.INDEX || !this.collectionDescriptor.hasIndex() ? 0 : 1;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this.associationMapping;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.associationMapping.getDiscriminatorPart().isPartitioned() || this.associationMapping.getKeyPart().isPartitioned();
    }

    public String toString() {
        return "DiscriminatedCollectionPart(" + this.getNavigableRole() + ")@" + System.identityHashCode(this);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return this.associationMapping.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.associationMapping.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.associationMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.associationMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public MappingType getPartMappingType() {
        return this.associationMapping;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.associationMapping.getJavaType();
    }

    @Override
    public MappingType getMappedType() {
        return this.getPartMappingType();
    }

    @Override
    public JavaType<?> getExpressibleJavaType() {
        return this.getJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.partRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.associationMapping.findSubPart(name, treatTargetType);
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        consumer.accept(0, this.getDiscriminatorPart());
        consumer.accept(1, this.getKeyPart());
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.getDiscriminatorPart());
        consumer.accept(this.getKeyPart());
    }

    @Override
    public int getNumberOfFetchables() {
        return 2;
    }

    @Override
    public Fetchable getFetchable(int position) {
        switch (position) {
            case 0: {
                return this.getDiscriminatorPart();
            }
            case 1: {
                return this.getKeyPart();
            }
        }
        throw new IndexOutOfBoundsException(position);
    }

    @Override
    public String getContainingTableExpression() {
        return this.getDiscriminatorPart().getContainingTableExpression();
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.getDiscriminatorPart().getSelectable(columnIndex);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.associationMapping.getDiscriminatorPart().disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.associationMapping.getDiscriminatorPart().addToCacheKey(cacheKey, value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.associationMapping.getDiscriminatorPart().forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.associationMapping.breakDownJdbcValues(offset, x, y, domainValue, valueConsumer, session);
    }

    @Override
    public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.associationMapping.decompose(offset, x, y, domainValue, valueConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = this.getDiscriminatorPart().forEachJdbcType(offset, action);
        return span + this.getKeyPart().forEachJdbcType(offset + span, action);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAstCreationState creationState) {
        SqlAstJoinType joinType = requestedJoinType == null ? SqlAstJoinType.INNER : requestedJoinType;
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, explicitSqlAliasBase, requestedJoinType, fetched, null, creationState);
        return new TableGroupJoin(navigablePath, joinType, tableGroup);
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstJoinType sqlAstJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAstCreationState creationState) {
        return new StandardVirtualTableGroup(navigablePath, this, lhs, fetched);
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.LEFT;
    }

    @Override
    public String getSqlAliasStem() {
        return this.collectionDescriptor.getAttributeMapping().getSqlAliasStem();
    }
}

