/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.PropertyEditorSupport;

public class ClassEditor
extends PropertyEditorSupport<Class> {
    public ClassEditor() {
        super(Class.class);
    }

    @Override
    public void setAsText(String text) {
        if (BeanUtils.isNull(text)) {
            this.setValue(null);
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> type = loader.loadClass(text);
                this.setValue(type);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Failed to parse to Class!", e);
            }
        }
    }

    @Override
    public String getAsText() {
        Class c = (Class)this.getValue();
        if (c == null) {
            return null;
        }
        return c.getName();
    }
}

