/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.marshall.core.Ids;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;

public class CacheStatusResponse
implements Serializable {
    private final CacheJoinInfo cacheJoinInfo;
    private final CacheTopology cacheTopology;
    private final CacheTopology stableTopology;
    private final AvailabilityMode availabilityMode;
    private final List<Address> current;

    public CacheStatusResponse(CacheJoinInfo cacheJoinInfo, CacheTopology cacheTopology, CacheTopology stableTopology, AvailabilityMode availabilityMode, List<Address> current) {
        this.cacheJoinInfo = cacheJoinInfo;
        this.cacheTopology = cacheTopology;
        this.stableTopology = stableTopology;
        this.availabilityMode = availabilityMode;
        this.current = current;
    }

    public CacheJoinInfo getCacheJoinInfo() {
        return this.cacheJoinInfo;
    }

    public CacheTopology getCacheTopology() {
        return this.cacheTopology;
    }

    public CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    public List<Address> joinedMembers() {
        return this.current;
    }

    public String toString() {
        return "StatusResponse{cacheJoinInfo=" + this.cacheJoinInfo + ", cacheTopology=" + this.cacheTopology + ", stableTopology=" + this.stableTopology + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<CacheStatusResponse> {
        public void writeObject(ObjectOutput output, CacheStatusResponse cacheStatusResponse) throws IOException {
            output.writeObject(cacheStatusResponse.cacheJoinInfo);
            output.writeObject(cacheStatusResponse.cacheTopology);
            output.writeObject(cacheStatusResponse.stableTopology);
            output.writeObject((Object)cacheStatusResponse.availabilityMode);
            MarshallUtil.marshallCollection(cacheStatusResponse.current, (ObjectOutput)output);
        }

        public CacheStatusResponse readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            CacheJoinInfo cacheJoinInfo = (CacheJoinInfo)unmarshaller.readObject();
            CacheTopology cacheTopology = (CacheTopology)unmarshaller.readObject();
            CacheTopology stableTopology = (CacheTopology)unmarshaller.readObject();
            AvailabilityMode availabilityMode = (AvailabilityMode)((Object)unmarshaller.readObject());
            List current = (List)MarshallUtil.unmarshallCollection((ObjectInput)unmarshaller, ArrayList::new);
            return new CacheStatusResponse(cacheJoinInfo, cacheTopology, stableTopology, availabilityMode, current);
        }

        public Integer getId() {
            return Ids.CACHE_STATUS_RESPONSE;
        }

        public Set<Class<? extends CacheStatusResponse>> getTypeClasses() {
            return Collections.singleton(CacheStatusResponse.class);
        }
    }
}

