/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.ui;

import com.sun.faces.facelets.util.DevTools;
import com.sun.faces.facelets.util.FastWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class UIDebug
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "facelets.ui.Debug";
    public static final String COMPONENT_FAMILY = "facelets";
    private static long nextId = System.currentTimeMillis();
    private static final String KEY = "facelets.ui.DebugOutput";
    public static final String DEFAULT_HOTKEY = "D";
    private String hotkey = "D";

    public UIDebug() {
        this.setTransient(true);
        this.setRendererType(null);
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public List getChildren() {
        return new ArrayList(){
            private static final long serialVersionUID = 2156130539926052013L;

            @Override
            public boolean add(Object o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }

            @Override
            public void add(int index, Object o) {
                throw new IllegalStateException("<ui:debug> does not support children");
            }
        };
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        if (this.isRendered()) {
            this.pushComponentToEL(facesContext, this);
            String actionId = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
            StringBuffer sb = new StringBuffer(512);
            sb.append("//<![CDATA[\n");
            sb.append("function faceletsDebug(URL) {");
            sb.append("day = new Date();");
            sb.append("id = day.getTime();");
            sb.append("eval(\"page\" + id + \" = window.open(URL, '\" + id + \"', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=800,height=600,left = 240,top = 212');\"); };");
            sb.append("(function() { if (typeof faceletsDebug === 'undefined') { var faceletsDebug = false; } if (!faceletsDebug) {");
            sb.append("var faceletsOrigKeyup = document.onkeyup;");
            sb.append("document.onkeyup = function(e) { if (window.event) e = window.event; if (String.fromCharCode(e.keyCode) == '" + this.getHotkey() + "' & e.shiftKey & e.ctrlKey) faceletsDebug('");
            sb.append(actionId);
            sb.append(actionId.indexOf(63) == -1 ? (char)'?' : '&');
            sb.append(KEY);
            sb.append('=');
            sb.append(UIDebug.writeDebugOutput(facesContext));
            sb.append("'); faceletsDebug = true; if (faceletsOrigKeyup) faceletsOrigKeyup(e); };\n");
            sb.append("}})();");
            sb.append("//]]>\n");
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("span", this);
            writer.writeAttribute("id", this.getClientId(facesContext), "id");
            writer.startElement("script", this);
            if (!RenderKitUtils.isOutputHtml5Doctype(facesContext)) {
                writer.writeAttribute("type", "text/javascript", "type");
            }
            writer.writeText(sb.toString(), this, null);
            writer.endElement("script");
            writer.endElement("span");
        }
    }

    private static String writeDebugOutput(FacesContext faces) throws IOException {
        FastWriter fw = new FastWriter();
        DevTools.debugHtml(fw, faces);
        Map<String, Object> session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        if (debugs == null) {
            debugs = new LinkedHashMap(){
                private static final long serialVersionUID = 2541609242499547693L;

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 5;
                }
            };
        }
        session.put(KEY, debugs);
        String id = "" + nextId++;
        debugs.put(id, fw.toString());
        return id;
    }

    private static String fetchDebugOutput(FacesContext faces, String id) {
        Map<String, Object> session = faces.getExternalContext().getSessionMap();
        Map debugs = (Map)session.get(KEY);
        if (debugs != null) {
            return (String)debugs.get(id);
        }
        return null;
    }

    public static boolean debugRequest(FacesContext faces) {
        String id = faces.getExternalContext().getRequestParameterMap().get(KEY);
        if (id != null) {
            Object resp = faces.getExternalContext().getResponse();
            if (!faces.getResponseComplete() && resp instanceof HttpServletResponse) {
                try {
                    HttpServletResponse httpResp = (HttpServletResponse)resp;
                    String page = UIDebug.fetchDebugOutput(faces, id);
                    if (page != null) {
                        httpResp.setContentType("text/html");
                        httpResp.getWriter().write(page);
                    } else {
                        httpResp.setContentType("text/plain");
                        httpResp.getWriter().write("No Debug Output Available");
                    }
                    httpResp.flushBuffer();
                    faces.responseComplete();
                }
                catch (IOException e) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String hotkey) {
        this.hotkey = hotkey != null ? hotkey.toUpperCase() : "";
    }
}

