/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.util.FixedBitSet;

class OverlappingLongRangeCounter
extends LongRangeCounter {
    private final LongRangeNode root;
    private final long[] boundaries;
    private boolean hasUnflushedCounts;
    private int[] singleValuedElementaryIntervalCounts;
    private FixedBitSet multiValuedDocElementaryIntervalHits;
    private FixedBitSet multiValuedDocRangeHits;
    private int elementaryIntervalUpto;
    private int missingCount;

    OverlappingLongRangeCounter(LongRange[] ranges, int[] countBuffer) {
        super(countBuffer);
        int i;
        List<LongRangeCounter.InclusiveRange> elementaryIntervals = OverlappingLongRangeCounter.buildElementaryIntervals(ranges);
        this.root = OverlappingLongRangeCounter.split(0, elementaryIntervals.size(), elementaryIntervals);
        for (i = 0; i < ranges.length; ++i) {
            this.root.addOutputs(i, ranges[i]);
        }
        this.boundaries = new long[elementaryIntervals.size()];
        for (i = 0; i < this.boundaries.length; ++i) {
            this.boundaries[i] = elementaryIntervals.get((int)i).end;
        }
    }

    @Override
    void startMultiValuedDoc() {
        super.startMultiValuedDoc();
        if (this.multiValuedDocElementaryIntervalHits == null) {
            this.multiValuedDocElementaryIntervalHits = new FixedBitSet(this.boundaries.length);
        } else {
            this.multiValuedDocElementaryIntervalHits.clear(0, this.multiValuedDocElementaryIntervalHits.length());
        }
    }

    @Override
    boolean endMultiValuedDoc() {
        assert (this.multiValuedDocElementaryIntervalHits != null) : "must call startDoc() first";
        if (this.rangeCount() == 0) {
            return false;
        }
        if (this.multiValuedDocRangeHits == null) {
            this.multiValuedDocRangeHits = new FixedBitSet(this.rangeCount());
        } else {
            this.multiValuedDocRangeHits.clear(0, this.multiValuedDocRangeHits.length());
        }
        this.elementaryIntervalUpto = 0;
        this.rollupMultiValued(this.root);
        boolean docContributedToAtLeastOneRange = false;
        int i = this.multiValuedDocRangeHits.nextSetBit(0);
        while (i < this.multiValuedDocRangeHits.length()) {
            this.increment(i);
            docContributedToAtLeastOneRange = true;
            if (++i >= this.multiValuedDocRangeHits.length()) continue;
            i = this.multiValuedDocRangeHits.nextSetBit(i);
        }
        return docContributedToAtLeastOneRange;
    }

    @Override
    int finish() {
        if (this.hasUnflushedCounts) {
            this.missingCount = 0;
            this.elementaryIntervalUpto = 0;
            this.rollupSingleValued(this.root, false);
            return this.missingCount;
        }
        return 0;
    }

    @Override
    protected long[] boundaries() {
        return this.boundaries;
    }

    @Override
    protected void processSingleValuedHit(int elementaryIntervalNum) {
        if (this.singleValuedElementaryIntervalCounts == null) {
            this.singleValuedElementaryIntervalCounts = new int[this.boundaries.length];
        }
        int n = elementaryIntervalNum;
        this.singleValuedElementaryIntervalCounts[n] = this.singleValuedElementaryIntervalCounts[n] + 1;
        this.hasUnflushedCounts = true;
    }

    @Override
    protected void processMultiValuedHit(int elementaryIntervalNum) {
        assert (this.multiValuedDocElementaryIntervalHits != null) : "must call startDoc() first";
        this.multiValuedDocElementaryIntervalHits.set(elementaryIntervalNum);
    }

    private static LongRangeNode split(int start, int end, List<LongRangeCounter.InclusiveRange> elementaryIntervals) {
        if (start == end - 1) {
            LongRangeCounter.InclusiveRange range = elementaryIntervals.get(start);
            return new LongRangeNode(range.start, range.end, null, null, start);
        }
        int mid = start + end >>> 1;
        LongRangeNode left = OverlappingLongRangeCounter.split(start, mid, elementaryIntervals);
        LongRangeNode right = OverlappingLongRangeCounter.split(mid, end, elementaryIntervals);
        return new LongRangeNode(left.start, right.end, left, right, -1);
    }

    private int rollupSingleValued(LongRangeNode node, boolean sawOutputs) {
        int count;
        sawOutputs |= node.outputs != null;
        if (node.left != null) {
            count = this.rollupSingleValued(node.left, sawOutputs);
            count += this.rollupSingleValued(node.right, sawOutputs);
        } else {
            count = this.singleValuedElementaryIntervalCounts[this.elementaryIntervalUpto];
            ++this.elementaryIntervalUpto;
            if (!sawOutputs) {
                this.missingCount += count;
            }
        }
        if (node.outputs != null) {
            for (int rangeIndex : node.outputs) {
                this.increment(rangeIndex, count);
            }
        }
        return count;
    }

    private boolean rollupMultiValued(LongRangeNode node) {
        boolean containedHit;
        if (node.left != null) {
            containedHit = this.rollupMultiValued(node.left);
            containedHit |= this.rollupMultiValued(node.right);
        } else {
            containedHit = this.multiValuedDocElementaryIntervalHits.get(this.elementaryIntervalUpto);
            ++this.elementaryIntervalUpto;
        }
        if (containedHit && node.outputs != null) {
            for (int rangeIndex : node.outputs) {
                this.multiValuedDocRangeHits.set(rangeIndex);
            }
        }
        return containedHit;
    }

    private static List<LongRangeCounter.InclusiveRange> buildElementaryIntervals(LongRange[] ranges) {
        long prev;
        HashMap<Long, Integer> endsMap = new HashMap<Long, Integer>();
        endsMap.put(Long.MIN_VALUE, 1);
        endsMap.put(Long.MAX_VALUE, 2);
        for (LongRange range : ranges) {
            Integer cur = (Integer)endsMap.get(range.min);
            if (cur == null) {
                endsMap.put(range.min, 1);
            } else {
                endsMap.put(range.min, cur | 1);
            }
            cur = (Integer)endsMap.get(range.max);
            if (cur == null) {
                endsMap.put(range.max, 2);
                continue;
            }
            endsMap.put(range.max, cur | 2);
        }
        ArrayList endsList = new ArrayList(endsMap.keySet());
        Collections.sort(endsList);
        ArrayList<LongRangeCounter.InclusiveRange> elementaryIntervals = new ArrayList<LongRangeCounter.InclusiveRange>();
        int upto = 1;
        long v = (Long)endsList.get(0);
        if ((Integer)endsMap.get(v) == 3) {
            elementaryIntervals.add(new LongRangeCounter.InclusiveRange(v, v));
            prev = v + 1L;
        } else {
            prev = v;
        }
        while (upto < endsList.size()) {
            v = (Long)endsList.get(upto);
            int flags = (Integer)endsMap.get(v);
            if (flags == 3) {
                if (v > prev) {
                    elementaryIntervals.add(new LongRangeCounter.InclusiveRange(prev, v - 1L));
                }
                elementaryIntervals.add(new LongRangeCounter.InclusiveRange(v, v));
                prev = v + 1L;
            } else if (flags == 1) {
                if (v > prev) {
                    elementaryIntervals.add(new LongRangeCounter.InclusiveRange(prev, v - 1L));
                }
                prev = v;
            } else {
                assert (flags == 2);
                elementaryIntervals.add(new LongRangeCounter.InclusiveRange(prev, v));
                prev = v + 1L;
            }
            ++upto;
        }
        return elementaryIntervals;
    }

    public static final class LongRangeNode {
        final LongRangeNode left;
        final LongRangeNode right;
        final long start;
        final long end;
        final int elementaryIntervalIndex;
        List<Integer> outputs;

        public LongRangeNode(long start, long end, LongRangeNode left, LongRangeNode right, int elementaryIntervalIndex) {
            this.start = start;
            this.end = end;
            this.left = left;
            this.right = right;
            this.elementaryIntervalIndex = elementaryIntervalIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, 0);
            return sb.toString();
        }

        static void indent(StringBuilder sb, int depth) {
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
        }

        void addOutputs(int index, LongRange range) {
            if (this.start >= range.min && this.end <= range.max) {
                if (this.outputs == null) {
                    this.outputs = new ArrayList<Integer>();
                }
                this.outputs.add(index);
            } else if (this.left != null) {
                assert (this.right != null);
                this.left.addOutputs(index, range);
                this.right.addOutputs(index, range);
            }
        }

        void toString(StringBuilder sb, int depth) {
            LongRangeNode.indent(sb, depth);
            if (this.left == null) {
                assert (this.right == null);
                sb.append("leaf: ").append(this.start).append(" to ").append(this.end);
            } else {
                sb.append("node: ").append(this.start).append(" to ").append(this.end);
            }
            if (this.outputs != null) {
                sb.append(" outputs=");
                sb.append(this.outputs);
            }
            sb.append('\n');
            if (this.left != null) {
                assert (this.right != null);
                this.left.toString(sb, depth + 1);
                this.right.toString(sb, depth + 1);
            }
        }
    }
}

