/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.ZoneOffsetMarshaller;

public class ZonedDateTimeMarshaller
implements ProtoStreamMarshaller<ZonedDateTime> {
    private static final int DATE_INDEX = 1;
    private static final int TIME_INDEX = 1 + LocalDateMarshaller.INSTANCE.getFields();
    private static final int OFFSET_INDEX = TIME_INDEX + LocalTimeMarshaller.INSTANCE.getFields();
    private static final int ZONE_INDEX = OFFSET_INDEX + ZoneOffsetMarshaller.INSTANCE.getFields();

    @Override
    public ZonedDateTime readFrom(ProtoStreamReader reader) throws IOException {
        LocalDate date = LocalDateMarshaller.INSTANCE.getBuilder();
        LocalTime time = LocalTimeMarshaller.INSTANCE.getBuilder();
        ZoneId zone = ZoneOffsetMarshaller.INSTANCE.getBuilder();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index >= 1 && index < TIME_INDEX) {
                date = LocalDateMarshaller.INSTANCE.readField(reader, index - 1, date);
                continue;
            }
            if (index >= TIME_INDEX && index < OFFSET_INDEX) {
                time = LocalTimeMarshaller.INSTANCE.readField(reader, index - TIME_INDEX, time);
                continue;
            }
            if (index >= OFFSET_INDEX && index < ZONE_INDEX) {
                zone = ZoneOffsetMarshaller.INSTANCE.readField(reader, index - OFFSET_INDEX, (ZoneOffset)zone);
                continue;
            }
            if (index == ZONE_INDEX) {
                zone = ZoneId.of(reader.readString());
                continue;
            }
            reader.skipField(tag);
        }
        return ZonedDateTime.of(date, time, zone);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, ZonedDateTime value) throws IOException {
        LocalDateMarshaller.INSTANCE.writeFields(writer, 1, value.toLocalDate());
        LocalTimeMarshaller.INSTANCE.writeFields(writer, TIME_INDEX, value.toLocalTime());
        ZoneId zone = value.getZone();
        if (zone instanceof ZoneOffset) {
            ZoneOffsetMarshaller.INSTANCE.writeFields(writer, OFFSET_INDEX, (ZoneOffset)zone);
        } else {
            writer.writeString(ZONE_INDEX, zone.getId());
        }
    }

    @Override
    public Class<? extends ZonedDateTime> getJavaClass() {
        return ZonedDateTime.class;
    }
}

