/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.Attribute;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.SimpleConnectionFactoryConfiguration;

public abstract class AbstractJdbcStoreConfigurationSerializer
extends AbstractStoreSerializer {
    protected void writeJdbcStoreAttributes(ConfigurationWriter writer, AbstractJdbcStoreConfiguration configuration) {
        configuration.attributes().write(writer);
    }

    private void writeJDBCStoreConnection(ConfigurationWriter writer, SimpleConnectionFactoryConfiguration configuration) {
        writer.writeStartElement((Enum)Element.SIMPLE_CONNECTION);
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.CONNECTION_URL, (String)configuration.connectionUrl());
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.DRIVER_CLASS, (String)configuration.driverClass());
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.USERNAME, (String)configuration.username());
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.PASSWORD, (String)configuration.password());
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(ConfigurationWriter writer, PooledConnectionFactoryConfiguration configuration) {
        writer.writeStartElement((Enum)Element.CONNECTION_POOL);
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.CONNECTION_URL, (String)configuration.connectionUrl());
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.DRIVER_CLASS, (String)configuration.driverClass());
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.USERNAME, (String)configuration.username());
        SerializeUtils.writeOptional((ConfigurationWriter)writer, (Enum)Attribute.PASSWORD, (String)configuration.password());
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(ConfigurationWriter writer, ManagedConnectionFactoryConfiguration configuration) {
        writer.writeStartElement((Enum)Element.DATA_SOURCE);
        writer.writeAttribute((Enum)Attribute.JNDI_URL, configuration.jndiUrl());
        writer.writeEndElement();
    }

    protected void writeJDBCStoreConnection(ConfigurationWriter writer, AbstractJdbcStoreConfiguration configuration) {
        ConnectionFactoryConfiguration cfc = configuration.connectionFactory();
        if (cfc instanceof SimpleConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (SimpleConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof PooledConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (PooledConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof ManagedConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (ManagedConnectionFactoryConfiguration)cfc);
        }
    }
}

