/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.services.framework.startup;

import java.util.ArrayList;
import java.util.List;

public class Sequencer {
    public static final int SEQUENCE_WSCOOR10 = 0;
    public static final int SEQUENCE_WSCOOR11 = 1;
    public static final int SEQUENCE_MAX = 2;
    public static final int WEBAPP_WSC10 = 0;
    public static final int WEBAPP_WST10 = 1;
    public static final int WEBAPP_WSCF10 = 2;
    public static final int WEBAPP_WSTX10 = 3;
    public static final int WEBAPP_MAX10 = 4;
    public static final int WEBAPP_WSC11 = 0;
    public static final int WEBAPP_WST11 = 1;
    public static final int WEBAPP_WSCF11 = 2;
    public static final int WEBAPP_WSTX11 = 3;
    public static final int WEBAPP_MAX11 = 4;
    private static boolean latched = true;
    private static final Sequencer[] SEQUENCERS = new Sequencer[]{new Sequencer(4), new Sequencer(4)};
    private static List<Sequencer> deferred = new ArrayList<Sequencer>();
    private List<Callback>[] callbacks;
    private boolean[] closed;
    private int closedCount;
    private int sequenceSize;

    public static final void close(int sequence, int webapp) {
        SEQUENCERS[sequence].close(webapp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlatch() {
        Class<Sequencer> clazz = Sequencer.class;
        synchronized (Sequencer.class) {
            latched = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            for (Sequencer sequencer : deferred) {
                sequencer.runCallbacks();
            }
            return;
        }
    }

    private static final void register(Callback callback, int sequence, int webapp) {
        SEQUENCERS[sequence].register(callback, webapp);
    }

    private final void register(Callback callback, int webapp) {
        this.callbacks[webapp].add(callback);
    }

    private final void close(int webapp) {
        this.closed[webapp] = true;
        ++this.closedCount;
        if (this.closedCount == this.sequenceSize) {
            this.runCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCallbacks() {
        Class<Sequencer> clazz = Sequencer.class;
        synchronized (Sequencer.class) {
            if (latched) {
                deferred.add(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (int i = 0; i < this.sequenceSize; ++i) {
                for (Callback cb : this.callbacks[i]) {
                    cb.run();
                }
            }
            return;
        }
    }

    private Sequencer(int sequenceSize) {
        this.sequenceSize = sequenceSize;
        this.callbacks = new ArrayList[sequenceSize];
        for (int i = 0; i < sequenceSize; ++i) {
            this.callbacks[i] = new ArrayList<Callback>();
        }
        this.closed = new boolean[sequenceSize];
        this.closedCount = 0;
    }

    public static abstract class Callback {
        public Callback(int sequence, int webapp) {
            Sequencer.register(this, sequence, webapp);
        }

        public abstract void run();
    }
}

