/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.stub;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.soap.SoapUtils;
import com.arjuna.webservices11.util.StreamHelper;
import com.arjuna.webservices11.wsat.State;
import com.arjuna.wst.Aborted;
import com.arjuna.wst.Participant;
import com.arjuna.wst.PersistableParticipant;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.ReadOnly;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.Vote;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst.stub.SystemCommunicationException;
import com.arjuna.wst11.messaging.CoordinatorProcessorImpl;
import com.arjuna.wst11.messaging.engines.CoordinatorEngine;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class ParticipantStub
implements Participant,
PersistableParticipant {
    private static final QName QNAME_TWO_PC_PARTICIPANT = new QName("twoPCParticipant");
    private CoordinatorEngine coordinator;

    public ParticipantStub(String id, boolean durable, W3CEndpointReference twoPCParticipant) throws Exception {
        if (id != null) {
            this.coordinator = new CoordinatorEngine(id, durable, twoPCParticipant);
        }
    }

    @Override
    public Vote prepare() throws WrongStateException, SystemException {
        State state = this.coordinator.prepare();
        if (state == State.STATE_PREPARED_SUCCESS) {
            return new Prepared();
        }
        if (state == State.STATE_ABORTING) {
            return new Aborted();
        }
        if (state == null) {
            if (this.coordinator.isReadOnly()) {
                return new ReadOnly();
            }
            return new Aborted();
        }
        if (state == State.STATE_PREPARING) {
            throw new SystemCommunicationException();
        }
        throw new WrongStateException();
    }

    @Override
    public void commit() throws WrongStateException, SystemException {
        State state = this.coordinator.commit();
        if (state != null) {
            if (state == State.STATE_COMMITTING) {
                throw new SystemCommunicationException();
            }
            throw new WrongStateException();
        }
    }

    @Override
    public void rollback() throws WrongStateException, SystemException {
        State state = this.coordinator.rollback();
        if (state != null) {
            if (state == State.STATE_ABORTING) {
                throw new SystemCommunicationException();
            }
            throw new WrongStateException();
        }
    }

    @Override
    public void unknown() throws SystemException {
        this.error();
    }

    @Override
    public void error() throws SystemException {
        try {
            this.rollback();
        }
        catch (WrongStateException wrongStateException) {
            // empty catch block
        }
    }

    @Override
    public boolean saveState(OutputObjectState oos) {
        try {
            oos.packString(this.coordinator.getId());
            oos.packBoolean(this.coordinator.isDurable());
            State state = this.coordinator.getState();
            if (state == State.STATE_ACTIVE) {
                oos.packInt(0);
            } else if (state == State.STATE_PREPARING) {
                oos.packInt(1);
            } else if (state == State.STATE_PREPARED || state == State.STATE_PREPARED_SUCCESS) {
                oos.packInt(2);
            } else if (state == State.STATE_ABORTING) {
                oos.packInt(3);
            } else {
                oos.packInt(4);
            }
            StringWriter sw = new StringWriter();
            XMLStreamWriter writer = SoapUtils.getXMLStreamWriter(sw);
            StreamHelper.writeStartElement(writer, QNAME_TWO_PC_PARTICIPANT);
            String eprefText = this.coordinator.getParticipant().toString();
            writer.writeCData(eprefText);
            StreamHelper.writeEndElement(writer, null, null);
            writer.close();
            sw.close();
            String tmp = writer.toString();
            String swString = sw.toString();
            oos.packString(swString);
            return true;
        }
        catch (Throwable th) {
            WSTLogger.i18NLogger.error_wst11_stub_ParticipantStub_1(th);
            return false;
        }
    }

    @Override
    public boolean restoreState(InputObjectState ios) {
        try {
            State state;
            String id = ios.unpackString();
            boolean durable = ios.unpackBoolean();
            int stateTag = ios.unpackInt();
            switch (stateTag) {
                case 0: {
                    state = State.STATE_ACTIVE;
                    break;
                }
                case 1: {
                    state = State.STATE_PREPARING;
                    break;
                }
                case 2: {
                    state = State.STATE_PREPARED_SUCCESS;
                    break;
                }
                case 3: {
                    state = State.STATE_ABORTING;
                    break;
                }
                default: {
                    state = State.STATE_COMMITTING;
                }
            }
            String eprValue = ios.unpackString();
            XMLStreamReader reader = SoapUtils.getXMLStreamReader(new StringReader(eprValue));
            StreamHelper.checkNextStartTag(reader, QNAME_TWO_PC_PARTICIPANT);
            String eprefText = reader.getElementText();
            StreamSource source = new StreamSource(new StringReader(eprefText));
            W3CEndpointReference endpointReference = new W3CEndpointReference((Source)source);
            this.coordinator = (CoordinatorEngine)CoordinatorProcessorImpl.getProcessor().getCoordinator(id);
            if (this.coordinator == null) {
                this.coordinator = new CoordinatorEngine(id, durable, endpointReference, true, state);
            }
            return true;
        }
        catch (Throwable th) {
            WSTLogger.i18NLogger.error_wst11_stub_ParticipantStub_2(th);
            return false;
        }
    }
}

