/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.spi;

import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexNode;
import org.hibernate.search.engine.backend.document.model.spi.IndexCompositeNode;
import org.hibernate.search.engine.backend.document.model.spi.IndexField;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeTypeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class AbstractIndexField<S extends AbstractIndexField<S, SC, ?, C>, SC extends SearchIndexScope<?>, NT extends SearchIndexNodeTypeContext<SC, ? super S>, C extends IndexCompositeNode<SC, ?, ?>>
extends AbstractIndexNode<S, SC, NT>
implements IndexField<SC, C> {
    protected final C parent;
    protected final String absolutePath;
    protected final String[] absolutePathComponents;
    protected final String relativeName;
    protected final TreeNodeInclusion inclusion;
    protected final boolean multiValued;
    private final String closestMultiValuedParentAbsolutePath;

    public AbstractIndexField(C parent, String relativeFieldName, NT type, TreeNodeInclusion inclusion, boolean multiValued) {
        super(type);
        this.parent = parent;
        this.absolutePath = parent.absolutePath(relativeFieldName);
        this.absolutePathComponents = FieldPaths.split(this.absolutePath);
        this.relativeName = relativeFieldName;
        this.inclusion = inclusion;
        this.multiValued = multiValued;
        this.closestMultiValuedParentAbsolutePath = parent.multiValued() ? parent.absolutePath() : parent.closestMultiValuedParentAbsolutePath();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absolutePath=" + this.absolutePath + ", type=" + this.type + "]";
    }

    @Override
    public final EventContext relativeEventContext() {
        return EventContexts.fromIndexFieldAbsolutePath(this.absolutePath);
    }

    @Override
    public final C parent() {
        return this.parent;
    }

    @Override
    public final String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public final String[] absolutePathComponents() {
        return this.absolutePathComponents;
    }

    @Override
    public final String relativeName() {
        return this.relativeName;
    }

    @Override
    public final TreeNodeInclusion inclusion() {
        return this.inclusion;
    }

    @Override
    public final boolean multiValued() {
        return this.multiValued;
    }

    @Override
    public boolean multiValuedInRoot() {
        return this.multiValued || this.closestMultiValuedParentAbsolutePath != null;
    }

    @Override
    public String closestMultiValuedParentAbsolutePath() {
        return this.closestMultiValuedParentAbsolutePath;
    }
}

