/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.vfs.VirtualFile;

public class ApplicationClientDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String META_INF_APPLICATION_CLIENT_XML = "META-INF/application-client.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            List potentialSubDeployments = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : potentialSubDeployments) {
                String mainClass;
                Attributes main;
                if (ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot)) continue;
                VirtualFile appclientClientXml = resourceRoot.getRoot().getChild(META_INF_APPLICATION_CLIENT_XML);
                if (appclientClientXml.exists()) {
                    SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
                    ModuleRootMarker.mark((ResourceRoot)resourceRoot);
                    continue;
                }
                Manifest manifest = (Manifest)resourceRoot.getAttachment(org.jboss.as.server.deployment.Attachments.MANIFEST);
                if (manifest == null || (main = manifest.getMainAttributes()) == null || (mainClass = main.getValue("Main-Class")) == null || mainClass.isEmpty()) continue;
                SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
                ModuleRootMarker.mark((ResourceRoot)resourceRoot);
            }
        } else if (deploymentUnit.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
            ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
            ModuleMetaData md = (ModuleMetaData)root.getAttachment(Attachments.MODULE_META_DATA);
            if (md != null) {
                if (md.getType() == ModuleMetaData.ModuleType.Client) {
                    DeploymentTypeMarker.setType(DeploymentType.APPLICATION_CLIENT, deploymentUnit);
                }
            } else {
                VirtualFile appclientClientXml = root.getRoot().getChild(META_INF_APPLICATION_CLIENT_XML);
                if (appclientClientXml.exists()) {
                    DeploymentTypeMarker.setType(DeploymentType.APPLICATION_CLIENT, deploymentUnit);
                } else {
                    String mainClass;
                    Attributes main;
                    Manifest manifest = (Manifest)root.getAttachment(org.jboss.as.server.deployment.Attachments.MANIFEST);
                    if (manifest != null && (main = manifest.getMainAttributes()) != null && (mainClass = main.getValue("Main-Class")) != null && !mainClass.isEmpty()) {
                        DeploymentTypeMarker.setType(DeploymentType.APPLICATION_CLIENT, deploymentUnit);
                    }
                }
            }
        }
    }
}

