/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.internal.JdbcServicesImpl;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jpa.internal.MutableJpaComplianceImpl;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.resource.jdbc.spi.JdbcObserver;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class JdbcEnvironmentInitiator
implements StandardServiceInitiator<JdbcEnvironment> {
    private static final CoreMessageLogger log = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JdbcEnvironmentInitiator.class.getName());
    public static final JdbcEnvironmentInitiator INSTANCE = new JdbcEnvironmentInitiator();

    @Override
    public Class<JdbcEnvironment> getServiceInitiated() {
        return JdbcEnvironment.class;
    }

    @Override
    public JdbcEnvironment initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        DialectFactory dialectFactory = registry.getService(DialectFactory.class);
        String explicitDatabaseName = JdbcEnvironmentInitiator.getExplicitDatabaseName(configurationValues);
        Integer explicitDatabaseMajorVersion = JdbcEnvironmentInitiator.getExplicitDatabaseMajorVersion(configurationValues);
        Integer explicitDatabaseMinorVersion = JdbcEnvironmentInitiator.getExplicitDatabaseMinorVersion(configurationValues);
        String explicitDatabaseVersion = JdbcEnvironmentInitiator.getExplicitDatabaseVersion(configurationValues, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion);
        if (explicitDatabaseMajorVersion == null && explicitDatabaseMinorVersion == null && explicitDatabaseVersion != null) {
            String[] parts = explicitDatabaseVersion.split("\\.");
            try {
                int potentialMajor = Integer.parseInt(parts[0]);
                if (parts.length > 1) {
                    explicitDatabaseMinorVersion = Integer.parseInt(parts[1]);
                }
                explicitDatabaseMajorVersion = potentialMajor;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (JdbcEnvironmentInitiator.useJdbcMetadata(configurationValues)) {
            return this.getJdbcEnvironmentUsingJdbcMetadata(configurationValues, registry, dialectFactory, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion);
        }
        if (JdbcEnvironmentInitiator.explicitDialectConfiguration(configurationValues, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion)) {
            return JdbcEnvironmentInitiator.getJdbcEnvironmentWithExplicitConfiguration(configurationValues, registry, dialectFactory, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion);
        }
        return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
    }

    private static JdbcEnvironmentImpl getJdbcEnvironmentWithDefaults(Map<String, Object> configurationValues, ServiceRegistryImplementor registry, DialectFactory dialectFactory) {
        return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, null));
    }

    private static JdbcEnvironmentImpl getJdbcEnvironmentWithExplicitConfiguration(Map<String, Object> configurationValues, ServiceRegistryImplementor registry, DialectFactory dialectFactory, String explicitDatabaseName, Integer explicitDatabaseMajorVersion, Integer explicitDatabaseMinorVersion, String explicitDatabaseVersion) {
        DialectResolutionInfoImpl dialectResolutionInfo = new DialectResolutionInfoImpl(null, explicitDatabaseName, explicitDatabaseVersion != null ? explicitDatabaseVersion : "0", explicitDatabaseMajorVersion != null ? explicitDatabaseMajorVersion : 0, explicitDatabaseMinorVersion != null ? explicitDatabaseMinorVersion : 0, null, 0, 0, null);
        return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, () -> dialectResolutionInfo));
    }

    private static boolean useJdbcMetadata(Map<String, Object> configurationValues) {
        return ConfigurationHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", configurationValues, true);
    }

    private static String getExplicitDatabaseVersion(Map<String, Object> configurationValues, Integer configuredDatabaseMajorVersion, Integer configuredDatabaseMinorVersion) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> (String)configurationValues.get("jakarta.persistence.database-product-version"), () -> {
            Object value = configurationValues.get("javax.persistence.database-product-version");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-version", "jakarta.persistence.database-product-version");
            }
            return (String)value;
        }, () -> {
            if (configuredDatabaseMajorVersion != null) {
                return configuredDatabaseMinorVersion == null ? configuredDatabaseMajorVersion.toString() : configuredDatabaseMajorVersion + "." + configuredDatabaseMinorVersion;
            }
            return null;
        });
    }

    private static Integer getExplicitDatabaseMinorVersion(Map<String, Object> configurationValues) {
        return (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-minor-version", configurationValues), () -> {
            Integer value = ConfigurationHelper.getInteger("javax.persistence.database-minor-version", configurationValues);
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-minor-version", "jakarta.persistence.database-minor-version");
            }
            return value;
        });
    }

    private static Integer getExplicitDatabaseMajorVersion(Map<String, Object> configurationValues) {
        return (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-major-version", configurationValues), () -> {
            Integer value = ConfigurationHelper.getInteger("javax.persistence.database-major-version", configurationValues);
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-major-version", "jakarta.persistence.database-major-version");
            }
            return value;
        });
    }

    private static String getExplicitDatabaseName(Map<String, Object> configurationValues) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> (String)configurationValues.get("jakarta.persistence.database-product-name"), () -> {
            Object value = configurationValues.get("javax.persistence.database-product-name");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-name", "jakarta.persistence.database-product-name");
            }
            return (String)value;
        });
    }

    private JdbcEnvironmentImpl getJdbcEnvironmentUsingJdbcMetadata(final Map<String, Object> configurationValues, final ServiceRegistryImplementor registry, final DialectFactory dialectFactory, final String explicitDatabaseName, final Integer explicitDatabaseMajorVersion, final Integer explicitDatabaseMinorVersion, final String explicitDatabaseVersion) {
        final JdbcConnectionAccess jdbcConnectionAccess = this.buildJdbcConnectionAccess(registry);
        JdbcServicesImpl jdbcServices = new JdbcServicesImpl(registry);
        TemporaryJdbcSessionOwner temporaryJdbcSessionOwner = new TemporaryJdbcSessionOwner(jdbcConnectionAccess, jdbcServices, registry);
        temporaryJdbcSessionOwner.transactionCoordinator = registry.getService(TransactionCoordinatorBuilder.class).buildTransactionCoordinator(new JdbcCoordinatorImpl(null, temporaryJdbcSessionOwner, jdbcServices), () -> false);
        try {
            return temporaryJdbcSessionOwner.transactionCoordinator.createIsolationDelegate().delegateWork(new AbstractReturningWork<JdbcEnvironmentImpl>(){

                @Override
                public JdbcEnvironmentImpl execute(Connection connection) throws SQLException {
                    try {
                        DatabaseMetaData dbmd = connection.getMetaData();
                        JdbcEnvironmentInitiator.logDatabaseAndDriver(dbmd);
                        String databaseName = explicitDatabaseName == null ? dbmd.getDatabaseProductName() : explicitDatabaseName;
                        String databaseVersion = explicitDatabaseVersion == null ? dbmd.getDatabaseProductVersion() : explicitDatabaseVersion;
                        int databaseMajorVersion = explicitDatabaseMajorVersion == null ? dbmd.getDatabaseMajorVersion() : explicitDatabaseMajorVersion.intValue();
                        int databaseMinorVersion = explicitDatabaseMinorVersion == null ? dbmd.getDatabaseMinorVersion() : explicitDatabaseMinorVersion.intValue();
                        DialectResolutionInfoImpl dialectResolutionInfo = new DialectResolutionInfoImpl(dbmd, databaseName, databaseVersion, databaseMajorVersion, databaseMinorVersion, dbmd.getDriverName(), dbmd.getDriverMajorVersion(), dbmd.getDriverMinorVersion(), dbmd.getSQLKeywords());
                        return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, () -> dialectResolutionInfo), dbmd, jdbcConnectionAccess);
                    }
                    catch (SQLException e) {
                        log.unableToObtainConnectionMetadata(e);
                        return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
                    }
                }
            }, false);
        }
        catch (Exception e) {
            log.unableToObtainConnectionToQueryMetadata(e);
            return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
        }
    }

    private static void logDatabaseAndDriver(DatabaseMetaData dbmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debugf("Database ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", new Object[]{dbmd.getDatabaseProductName(), dbmd.getDatabaseProductVersion(), dbmd.getDatabaseMajorVersion(), dbmd.getDatabaseMinorVersion()});
            log.debugf("Driver ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", new Object[]{dbmd.getDriverName(), dbmd.getDriverVersion(), dbmd.getDriverMajorVersion(), dbmd.getDriverMinorVersion()});
            log.debugf("JDBC version : %s.%s", dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion());
        }
    }

    private static boolean explicitDialectConfiguration(Map<String, Object> configurationValues, String explicitDatabaseName, Integer explicitDatabaseMajorVersion, Integer explicitDatabaseMinorVersion, String explicitDatabaseVersion) {
        return !(!StringHelper.isNotEmpty(explicitDatabaseVersion) && explicitDatabaseMajorVersion == null && explicitDatabaseMinorVersion == null || !StringHelper.isNotEmpty(explicitDatabaseName) && !JdbcEnvironmentInitiator.isNotNullAndNotEmpty(configurationValues.get("hibernate.dialect")));
    }

    private static boolean isNotNullAndNotEmpty(Object o) {
        return o != null && (!(o instanceof String) || !((String)o).isEmpty());
    }

    private JdbcConnectionAccess buildJdbcConnectionAccess(ServiceRegistryImplementor registry) {
        if (!JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            ConnectionProvider connectionProvider = registry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(connectionProvider);
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    public static JdbcConnectionAccess buildBootstrapJdbcConnectionAccess(ServiceRegistryImplementor registry) {
        if (!JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            ConnectionProvider connectionProvider = registry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(connectionProvider);
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    private static class TemporaryJdbcSessionOwner
    implements JdbcSessionOwner,
    JdbcSessionContext {
        private final JdbcConnectionAccess jdbcConnectionAccess;
        private final JdbcServices jdbcServices;
        private final ServiceRegistryImplementor serviceRegistry;
        private final boolean jtaTrackByThread;
        private final boolean preferUserTransaction;
        private final boolean connectionProviderDisablesAutoCommit;
        private final PhysicalConnectionHandlingMode connectionHandlingMode;
        private final JpaCompliance jpaCompliance;
        TransactionCoordinator transactionCoordinator;

        public TemporaryJdbcSessionOwner(JdbcConnectionAccess jdbcConnectionAccess, JdbcServices jdbcServices, ServiceRegistryImplementor serviceRegistry) {
            this.jdbcConnectionAccess = jdbcConnectionAccess;
            this.jdbcServices = jdbcServices;
            this.serviceRegistry = serviceRegistry;
            ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
            this.jtaTrackByThread = configurationService.getSetting("hibernate.jta.track_by_thread", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.preferUserTransaction = ConfigurationHelper.getBoolean("hibernate.jta.prefer_user_transaction", configurationService.getSettings());
            this.connectionProviderDisablesAutoCommit = ConfigurationHelper.getBoolean("hibernate.connection.provider_disables_autocommit", configurationService.getSettings(), false);
            PhysicalConnectionHandlingMode specifiedHandlingMode = PhysicalConnectionHandlingMode.interpret(configurationService.getSettings().get("hibernate.connection.handling_mode"));
            this.connectionHandlingMode = specifiedHandlingMode != null ? specifiedHandlingMode : serviceRegistry.getService(TransactionCoordinatorBuilder.class).getDefaultConnectionHandlingMode();
            this.jpaCompliance = new MutableJpaComplianceImpl(Collections.emptyMap(), false);
        }

        @Override
        public JdbcSessionContext getJdbcSessionContext() {
            return this;
        }

        @Override
        public JdbcConnectionAccess getJdbcConnectionAccess() {
            return this.jdbcConnectionAccess;
        }

        @Override
        public TransactionCoordinator getTransactionCoordinator() {
            return this.transactionCoordinator;
        }

        @Override
        public void startTransactionBoundary() {
        }

        @Override
        public void afterTransactionBegin() {
        }

        @Override
        public void beforeTransactionCompletion() {
        }

        @Override
        public void afterTransactionCompletion(boolean successful, boolean delayed) {
        }

        @Override
        public void flushBeforeTransactionCompletion() {
        }

        @Override
        public Integer getJdbcBatchSize() {
            return null;
        }

        @Override
        public boolean isScrollableResultSetsEnabled() {
            return false;
        }

        @Override
        public boolean isGetGeneratedKeysEnabled() {
            return false;
        }

        @Override
        public Integer getFetchSizeOrNull() {
            return null;
        }

        @Override
        public int getFetchSize() {
            return 0;
        }

        @Override
        public boolean doesConnectionProviderDisableAutoCommit() {
            return this.connectionProviderDisablesAutoCommit;
        }

        @Override
        public boolean isPreferUserTransaction() {
            return this.preferUserTransaction;
        }

        @Override
        public boolean isJtaTrackByThread() {
            return this.jtaTrackByThread;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.connectionHandlingMode;
        }

        @Override
        public StatementInspector getStatementInspector() {
            return null;
        }

        @Override
        public JpaCompliance getJpaCompliance() {
            return this.jpaCompliance;
        }

        @Override
        public StatisticsImplementor getStatistics() {
            return null;
        }

        @Override
        public JdbcObserver getObserver() {
            return null;
        }

        @Override
        public SessionFactoryImplementor getSessionFactory() {
            return null;
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public JdbcServices getJdbcServices() {
            return this.jdbcServices;
        }

        @Override
        public BatchBuilder getBatchBuilder() {
            return null;
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    private static class DialectResolutionInfoImpl
    implements DialectResolutionInfo {
        private final DatabaseMetaData databaseMetadata;
        private final String databaseName;
        private final String databaseVersion;
        private final int databaseMajorVersion;
        private final int databaseMinorVersion;
        private final String driverName;
        private final int driverMajorVersion;
        private final int driverMinorVersion;
        private final String sqlKeywords;

        public DialectResolutionInfoImpl(DatabaseMetaData databaseMetadata, String databaseName, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String driverName, int driverMajorVersion, int driverMinorVersion, String sqlKeywords) {
            this.databaseMetadata = databaseMetadata;
            this.databaseName = databaseName;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.driverName = driverName;
            this.driverMajorVersion = driverMajorVersion;
            this.driverMinorVersion = driverMinorVersion;
            this.sqlKeywords = sqlKeywords;
        }

        @Override
        public String getSQLKeywords() {
            return this.sqlKeywords;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public String getDatabaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public int getDatabaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        @Override
        public int getDatabaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        @Override
        public String getDriverName() {
            return this.driverName;
        }

        @Override
        public int getDriverMajorVersion() {
            return this.driverMajorVersion;
        }

        @Override
        public int getDriverMinorVersion() {
            return this.driverMinorVersion;
        }

        @Override
        public DatabaseMetaData getDatabaseMetadata() {
            return this.databaseMetadata;
        }

        public String toString() {
            return this.getMajor() + "." + this.getMinor();
        }
    }

    public static class MultiTenantConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final MultiTenantConnectionProvider connectionProvider;

        public MultiTenantConnectionProviderJdbcConnectionAccess(MultiTenantConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public MultiTenantConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getAnyConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.releaseAnyConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    public static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public ConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

