/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;

public class CapacityDependentDdlType
extends DdlTypeImpl {
    private final TypeEntry[] typeEntries;

    private CapacityDependentDdlType(Builder builder) {
        super(builder.sqlTypeCode, builder.typeNamePattern, builder.castTypeNamePattern, builder.castTypeName, builder.dialect);
        builder.typeEntries.sort(Comparator.naturalOrder());
        this.typeEntries = builder.typeEntries.toArray(new TypeEntry[0]);
    }

    @Override
    @Deprecated
    public String[] getRawTypeNames() {
        String[] rawTypeNames = new String[this.typeEntries.length + 1];
        for (int i = 0; i < this.typeEntries.length; ++i) {
            int parenEnd;
            String typeNamePattern = this.typeEntries[i].typeNamePattern;
            int paren = typeNamePattern.indexOf(40);
            rawTypeNames[i] = paren > 0 ? ((parenEnd = typeNamePattern.lastIndexOf(41)) + 1 == typeNamePattern.length() ? typeNamePattern.substring(0, paren) : typeNamePattern.substring(0, paren) + typeNamePattern.substring(parenEnd + 1)) : typeNamePattern;
        }
        rawTypeNames[this.typeEntries.length] = this.getRawTypeName();
        return rawTypeNames;
    }

    @Override
    public String getTypeName(Long size, Integer precision, Integer scale) {
        block3: {
            block2: {
                if (size == null || size <= 0L) break block2;
                for (TypeEntry typeEntry : this.typeEntries) {
                    if (size > typeEntry.capacity) continue;
                    return CapacityDependentDdlType.replace(typeEntry.typeNamePattern, size, precision, scale);
                }
                break block3;
            }
            if (precision == null || precision <= 0) break block3;
            for (TypeEntry typeEntry : this.typeEntries) {
                if ((long)precision.intValue() > typeEntry.capacity) continue;
                return CapacityDependentDdlType.replace(typeEntry.typeNamePattern, size, precision, scale);
            }
        }
        return super.getTypeName(size, precision, scale);
    }

    public static Builder builder(int sqlTypeCode, String typeNamePattern, Dialect dialect) {
        return CapacityDependentDdlType.builder(sqlTypeCode, typeNamePattern, typeNamePattern, dialect);
    }

    public static Builder builder(int sqlTypeCode, String typeNamePattern, String castTypeName, Dialect dialect) {
        return new Builder(sqlTypeCode, typeNamePattern, null, castTypeName, dialect);
    }

    public static Builder builder(int sqlTypeCode, String typeNamePattern, String castTypeNamePattern, String castTypeName, Dialect dialect) {
        return new Builder(sqlTypeCode, typeNamePattern, castTypeNamePattern, castTypeName, dialect);
    }

    private static class TypeEntry
    implements Comparable<TypeEntry> {
        private final long capacity;
        private final String typeNamePattern;

        public TypeEntry(long capacity, String typeNamePattern) {
            this.capacity = capacity;
            this.typeNamePattern = typeNamePattern;
        }

        @Override
        public int compareTo(TypeEntry o) {
            return Long.compare(this.capacity, o.capacity);
        }
    }

    public static class Builder {
        private final int sqlTypeCode;
        private final String typeNamePattern;
        private final String castTypeNamePattern;
        private final String castTypeName;
        private final Dialect dialect;
        private final List<TypeEntry> typeEntries;

        private Builder(int sqlTypeCode, String typeNamePattern, String castTypeNamePattern, String castTypeName, Dialect dialect) {
            this.sqlTypeCode = sqlTypeCode;
            this.typeNamePattern = typeNamePattern;
            this.castTypeNamePattern = castTypeNamePattern;
            this.castTypeName = castTypeName;
            this.dialect = dialect;
            this.typeEntries = new ArrayList<TypeEntry>();
        }

        public Builder withTypeCapacity(long capacity, String typeNamePattern) {
            this.typeEntries.add(new TypeEntry(capacity, typeNamePattern));
            return this;
        }

        public CapacityDependentDdlType build() {
            return new CapacityDependentDdlType(this);
        }
    }
}

