/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.Collections;
import java.util.List;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;

public final class RowPropertyHelper
extends ObjectPropertyHelper<RowMetadata> {
    private final RowMetadata rowMetadata;

    public RowPropertyHelper(ColumnMetadata[] columns) {
        this.rowMetadata = new RowMetadata(columns);
    }

    public RowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    @Override
    public RowMetadata getEntityMetadata(String typeName) {
        return this.rowMetadata;
    }

    @Override
    public List<?> mapPropertyNamePathToFieldIdPath(RowMetadata type, String[] propertyPath) {
        if (propertyPath.length > 1) {
            throw new IllegalStateException("Nested attributes are not supported");
        }
        String columnName = propertyPath[0];
        for (ColumnMetadata c : this.rowMetadata.getColumns()) {
            if (!c.getColumnName().equals(columnName)) continue;
            return Collections.singletonList(c.getColumnIndex());
        }
        throw new IllegalArgumentException("Column not found : " + columnName);
    }

    @Override
    public Class<?> getPrimitivePropertyType(RowMetadata entityType, String[] propertyPath) {
        Class<?> propType = this.getColumnAccessor(propertyPath).getPropertyType();
        if (propType.isEnum() || primitives.containsKey(propType)) {
            return propType;
        }
        return null;
    }

    private ColumnMetadata getColumnAccessor(String[] propertyPath) {
        if (propertyPath.length > 1) {
            throw new IllegalStateException("Nested attributes are not supported");
        }
        String columnName = propertyPath[0];
        for (ColumnMetadata c : this.rowMetadata.getColumns()) {
            if (!c.getColumnName().equals(columnName)) continue;
            return c;
        }
        throw new IllegalArgumentException("Column not found : " + columnName);
    }

    @Override
    public boolean hasProperty(RowMetadata entityType, String[] propertyPath) {
        if (propertyPath.length > 1) {
            throw new IllegalStateException("Nested attributes are not supported");
        }
        String columnName = propertyPath[0];
        for (ColumnMetadata c : this.rowMetadata.getColumns()) {
            if (!c.getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEmbeddedProperty(RowMetadata entityType, String[] propertyPath) {
        return false;
    }

    @Override
    public boolean isRepeatedProperty(RowMetadata entityType, String[] propertyPath) {
        return false;
    }

    public static final class RowMetadata {
        private final ColumnMetadata[] columns;

        RowMetadata(ColumnMetadata[] columns) {
            this.columns = columns;
        }

        public ColumnMetadata[] getColumns() {
            return this.columns;
        }
    }

    public static final class ColumnMetadata {
        private final int columnIndex;
        private final String columnName;
        private final Class<?> type;

        public ColumnMetadata(int columnIndex, String columnName, Class<?> type) {
            this.columnIndex = columnIndex;
            this.columnName = columnName;
            this.type = type;
        }

        public Object getValue(Object instance) {
            return ((Object[])instance)[this.columnIndex];
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getPropertyType() {
            return this.type;
        }

        public String toString() {
            return "ColumnMetadata{columnIndex=" + this.columnIndex + ", columnName='" + this.columnName + "', type=" + this.type + "}";
        }
    }
}

