/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.List;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.FunctionalCapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.wildfly.clustering.ejb.DeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanConfiguration;
import org.wildfly.clustering.ejb.bean.BeanDeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagementProvider;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupListenerServiceConfigurator;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupManagerServiceConfigurator;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagementConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerFactoryServiceConfigurator;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.server.service.ProvidedCacheServiceConfigurator;
import org.wildfly.clustering.server.service.group.DistributedCacheGroupServiceConfiguratorProvider;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.common.function.Functions;

public class InfinispanBeanManagementProvider
implements BeanManagementProvider {
    private final String name;
    private final InfinispanBeanManagementConfiguration config;

    public InfinispanBeanManagementProvider(String name, InfinispanBeanManagementConfiguration config) {
        this.name = name;
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public Iterable<CapabilityServiceConfigurator> getDeploymentServiceConfigurators(BeanDeploymentConfiguration configuration) {
        String containerName = this.config.getContainerName();
        String templateCacheName = this.config.getCacheName();
        String cacheName = configuration.getDeploymentName();
        Consumer<ConfigurationBuilder> configurator = builder -> {
            Integer size;
            ExpirationConfiguration expiration = builder.expiration().create();
            if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                builder.expiration().lifespan(-1L).maxIdle(-1L);
                InfinispanEjbLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, templateCacheName));
            }
            EvictionStrategy strategy = (size = this.config.getMaxActiveBeans()) != null ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
            builder.memory().storage(StorageType.HEAP).whenFull(strategy).maxCount(size != null ? size.longValue() : 0L);
            if (strategy.isEnabled()) {
                ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(InfinispanBeanGroupKey.class::isInstance);
            }
        };
        TemplateConfigurationServiceConfigurator configurationConfigurator = new TemplateConfigurationServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CONFIGURATION.getName()).append(new String[]{containerName, cacheName}), containerName, cacheName, templateCacheName, configurator);
        CacheServiceConfigurator cacheConfigurator = new CacheServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CACHE.getName()).append(new String[]{containerName, cacheName}), containerName, cacheName);
        ProvidedCacheServiceConfigurator groupConfigurator = new ProvidedCacheServiceConfigurator(DistributedCacheGroupServiceConfiguratorProvider.class, containerName, cacheName);
        FunctionalCapabilityServiceConfigurator marshallerConfigurator = new FunctionalCapabilityServiceConfigurator(configuration.getDeploymentServiceName().append(new String[]{this.name, "marshaller"}), this.config.getMarshallerFactory(), Functions.constantSupplier((Object)configuration));
        InfinispanBeanGroupManagerServiceConfigurator groupManagerConfigurator = new InfinispanBeanGroupManagerServiceConfigurator((DeploymentConfiguration)configuration, (SupplierDependency<Cache<?, ?>>)new ServiceSupplierDependency((ServiceNameProvider)cacheConfigurator), (SupplierDependency<ByteBufferMarshaller>)new ServiceSupplierDependency((ServiceNameProvider)marshallerConfigurator));
        InfinispanBeanGroupListenerServiceConfigurator groupListenerConfigurator = new InfinispanBeanGroupListenerServiceConfigurator(cacheConfigurator.getServiceName().append(new String[]{"listener"}), (SupplierDependency<Cache<?, ?>>)new ServiceSupplierDependency((ServiceNameProvider)cacheConfigurator), new ServiceSupplierDependency((ServiceNameProvider)marshallerConfigurator));
        return List.of(configurationConfigurator, cacheConfigurator, groupConfigurator, marshallerConfigurator, groupManagerConfigurator, groupListenerConfigurator);
    }

    public CapabilityServiceConfigurator getBeanManagerFactoryServiceConfigurator(BeanConfiguration context) {
        return new InfinispanBeanManagerFactoryServiceConfigurator(context, this.config);
    }
}

