/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.spec;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.ValidatableMetadata;
import org.jboss.jca.common.api.metadata.spec.Icon;
import org.jboss.jca.common.api.metadata.spec.IdDecoratedMetadata;
import org.jboss.jca.common.api.metadata.spec.LicenseType;
import org.jboss.jca.common.api.metadata.spec.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.spec.MergeableMetadata;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.XsdString;

public interface Connector
extends IdDecoratedMetadata,
ValidatableMetadata,
MergeableMetadata<Connector>,
CopyableMetaData {
    public XsdString getVendorName();

    public XsdString getEisType();

    public LicenseType getLicense();

    public ResourceAdapter getResourceadapter();

    public XsdString getResourceadapterVersion();

    public List<LocalizedXsdString> getDescriptions();

    public List<LocalizedXsdString> getDisplayNames();

    public List<Icon> getIcons();

    public Version getVersion();

    public List<String> getRequiredWorkContexts();

    public String getModuleName();

    public boolean isMetadataComplete();

    public static enum Version {
        UNKNOWN(null),
        V_10("1.0"),
        V_15("1.5"),
        V_16("1.6"),
        V_17("1.7"),
        V_20("2.0"),
        V_21("2.1");

        private String name;
        private static final Map<String, Version> MAP;

        private Version(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Version value(String v) {
            this.name = v;
            return this;
        }

        public static Version forName(String localName) {
            Version element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Version> map = new HashMap<String, Version>();
            for (Version element : Version.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

