/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.BroadcastEndpoint;
import org.hornetq.api.core.BroadcastEndpointFactory;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfigurationCompatibilityHelper;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.conf.PlainConfigurator;
import org.jgroups.conf.ProtocolStackConfigurator;

public final class JGroupsBroadcastGroupConfiguration
implements BroadcastEndpointFactoryConfiguration,
DiscoveryGroupConfigurationCompatibilityHelper {
    private static final long serialVersionUID = 8952238567248461285L;
    private final BroadcastEndpointFactory factory;

    public JGroupsBroadcastGroupConfiguration(final String jgroupsFile, final String channelName) {
        this.factory = new BroadcastEndpointFactory(){
            private static final long serialVersionUID = 1047956472941098435L;

            @Override
            public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
                JGroupsBroadcastEndpoint endpoint = new JGroupsBroadcastEndpoint();
                endpoint.initChannel(jgroupsFile, channelName);
                return endpoint;
            }
        };
    }

    public JGroupsBroadcastGroupConfiguration(final JChannel channel, final String channelName) {
        this.factory = new BroadcastEndpointFactory(){
            private static final long serialVersionUID = 5110372849181145377L;

            @Override
            public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
                JGroupsBroadcastEndpoint endpoint = new JGroupsBroadcastEndpoint();
                endpoint.initChannel(channel, channelName);
                return endpoint;
            }
        };
    }

    @Override
    public BroadcastEndpointFactory createBroadcastEndpointFactory() {
        return this.factory;
    }

    @Override
    public String getLocalBindAddress() {
        return null;
    }

    @Override
    public int getLocalBindPort() {
        return -1;
    }

    @Override
    public String getGroupAddress() {
        return null;
    }

    @Override
    public int getGroupPort() {
        return -1;
    }

    private static final class JGroupsBroadcastEndpoint
    implements BroadcastEndpoint {
        private boolean clientOpened;
        private boolean broadcastOpened;
        private JChannelWrapper<?> channel;
        private JGroupsReceiver receiver;

        private JGroupsBroadcastEndpoint() {
        }

        @Override
        public void broadcast(byte[] data) throws Exception {
            if (this.broadcastOpened) {
                Message msg = new Message();
                msg.setBuffer(data);
                this.channel.send(msg);
            }
        }

        @Override
        public byte[] receiveBroadcast() throws Exception {
            if (this.clientOpened) {
                return this.receiver.receiveBroadcast();
            }
            return null;
        }

        @Override
        public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
            if (this.clientOpened) {
                return this.receiver.receiveBroadcast(time, unit);
            }
            return null;
        }

        @Override
        public synchronized void openClient() throws Exception {
            if (this.clientOpened) {
                return;
            }
            this.internalOpen();
            this.receiver = new JGroupsReceiver();
            this.channel.setReceiver(this.receiver);
            this.clientOpened = true;
        }

        @Override
        public synchronized void openBroadcaster() throws Exception {
            if (this.broadcastOpened) {
                return;
            }
            this.internalOpen();
            this.broadcastOpened = true;
        }

        private void initChannel(String jgroupsConfig, String channelName) throws Exception {
            PlainConfigurator configurator = new PlainConfigurator(jgroupsConfig);
            try {
                this.channel = JChannelManager.getJChannel(channelName, configurator);
                return;
            }
            catch (Exception e) {
                this.channel = null;
                URL configURL = Thread.currentThread().getContextClassLoader().getResource(jgroupsConfig);
                if (configURL == null) {
                    throw new RuntimeException("couldn't find JGroups configuration " + jgroupsConfig);
                }
                this.channel = JChannelManager.getJChannel(channelName, configURL);
                return;
            }
        }

        private void initChannel(JChannel channel1, String channelName) throws Exception {
            this.channel = JChannelManager.getJChannel(channelName, channel1);
        }

        protected void internalOpen() throws Exception {
            this.channel.connect();
        }

        @Override
        public synchronized void close(boolean isBroadcast) throws Exception {
            if (isBroadcast) {
                this.broadcastOpened = false;
            } else {
                this.channel.removeReceiver(this.receiver);
                this.clientOpened = false;
            }
            this.channel.close();
        }

        private static class JChannelManager {
            private static Map<String, JChannelWrapper<?>> channels;

            private JChannelManager() {
            }

            public static synchronized <T> JChannelWrapper<?> getJChannel(String channelName, T t) throws Exception {
                JChannelWrapper<Object> wrapper;
                if (channels == null) {
                    channels = new HashMap();
                }
                if ((wrapper = channels.get(channelName)) == null) {
                    wrapper = new JChannelWrapper<T>(channelName, t);
                    channels.put(channelName, wrapper);
                    return wrapper;
                }
                return wrapper.addRef();
            }

            public static synchronized void closeChannel(String channelName, JChannel channel) {
                channel.setReceiver(null);
                channel.disconnect();
                channel.close();
                JChannelWrapper<?> wrapper = channels.remove(channelName);
                if (wrapper == null) {
                    throw new IllegalStateException("Did not find channel " + channelName);
                }
            }
        }

        private static class JChannelWrapper<T> {
            int refCount = 1;
            JChannel channel;
            String channelName;
            List<JGroupsReceiver> receivers = new ArrayList<JGroupsReceiver>();

            public JChannelWrapper(String channelName, T t) throws Exception {
                this.channelName = channelName;
                if (t instanceof URL) {
                    this.channel = new JChannel((URL)t);
                } else if (t instanceof JChannel) {
                    this.channel = (JChannel)t;
                } else if (t instanceof PlainConfigurator) {
                    this.channel = new JChannel((ProtocolStackConfigurator)((PlainConfigurator)t));
                } else {
                    throw new IllegalArgumentException("Unsupported type " + t);
                }
            }

            public synchronized void close() {
                --this.refCount;
                if (this.refCount == 0) {
                    JChannelManager.closeChannel(this.channelName, this.channel);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeReceiver(JGroupsReceiver receiver) {
                List<JGroupsReceiver> list = this.receivers;
                synchronized (list) {
                    this.receivers.remove((Object)receiver);
                }
            }

            public synchronized void connect() throws Exception {
                if (this.channel.isConnected()) {
                    return;
                }
                this.channel.setReceiver((Receiver)new ReceiverAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void receive(Message msg) {
                        List<JGroupsReceiver> list = JChannelWrapper.this.receivers;
                        synchronized (list) {
                            for (JGroupsReceiver r : JChannelWrapper.this.receivers) {
                                r.receive(msg);
                            }
                        }
                    }
                });
                this.channel.connect(this.channelName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setReceiver(JGroupsReceiver jGroupsReceiver) {
                List<JGroupsReceiver> list = this.receivers;
                synchronized (list) {
                    this.receivers.add(jGroupsReceiver);
                }
            }

            public void send(Message msg) throws Exception {
                this.channel.send(msg);
            }

            public JChannelWrapper<T> addRef() {
                ++this.refCount;
                return this;
            }

            public String toString() {
                return "JChannelWrapper of [" + this.channel + "] " + this.refCount + " " + this.channelName;
            }
        }

        private static final class JGroupsReceiver
        extends ReceiverAdapter {
            private final BlockingQueue<byte[]> dequeue = new LinkedBlockingDeque<byte[]>();

            private JGroupsReceiver() {
            }

            public void receive(Message msg) {
                this.dequeue.add(msg.getBuffer());
            }

            public byte[] receiveBroadcast() throws Exception {
                return this.dequeue.take();
            }

            public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
                return this.dequeue.poll(time, unit);
            }
        }
    }
}

