/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Weight;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.util.common.AssertionFailure;

public class StoredFieldsValuesDelegate {
    private final NestedDocsProvider nestedDocsProvider;
    private final Weight childrenWeight;
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private ChildDocIds currentLeafChildDocs;
    private LeafReader currentLeafReader;
    private int currentRootDoc;
    private Document currentRootDocValue;
    private final IntObjectMap<Document> currentChildDocValues;

    public StoredFieldsValuesDelegate(NestedDocsProvider nestedDocsProvider, ReusableDocumentStoredFieldVisitor storedFieldVisitor, IndexSearcher indexSearcher) throws IOException {
        this.childrenWeight = nestedDocsProvider == null ? null : nestedDocsProvider.childDocsWeight(indexSearcher);
        this.nestedDocsProvider = nestedDocsProvider;
        this.storedFieldVisitor = storedFieldVisitor;
        this.currentChildDocValues = nestedDocsProvider == null ? null : new IntObjectHashMap();
    }

    public String toString() {
        return "StoredFieldsValues{storedFieldVisitor=" + (Object)((Object)this.storedFieldVisitor) + '}';
    }

    void context(LeafReaderContext context) throws IOException {
        this.currentLeafReader = context.reader();
        this.currentLeafChildDocs = this.nestedDocsProvider == null ? null : this.nestedDocsProvider.childDocs(this.childrenWeight, context, null);
        this.currentRootDoc = -1;
        this.currentRootDocValue = null;
        if (this.currentChildDocValues != null) {
            this.currentChildDocValues.clear();
        }
    }

    void collect(int parentDoc) throws IOException {
        this.currentRootDoc = parentDoc;
        if (this.currentLeafChildDocs != null && this.currentLeafChildDocs.advanceExactParent(parentDoc)) {
            int childDoc = this.currentLeafChildDocs.nextChild();
            while (childDoc != Integer.MAX_VALUE) {
                this.currentLeafReader.document(childDoc, (StoredFieldVisitor)this.storedFieldVisitor);
                this.currentChildDocValues.put(childDoc, (Object)this.storedFieldVisitor.getDocumentAndReset());
                childDoc = this.currentLeafChildDocs.nextChild();
            }
        }
        this.currentLeafReader.document(parentDoc, (StoredFieldVisitor)this.storedFieldVisitor);
        this.currentRootDocValue = this.storedFieldVisitor.getDocumentAndReset();
    }

    public Document get(int docId) {
        if (docId == this.currentRootDoc) {
            return this.currentRootDocValue;
        }
        Document doc = (Document)this.currentChildDocValues.get(docId);
        if (doc == null) {
            throw new AssertionFailure("Getting value for " + docId + ", which is neither root document " + this.currentRootDoc + " nor children " + this.currentChildDocValues.keys());
        }
        return doc;
    }

    public static class Factory {
        private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
        private final Set<String> requiredNestedDocumentPathsForStoredFields;

        public Factory(ReusableDocumentStoredFieldVisitor storedFieldVisitor, Set<String> requiredNestedDocumentPathsForStoredFields) {
            this.storedFieldVisitor = storedFieldVisitor;
            this.requiredNestedDocumentPathsForStoredFields = requiredNestedDocumentPathsForStoredFields;
        }

        public StoredFieldsValuesDelegate create(CollectorExecutionContext context) throws IOException {
            NestedDocsProvider nestedDocsProvider = this.requiredNestedDocumentPathsForStoredFields.isEmpty() ? null : context.createNestedDocsProvider(this.requiredNestedDocumentPathsForStoredFields);
            return new StoredFieldsValuesDelegate(nestedDocsProvider, this.storedFieldVisitor, context.getIndexSearcher());
        }
    }
}

