/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.Iterator;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestBuilder;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public class DefaultOperationRequestBuilder
implements OperationRequestBuilder {
    private ModelNode request = new ModelNode();
    private OperationRequestAddress prefix;

    public DefaultOperationRequestBuilder() {
        this.prefix = new DefaultOperationRequestAddress();
    }

    public DefaultOperationRequestBuilder(OperationRequestAddress prefix) {
        this.prefix = new DefaultOperationRequestAddress((OperationRequestAddress)Assert.checkNotNullParam((String)"prefix", (Object)prefix));
    }

    public OperationRequestAddress getAddress() {
        return this.prefix;
    }

    @Override
    public ModelNode buildRequest() throws OperationFormatException {
        ModelNode address = this.request.get("address");
        if (this.prefix.isEmpty()) {
            address.setEmptyList();
        } else {
            Iterator iterator = this.prefix.iterator();
            while (iterator.hasNext()) {
                OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    address.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("The node name is not specified for type '" + node.getType() + "'");
            }
        }
        if (!this.request.hasDefined("operation")) {
            throw new OperationFormatException("The operation name is missing or the format of the operation request is wrong.");
        }
        return this.request;
    }

    @Override
    public void setOperationName(String name) {
        this.request.get("operation").set(name);
    }

    @Override
    public void addNode(String type, String name) {
        this.prefix.toNode(type, name);
    }

    @Override
    public void addNodeType(String type) {
        this.prefix.toNodeType(type);
    }

    @Override
    public void addNodeName(String name) {
        this.prefix.toNode(name);
    }

    @Override
    public void addProperty(String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument name is not specified: '" + name + "'");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument value is not specified for " + name + ": '" + value + "'");
        }
        ModelNode toSet = null;
        try {
            toSet = ModelNode.fromString((String)value);
        }
        catch (Exception e) {
            toSet = new ModelNode().set(value);
        }
        this.request.get(name).set(toSet);
    }

    public ModelNode getModelNode() {
        return this.request;
    }
}

