/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.spi.core.protocol.AbstractRemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public class ActiveMQProtonRemotingConnection
extends AbstractRemotingConnection {
    private final AMQPConnectionContext amqpConnection;
    private final ProtonProtocolManager manager;

    public ActiveMQProtonRemotingConnection(ProtonProtocolManager manager, AMQPConnectionContext amqpConnection, Connection transportConnection, Executor connectionExecutor) {
        super(transportConnection, connectionExecutor);
        this.manager = manager;
        this.amqpConnection = amqpConnection;
    }

    public AMQPConnectionContext getAmqpConnection() {
        return this.amqpConnection;
    }

    public ProtonProtocolManager getManager() {
        return this.manager;
    }

    public void scheduledFlush() {
        this.amqpConnection.scheduledFlush();
    }

    public void fail(ActiveMQException me, String scaleDownTargetNodeID) {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!(me instanceof ActiveMQRemoteDisconnectException)) {
            ActiveMQClientLogger.LOGGER.connectionFailureDetected(this.amqpConnection.getConnectionCallback().getTransportConnection().getRemoteAddress(), me.getMessage(), me.getType());
        }
        this.callFailureListeners(me, scaleDownTargetNodeID);
        this.callClosingListeners();
        this.internalClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ActiveMQProtonRemotingConnection activeMQProtonRemotingConnection = this;
        synchronized (activeMQProtonRemotingConnection) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        this.callClosingListeners();
        this.internalClose();
    }

    public void disconnect(boolean criticalError) {
        ErrorCondition errorCondition = new ErrorCondition();
        errorCondition.setCondition(AmqpSupport.CONNECTION_FORCED);
        this.amqpConnection.close(errorCondition);
    }

    public void disconnect(String scaleDownNodeID, boolean criticalError) {
        this.disconnect(criticalError);
    }

    public boolean checkDataReceived() {
        return this.amqpConnection.checkDataReceived();
    }

    public void flush() {
        this.amqpConnection.flush();
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        this.amqpConnection.inputBuffer(buffer.byteBuf());
        super.bufferReceived(connectionID, buffer);
    }

    private void internalClose() {
        this.getTransportConnection().close();
    }

    public Subject getSubject() {
        SASLResult saslResult = this.amqpConnection.getSASLResult();
        if (saslResult != null && saslResult.getSubject() != null) {
            return saslResult.getSubject();
        }
        return super.getSubject();
    }

    public boolean isSupportsFlowControl() {
        return true;
    }

    public String getProtocolName() {
        return "AMQP";
    }

    public String getClientID() {
        return this.amqpConnection.getRemoteContainer();
    }

    public void open() {
        this.amqpConnection.open();
    }
}

