/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ApplicationClientStructureProcessor
implements DeploymentUnitProcessor {
    private final String deployment;

    public ApplicationClientStructureProcessor(String deployment) {
        this.deployment = deployment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentUnitName = deploymentUnit.getName().toLowerCase(Locale.ENGLISH);
        if (deploymentUnitName.endsWith(".ear")) {
            HashMap<VirtualFile, ResourceRoot> existing = new HashMap<VirtualFile, ResourceRoot>();
            for (ResourceRoot additional : deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS)) {
                existing.put(additional.getRoot(), additional);
            }
            ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile appClientRoot = root.getRoot().getChild(this.deployment);
            if (!appClientRoot.exists()) throw AppClientLogger.ROOT_LOGGER.cannotFindAppClient(this.deployment);
            if (existing.containsKey(appClientRoot)) {
                ResourceRoot existingRoot = (ResourceRoot)existing.get(appClientRoot);
                SubDeploymentMarker.mark((ResourceRoot)existingRoot);
                ModuleRootMarker.mark((ResourceRoot)existingRoot);
                return;
            } else {
                Closeable closable = appClientRoot.isFile() ? ApplicationClientStructureProcessor.mount(appClientRoot, false) : null;
                MountHandle mountHandle = MountHandle.create((Closeable)closable);
                ResourceRoot childResource = new ResourceRoot(appClientRoot, mountHandle);
                ModuleRootMarker.mark((ResourceRoot)childResource);
                SubDeploymentMarker.mark((ResourceRoot)childResource);
                deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, (Object)childResource);
            }
            return;
        } else {
            ResourceRoot root;
            ResourceRoot parentRoot;
            VirtualFile appClientRoot;
            if (deploymentUnit.getParent() == null || !deploymentUnitName.endsWith(".jar") || !(appClientRoot = (parentRoot = (ResourceRoot)deploymentUnit.getParent().getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild(this.deployment)).equals((root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot())) return;
            DeploymentTypeMarker.setType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit);
        }
    }

    private static Closeable mount(VirtualFile moduleFile, boolean explode) throws DeploymentUnitProcessingException {
        try {
            return explode ? VFS.mountZipExpanded((VirtualFile)moduleFile, (VirtualFile)moduleFile, (TempFileProvider)TempFileProviderService.provider()) : VFS.mountZip((VirtualFile)moduleFile, (VirtualFile)moduleFile, (TempFileProvider)TempFileProviderService.provider());
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }
}

