/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.Filter;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.Restrictable;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.basic.BasicResult;

public interface PluralAttributeMapping
extends AttributeMapping,
TableGroupJoinProducer,
FetchableContainer,
Loadable,
Restrictable {
    public CollectionPersister getCollectionDescriptor();

    public ForeignKeyDescriptor getKeyDescriptor();

    public CollectionPart getIndexDescriptor();

    @Override
    public CollectionMappingType<?> getMappedType();

    public IndexMetadata getIndexMetadata();

    public CollectionPart getElementDescriptor();

    public CollectionIdentifierDescriptor getIdentifierDescriptor();

    public OrderByFragment getOrderByFragment();

    public OrderByFragment getManyToManyOrderByFragment();

    @Override
    default public void visitKeyFetchables(Consumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        CollectionPart indexDescriptor = this.getIndexDescriptor();
        if (indexDescriptor != null) {
            fetchableConsumer.accept(indexDescriptor);
        }
    }

    @Override
    default public int getNumberOfKeyFetchables() {
        return this.getIndexDescriptor() == null ? 0 : 1;
    }

    @Override
    default public Fetchable getKeyFetchable(int position) {
        CollectionPart indexDescriptor = this.getIndexDescriptor();
        if (indexDescriptor != null && position == 0) {
            return indexDescriptor;
        }
        throw new IndexOutOfBoundsException(position);
    }

    @Override
    default public void visitKeyFetchables(IndexedConsumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        CollectionPart indexDescriptor = this.getIndexDescriptor();
        if (indexDescriptor != null) {
            fetchableConsumer.accept(0, indexDescriptor);
        }
    }

    @Override
    default public void visitFetchables(Consumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        fetchableConsumer.accept(this.getElementDescriptor());
    }

    @Override
    default public int getNumberOfFetchables() {
        return 1;
    }

    @Override
    default public int getNumberOfFetchableKeys() {
        return this.getNumberOfKeyFetchables() + this.getNumberOfFetchables();
    }

    @Override
    default public void visitFetchables(IndexedConsumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        fetchableConsumer.accept(0, this.getElementDescriptor());
    }

    @Override
    default public Fetchable getFetchable(int position) {
        if (position == 0) {
            return this.getElementDescriptor();
        }
        throw new IndexOutOfBoundsException(position);
    }

    @Override
    default public <T> DomainResult<T> createSnapshotDomainResult(NavigablePath navigablePath, TableGroup parentTableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new BasicResult(0, null, this.getJavaType());
    }

    public String getSeparateCollectionTable();

    public boolean isBidirectionalAttributeName(NavigablePath var1, ToOneAttributeMapping var2);

    @Override
    default public boolean incrementFetchDepth() {
        return true;
    }

    @Override
    default public void applyFilterRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, SqlAstCreationState creationState) {
        this.getCollectionDescriptor().applyFilterRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, creationState);
    }

    @Override
    default public void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.getCollectionDescriptor().applyBaseRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, treatAsDeclarations, creationState);
    }

    default public void applyBaseManyToManyRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.getCollectionDescriptor().applyBaseManyToManyRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, treatAsDeclarations, creationState);
    }

    @Override
    default public void applyWhereRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, SqlAstCreationState creationState) {
        this.getCollectionDescriptor().applyWhereRestrictions(predicateConsumer, tableGroup, useQualifier, creationState);
    }

    @Override
    default public PluralAttributeMapping asPluralAttributeMapping() {
        return this;
    }

    @Override
    default public boolean isPluralAttributeMapping() {
        return true;
    }

    @Override
    @Deprecated(forRemoval=true)
    default public List<JdbcMapping> getJdbcMappings() {
        ArrayList<JdbcMapping> results = new ArrayList<JdbcMapping>();
        this.forEachJdbcType((index, jdbcMapping) -> results.add((JdbcMapping)jdbcMapping));
        return results;
    }

    public static interface IndexMetadata {
        public CollectionPart getIndexDescriptor();

        public int getListIndexBase();

        public String getIndexPropertyName();
    }
}

