/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security.sasl;

import java.io.IOException;
import java.security.Principal;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.security.DomainServerCredential;
import org.jboss.as.server.security.DomainServerEvidence;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.sasl.util.SaslWrapper;

final class DomainServerSaslServer
implements SaslServer,
SaslWrapper {
    private final SecurityDomain securityDomain;
    private final Predicate<Evidence> evidenceVerifier;
    private final CallbackHandler callbackHandler;
    private boolean complete;
    private String authorizedId;

    public DomainServerSaslServer(SecurityDomain securityDomain, Predicate<Evidence> evidenceVerifier, CallbackHandler callbackHandler) {
        this.securityDomain = securityDomain;
        this.evidenceVerifier = evidenceVerifier;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ServerLogger.AS_ROOT_LOGGER.mechAuthenticationNotComplete();
        }
        return this.authorizedId;
    }

    @Override
    public String getMechanismName() {
        return "JBOSS-DOMAIN-SERVER";
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String token;
        String loginName;
        if (this.complete) {
            throw ServerLogger.AS_ROOT_LOGGER.mechMessageAfterComplete().toSaslException();
        }
        this.complete = true;
        if (response.length >= 65536) {
            throw ServerLogger.AS_ROOT_LOGGER.mechMessageTooLong().toSaslException();
        }
        CodePointIterator i = CodePointIterator.ofUtf8Bytes((byte[])response);
        try {
            CodePointIterator delimIter = i.delimitedBy(new int[]{0});
            loginName = delimIter.drainToString();
            i.next();
            token = delimIter.drainToString();
        }
        catch (NoSuchElementException ignored) {
            throw ServerLogger.AS_ROOT_LOGGER.mechInvalidMessageReceived().toSaslException();
        }
        NamePrincipal namePrincipal = new NamePrincipal(loginName);
        DomainServerEvidence evidence = new DomainServerEvidence((Principal)namePrincipal, token);
        if (!this.evidenceVerifier.test(evidence)) {
            throw ServerLogger.AS_ROOT_LOGGER.mechTokenNotVerified().toSaslException();
        }
        SecurityIdentity identity = this.securityDomain.createAdHocIdentity((Principal)namePrincipal);
        identity = identity.withPrivateCredential((Credential)new DomainServerCredential(token));
        identity = identity.withDefaultRoleMapper(RoleMapper.constant((Roles)Roles.of((String)"JBOSS-DOMAIN-SERVER")));
        final CachedIdentity cachedIdentity = new CachedIdentity("JBOSS-DOMAIN-SERVER", false, identity);
        CachedIdentityAuthorizeCallback ciac = new CachedIdentityAuthorizeCallback(new IdentityCache(){

            public CachedIdentity remove() {
                return cachedIdentity;
            }

            public void put(SecurityIdentity identity) {
            }

            public CachedIdentity get() {
                return cachedIdentity;
            }
        });
        try {
            this.callbackHandler.handle(new Callback[]{ciac});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ServerLogger.AS_ROOT_LOGGER.mechServerSideAuthenticationFailed(e).toSaslException();
        }
        if (!ciac.isAuthorized()) {
            throw ServerLogger.AS_ROOT_LOGGER.mechAuthorizationFailed(loginName, namePrincipal.getName()).toSaslException();
        }
        this.authorizedId = namePrincipal.getName();
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ServerLogger.AS_ROOT_LOGGER.mechNoSecurityLayer();
        }
        throw ServerLogger.AS_ROOT_LOGGER.mechAuthenticationNotComplete();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ServerLogger.AS_ROOT_LOGGER.mechNoSecurityLayer();
        }
        throw ServerLogger.AS_ROOT_LOGGER.mechAuthenticationNotComplete();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw ServerLogger.AS_ROOT_LOGGER.mechAuthenticationNotComplete();
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

