/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.injection.weld;

import jakarta.el.ELContextListener;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationWrapper;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.jsf.injection.weld.DummyELResolver;
import org.jboss.as.jsf.injection.weld.ForwardingELResolver;
import org.jboss.weld.module.web.el.WeldELContextListener;

public class WeldApplication
extends ApplicationWrapper {
    private final Application application;
    private final AdjustableELResolver elResolver;
    private volatile ExpressionFactory expressionFactory;
    private volatile boolean initialized = false;
    private volatile BeanManager beanManager;

    public WeldApplication(Application application) {
        this.application = application;
        application.addELContextListener((ELContextListener)new WeldELContextListener());
        this.elResolver = new AdjustableELResolver();
        this.elResolver.setDelegate(new DummyELResolver());
        application.addELResolver((ELResolver)this.elResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.initialized) {
            WeldApplication weldApplication = this;
            synchronized (weldApplication) {
                if (!this.initialized) {
                    if (this.beanManager() != null) {
                        this.elResolver.setDelegate(this.beanManager().getELResolver());
                    }
                    this.initialized = true;
                }
            }
        }
    }

    public Application getWrapped() {
        this.init();
        return this.application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            this.init();
            WeldApplication weldApplication = this;
            synchronized (weldApplication) {
                if (this.expressionFactory == null) {
                    BeanManager bm = this.beanManager();
                    this.expressionFactory = bm == null ? this.application.getExpressionFactory() : bm.wrapExpressionFactory(this.application.getExpressionFactory());
                }
            }
        }
        return this.expressionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanManager beanManager() {
        if (this.beanManager == null) {
            WeldApplication weldApplication = this;
            synchronized (weldApplication) {
                if (this.beanManager == null) {
                    try {
                        this.beanManager = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
                    }
                    catch (IllegalArgumentException | NamingException e) {
                        return null;
                    }
                }
            }
        }
        return this.beanManager;
    }

    private static class AdjustableELResolver
    extends ForwardingELResolver {
        private ELResolver delegate;

        private AdjustableELResolver() {
        }

        public void setDelegate(ELResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ELResolver delegate() {
            return this.delegate;
        }
    }
}

