/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;
import org.wildfly.clustering.ee.infinispan.CacheEntryComputeMutator;
import org.wildfly.clustering.ejb.cache.timer.DefaultImmutableTimerMetaData;
import org.wildfly.clustering.ejb.cache.timer.DefaultTimerMetaData;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.MutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.cache.timer.TimerIndexKey;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntryFunction;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerIndexKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataKey;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerMetaData;

public class InfinispanTimerMetaDataFactory<I, C>
implements TimerMetaDataFactory<I, RemappableTimerMetaDataEntry<C>, C> {
    private final Cache<TimerIndexKey, I> indexCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> readCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> writeCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> removeCache;
    private final TimerMetaDataConfiguration<C> config;

    public InfinispanTimerMetaDataFactory(InfinispanTimerMetaDataConfiguration<C> config) {
        this.config = config;
        this.indexCache = config.getCache();
        this.readCache = config.getReadForUpdateCache();
        this.writeCache = config.getSilentWriteCache();
        this.removeCache = config.getCache();
    }

    public RemappableTimerMetaDataEntry<C> createValue(I id, Map.Entry<RemappableTimerMetaDataEntry<C>, TimerIndex> entry) {
        RemappableTimerMetaDataEntry<C> metaData = entry.getKey();
        TimerIndex index = entry.getValue();
        if (index != null && this.indexCache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).putIfAbsent((Object)new InfinispanTimerIndexKey(index), id) != null) {
            return null;
        }
        this.writeCache.put(new InfinispanTimerMetaDataKey<I>(id), metaData);
        return metaData;
    }

    public RemappableTimerMetaDataEntry<C> findValue(I id) {
        return (RemappableTimerMetaDataEntry)this.readCache.get(new InfinispanTimerMetaDataKey<I>(id));
    }

    public boolean remove(I id) {
        return this.removeCache.remove(new InfinispanTimerMetaDataKey<I>(id)) != null;
    }

    public TimerMetaData createTimerMetaData(I id, RemappableTimerMetaDataEntry<C> entry) {
        Duration lastTimeout = entry.getLastTimeout();
        OffsetValue lastTimeoutOffset = OffsetValue.from((Duration)Optional.ofNullable(lastTimeout).orElse(Duration.ZERO));
        CacheEntryComputeMutator mutator = new CacheEntryComputeMutator(this.writeCache, new InfinispanTimerMetaDataKey<I>(id), (BiFunction)new TimerMetaDataEntryFunction(lastTimeoutOffset));
        return new DefaultTimerMetaData(this.config, (TimerMetaDataEntry)(lastTimeout != null ? new MutableTimerMetaDataEntry((ImmutableTimerMetaDataEntry)entry, lastTimeoutOffset) : entry), (Mutator)mutator);
    }

    public ImmutableTimerMetaData createImmutableTimerMetaData(RemappableTimerMetaDataEntry<C> entry) {
        return new DefaultImmutableTimerMetaData(this.config, entry);
    }
}

