/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.formatters;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;

public class CustomFormatterResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "custom-formatter";
    public static final ObjectTypeAttributeDefinition CUSTOM_FORMATTER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"custom-formatter", (AttributeDefinition[])new AttributeDefinition[]{CommonAttributes.CLASS, CommonAttributes.MODULE, CommonAttributes.PROPERTIES}).setAllowExpression(false)).setRequired(false)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                CommonAttributes.MODULE.marshallAsAttribute(resourceModel, writer);
                CommonAttributes.CLASS.marshallAsAttribute(resourceModel, writer);
                if (resourceModel.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                    CommonAttributes.PROPERTIES.marshallAsElement(resourceModel, writer);
                }
                writer.writeEndElement();
            }
        }

        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.hasDefined(CommonAttributes.CLASS.getName());
        }
    })).build();
    private static final PathElement PATH = PathElement.pathElement((String)"custom-formatter");
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.CLASS, CommonAttributes.MODULE, CommonAttributes.PROPERTIES};
    private static final OperationStepHandler ADD = new LoggingOperations.LoggingAddOperationStepHandler(ATTRIBUTES){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            String className = CommonAttributes.CLASS.resolveModelAttribute(context, model).asString();
            ModelNode moduleNameNode = CommonAttributes.MODULE.resolveModelAttribute(context, model);
            String moduleName = moduleNameNode.isDefined() ? moduleNameNode.asString() : null;
            ModelNode properties = CommonAttributes.PROPERTIES.resolveModelAttribute(context, model);
            if (configuration != null) {
                if (!className.equals(configuration.getClassName()) || (moduleName == null ? configuration.getModuleName() != null : !moduleName.equals(configuration.getModuleName()))) {
                    LoggingLogger.ROOT_LOGGER.tracef("Replacing formatter '%s' at '%s'", name, context.getCurrentAddress());
                    logContextConfiguration.removeFormatterConfiguration(name);
                    configuration = logContextConfiguration.addFormatterConfiguration(moduleName, className, name, new String[0]);
                }
            } else {
                LoggingLogger.ROOT_LOGGER.tracef("Adding formatter '%s' at '%s'", name, context.getCurrentAddress());
                configuration = logContextConfiguration.addFormatterConfiguration(moduleName, className, name, new String[0]);
            }
            if (properties.isDefined()) {
                for (Property property : properties.asPropertyList()) {
                    configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                }
            }
        }
    };
    private static final OperationStepHandler WRITE = new LoggingOperations.LoggingWriteAttributeHandler(ATTRIBUTES){

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            block4: {
                FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(addressName);
                String modelClass = CommonAttributes.CLASS.resolveModelAttribute(context, context.readResource(PathAddress.EMPTY_ADDRESS).getModel()).asString();
                if (!CommonAttributes.PROPERTIES.getName().equals(attributeName) || !configuration.getClassName().equals(modelClass)) break block4;
                if (value.isDefined()) {
                    for (Property property : value.asPropertyList()) {
                        configuration.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                } else {
                    List names = configuration.getPropertyNames();
                    for (String name : names) {
                        configuration.removeProperty(name);
                    }
                }
            }
            return CommonAttributes.CLASS.getName().equals(attributeName) || CommonAttributes.MODULE.getName().equals(attributeName);
        }
    };
    private static final OperationStepHandler REMOVE = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.formatterNotFound(name));
            }
            logContextConfiguration.removeFormatterConfiguration(name);
        }
    };
    public static final CustomFormatterResourceDefinition INSTANCE = new CustomFormatterResourceDefinition();

    private CustomFormatterResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, LoggingExtension.getResourceDescriptionResolver(NAME)).setAddHandler(ADD).setRemoveHandler(REMOVE).setCapabilities(new RuntimeCapability[]{Capabilities.FORMATTER_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, WRITE);
        }
    }

    public static final class TransformerDefinition
    extends TransformerResourceDefinition {
        public TransformerDefinition() {
            super(PATH);
        }

        @Override
        public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        }
    }
}

