/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.lowlevel.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;

public final class Queries {
    private Queries() {
    }

    public static JsonObject matchAll() {
        JsonObject matchAll = new JsonObject();
        matchAll.add("match_all", (JsonElement)new JsonObject());
        return matchAll;
    }

    public static JsonObject term(String absoluteFieldPath, String value) {
        JsonObject predicate = new JsonObject();
        JsonObject innerObject = new JsonObject();
        predicate.add("term", (JsonElement)innerObject);
        innerObject.addProperty(absoluteFieldPath, value);
        return predicate;
    }

    public static JsonObject anyTerm(String absoluteFieldPath, Collection<String> values) {
        JsonObject predicate = new JsonObject();
        JsonObject innerObject = new JsonObject();
        predicate.add("terms", (JsonElement)innerObject);
        JsonArray terms = new JsonArray();
        innerObject.add(absoluteFieldPath, (JsonElement)terms);
        for (String value : values) {
            terms.add(value);
        }
        return predicate;
    }

    public static JsonObject boolFilter(JsonObject must, JsonArray filters) {
        if (filters == null || filters.size() == 0) {
            return must;
        }
        JsonObject predicate = new JsonObject();
        JsonObject innerObject = new JsonObject();
        predicate.add("bool", (JsonElement)innerObject);
        if (must != null) {
            innerObject.add("must", (JsonElement)must);
        }
        innerObject.add("filter", (JsonElement)filters);
        return predicate;
    }
}

