/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmMapper;

public final class MechanismRealmConfiguration {
    private final String realmName;
    private final Function<Principal, Principal> preRealmRewriter;
    private final Function<Principal, Principal> postRealmRewriter;
    private final Function<Principal, Principal> finalRewriter;
    private final RealmMapper realmMapper;
    public static final MechanismRealmConfiguration NO_REALM = new MechanismRealmConfiguration("none", Function.identity(), Function.identity(), Function.identity(), null);

    MechanismRealmConfiguration(String realmName, Function<Principal, Principal> preRealmRewriter, Function<Principal, Principal> postRealmRewriter, Function<Principal, Principal> finalRewriter, RealmMapper realmMapper) {
        this.realmName = realmName;
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
        this.realmMapper = realmMapper;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public Function<Principal, Principal> getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public Function<Principal, Principal> getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public Function<Principal, Principal> getFinalRewriter() {
        return this.finalRewriter;
    }

    public RealmMapper getRealmMapper() {
        return this.realmMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String realmName;
        private Function<Principal, Principal> preRealmRewriter = Function.identity();
        private Function<Principal, Principal> postRealmRewriter = Function.identity();
        private Function<Principal, Principal> finalRewriter = Function.identity();
        private RealmMapper realmMapper;

        Builder() {
        }

        public Builder setRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public Builder setPreRealmRewriter(Function<Principal, Principal> preRealmRewriter) {
            Assert.checkNotNullParam("preRealmRewriter", preRealmRewriter);
            this.preRealmRewriter = preRealmRewriter;
            return this;
        }

        public Builder setPostRealmRewriter(Function<Principal, Principal> postRealmRewriter) {
            Assert.checkNotNullParam("postRealmRewriter", postRealmRewriter);
            this.postRealmRewriter = postRealmRewriter;
            return this;
        }

        public Builder setFinalRewriter(Function<Principal, Principal> finalRewriter) {
            Assert.checkNotNullParam("finalRewriter", finalRewriter);
            this.finalRewriter = finalRewriter;
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            this.realmMapper = realmMapper;
            return this;
        }

        public MechanismRealmConfiguration build() {
            Assert.checkNotNullParam("realmName", this.realmName);
            return new MechanismRealmConfiguration(this.realmName, this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter, this.realmMapper);
        }
    }
}

